/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.block.decor;

import binnie.core.block.TileEntityMetadata;
import binnie.extratrees.ExtraTrees;
import binnie.extratrees.block.WoodManager;
import binnie.extratrees.block.decor.BlockFence;
import binnie.extratrees.block.decor.BlockMultiFence;
import binnie.extratrees.block.decor.FenceType;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.opengl.GL11;

public class FenceRenderer
implements ISimpleBlockRenderingHandler {
    public static int layer;

    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
        Tessellator tess = Tessellator.field_78398_a;
        for (int i = 0; i < 5; ++i) {
            float thickness = 0.125f;
            layer = 0;
            if (i == 0) {
                block.func_149676_a(0.5f - thickness, 0.0f, 0.0f, 0.5f + thickness, 1.0f, thickness * 2.0f);
            }
            if (i == 1) {
                block.func_149676_a(0.5f - thickness, 0.0f, 1.0f - thickness * 2.0f, 0.5f + thickness, 1.0f, 1.0f);
            }
            float s = 0.0625f;
            FenceType fenceType = block == ExtraTrees.blockMultiFence ? WoodManager.getFenceType(metadata) : new FenceType(0);
            boolean bottomBar = !fenceType.solid;
            float topBarMaxY = 1.0f - s;
            float topBarMinY = 1.0f - s * 3.0f;
            float bottomBarMaxY = 0.5f - s;
            float bottomBarMinY = 0.5f - s * 3.0f;
            if (fenceType.size == 2) {
                bottomBarMinY -= 4.0f * s;
                bottomBarMaxY -= 4.0f * s;
                topBarMinY -= 4.0f * s;
                topBarMaxY -= 4.0f * s;
            }
            if (fenceType.size == 1) {
                bottomBarMinY -= 4.0f * s;
                bottomBarMaxY -= 4.0f * s;
            }
            if (fenceType.solid) {
                topBarMinY = bottomBarMinY;
            }
            float minX = 0.5f - s;
            float maxX = 0.5f + s;
            float minZ = -s * 2.0f;
            float maxZ = 1.0f + s * 2.0f;
            if (i == 2) {
                block.func_149676_a(minX, topBarMinY, minZ, maxX, topBarMaxY, maxZ);
                layer = 1;
            } else if (i == 3) {
                if (!bottomBar) continue;
                block.func_149676_a(minX, bottomBarMinY, minZ, maxX, bottomBarMaxY, maxZ);
                layer = 1;
            } else if (i == 4) {
                if (fenceType.embossed) {
                    float maxY;
                    float minY;
                    minX -= s * 0.9f;
                    maxX += s * 0.9f;
                    minZ -= s;
                    maxZ += s;
                    if (fenceType.size != 1 && !fenceType.solid) {
                        minY = bottomBarMinY + 2.0f * s;
                        maxY = topBarMaxY - 2.0f * s;
                    } else if (fenceType.size == 1 && fenceType.solid) {
                        minY = bottomBarMinY + 2.0f * s;
                        maxY = topBarMaxY - 2.0f * s;
                    } else {
                        minY = 0.5f - 2.0f * s;
                        maxY = 0.5f + 2.0f * s;
                    }
                    if (fenceType.solid && fenceType.size == 0) {
                        minY -= s;
                        maxY -= s;
                    }
                    if (fenceType.solid && fenceType.size == 2) {
                        minY += s;
                        maxY += s;
                    }
                    block.func_149676_a(minX, minY, minZ, maxX, maxY, maxZ);
                    layer = 0;
                } else {
                    if (fenceType.size != 1 || fenceType.solid) continue;
                    block.func_149676_a(minX, 0.5f - s, minZ, maxX, 0.5f + s, maxZ);
                    layer = 1;
                }
            }
            renderer.func_147775_a(block);
            GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
            tess.func_78382_b();
            tess.func_78375_b(0.0f, -1.0f, 0.0f);
            renderer.func_147768_a(block, 0.0, 0.0, 0.0, block.func_149691_a(0, metadata));
            tess.func_78381_a();
            tess.func_78382_b();
            tess.func_78375_b(0.0f, 1.0f, 0.0f);
            renderer.func_147806_b(block, 0.0, 0.0, 0.0, block.func_149691_a(1, metadata));
            tess.func_78381_a();
            tess.func_78382_b();
            tess.func_78375_b(0.0f, 0.0f, -1.0f);
            renderer.func_147764_f(block, 0.0, 0.0, 0.0, block.func_149691_a(2, metadata));
            tess.func_78381_a();
            tess.func_78382_b();
            tess.func_78375_b(0.0f, 0.0f, 1.0f);
            renderer.func_147798_e(block, 0.0, 0.0, 0.0, block.func_149691_a(3, metadata));
            tess.func_78381_a();
            tess.func_78382_b();
            tess.func_78375_b(-1.0f, 0.0f, 0.0f);
            renderer.func_147761_c(block, 0.0, 0.0, 0.0, block.func_149691_a(4, metadata));
            tess.func_78381_a();
            tess.func_78382_b();
            tess.func_78375_b(1.0f, 0.0f, 0.0f);
            renderer.func_147734_d(block, 0.0, 0.0, 0.0, block.func_149691_a(5, metadata));
            tess.func_78381_a();
            GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        }
        block.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        renderer.func_147775_a(block);
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        layer = 0;
        BlockFence blockFence = (BlockFence)block;
        float i = 0.0625f;
        FenceType fenceType = new FenceType(0);
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileEntityMetadata) {
            TileEntityMetadata tileMeta = (TileEntityMetadata)tile;
            if (block instanceof BlockMultiFence) {
                fenceType = WoodManager.getFenceType(tileMeta.getTileMetadata());
            }
        }
        float postWidth = 0.25f;
        float postHeight = 1.0f;
        float minPostPos = 0.5f - postWidth / 2.0f;
        float maxPostPos = 0.5f + postWidth / 2.0f;
        renderer.func_147782_a((double)minPostPos, 0.0, (double)minPostPos, (double)maxPostPos, (double)postHeight, (double)maxPostPos);
        renderer.func_147784_q(block, x, y, z);
        boolean rendered = true;
        boolean connectAnyX = false;
        boolean connectAnyZ = false;
        if (blockFence.func_149826_e(renderer.field_147845_a, x - 1, y, z) || blockFence.func_149826_e(renderer.field_147845_a, x + 1, y, z)) {
            connectAnyX = true;
        }
        if (blockFence.func_149826_e(renderer.field_147845_a, x, y, z - 1) || blockFence.func_149826_e(renderer.field_147845_a, x, y, z + 1)) {
            connectAnyZ = true;
        }
        boolean connectNegX = blockFence.func_149826_e(renderer.field_147845_a, x - 1, y, z);
        boolean connectPosX = blockFence.func_149826_e(renderer.field_147845_a, x + 1, y, z);
        boolean connectNegZ = blockFence.func_149826_e(renderer.field_147845_a, x, y, z - 1);
        boolean connectPosZ = blockFence.func_149826_e(renderer.field_147845_a, x, y, z + 1);
        if (!connectAnyX && !connectAnyZ) {
            connectAnyX = true;
        }
        minPostPos = 7.0f * i;
        maxPostPos = 9.0f * i;
        float barMinY = 12.0f * i;
        float barMaxY = 15.0f * i;
        float minX = connectNegX ? 0.0f : minPostPos;
        float maxX = connectPosX ? 1.0f : maxPostPos;
        float minZ = connectNegZ ? 0.0f : minPostPos;
        float maxZ = connectPosZ ? 1.0f : maxPostPos;
        boolean renderBottom = true;
        if (fenceType.size == 2) {
            barMaxY -= 5.0f * i;
            barMinY -= 5.0f * i;
        }
        if (fenceType.solid) {
            renderBottom = false;
            barMinY = fenceType.size == 0 ? 6.0f * i : i;
        }
        float totalMaxY = barMaxY;
        layer = 1;
        if (connectAnyX) {
            renderer.func_147782_a((double)minX, (double)barMinY, (double)minPostPos, (double)maxX, (double)barMaxY, (double)maxPostPos);
            renderer.func_147784_q((Block)blockFence, x, y, z);
        }
        if (connectAnyZ) {
            renderer.func_147782_a((double)minPostPos, (double)barMinY, (double)minZ, (double)maxPostPos, (double)barMaxY, (double)maxZ);
            renderer.func_147784_q((Block)blockFence, x, y, z);
        }
        if (renderBottom) {
            barMinY -= 6.0f * i;
            barMaxY -= 6.0f * i;
            if (fenceType.size == 1) {
                barMinY += i;
            }
            if (connectAnyX) {
                renderer.func_147782_a((double)minX, (double)barMinY, (double)minPostPos, (double)maxX, (double)barMaxY, (double)maxPostPos);
                renderer.func_147784_q((Block)blockFence, x, y, z);
            }
            if (connectAnyZ) {
                renderer.func_147782_a((double)minPostPos, (double)barMinY, (double)minZ, (double)maxPostPos, (double)barMaxY, (double)maxZ);
                renderer.func_147784_q((Block)blockFence, x, y, z);
            }
        }
        if (renderBottom && fenceType.size == 1) {
            barMinY -= 6.0f * i;
            barMaxY -= 6.0f * i;
            barMaxY += i;
            if (connectAnyX) {
                renderer.func_147782_a((double)minX, (double)barMinY, (double)minPostPos, (double)maxX, (double)barMaxY, (double)maxPostPos);
                renderer.func_147784_q((Block)blockFence, x, y, z);
            }
            if (connectAnyZ) {
                renderer.func_147782_a((double)minPostPos, (double)barMinY, (double)minZ, (double)maxPostPos, (double)barMaxY, (double)maxZ);
                renderer.func_147784_q((Block)blockFence, x, y, z);
            }
        }
        float totalMinY = barMinY;
        layer = 0;
        if (fenceType.embossed) {
            minPostPos -= (float)((double)i - 0.25 * (double)i);
            maxPostPos += (float)((double)i - 0.25 * (double)i);
            float minY = totalMinY + 2.0f * i;
            float maxY = totalMaxY - 2.0f * i;
            if (fenceType.size == 1 && !fenceType.solid) {
                minY = 6.0f * i;
                maxY = 10.0f * i;
            } else if (fenceType.size == 0 && fenceType.solid) {
                minY -= 4.0f * i;
                maxY -= 4.0f * i;
            } else if (fenceType.size == 2 && fenceType.solid) {
                minY += 4.0f * i;
                maxY += 4.0f * i;
            }
            if (connectAnyX) {
                renderer.func_147782_a((double)minX, (double)minY, (double)minPostPos, (double)maxX, (double)maxY, (double)maxPostPos);
                renderer.func_147784_q(block, x, y, z);
            }
            if (connectAnyZ) {
                renderer.func_147782_a((double)minPostPos, (double)minY, (double)minZ, (double)maxPostPos, (double)maxY, (double)maxZ);
                renderer.func_147784_q(block, x, y, z);
            }
        }
        blockFence.func_149719_a(renderer.field_147845_a, x, y, z);
        return rendered;
    }

    public boolean shouldRender3DInInventory(int i) {
        return true;
    }

    public int getRenderId() {
        return ExtraTrees.fenceID;
    }
}

