/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.genetics;

import binnie.core.Mods;
import binnie.core.util.I18N;
import forestry.api.apiculture.FlowerManager;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleFlowers;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IFlower;
import forestry.api.genetics.IFlowerProvider;
import forestry.api.genetics.IFruitBearer;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IPollinatable;
import forestry.api.genetics.ISpeciesRoot;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;

public enum ExtraBeesFlowers implements IFlowerProvider,
IAlleleFlowers,
IChromosomeType
{
    WATER,
    SUGAR,
    ROCK,
    BOOK,
    DEAD,
    REDSTONE,
    WOOD,
    LEAVES,
    SAPLING,
    FRUIT,
    MYSTICAL,
    BEDROCK;

    private final boolean dominant;

    private ExtraBeesFlowers() {
        this.dominant = true;
    }

    public static void doInit() {
        for (ExtraBeesFlowers effect : ExtraBeesFlowers.values()) {
            effect.register();
        }
    }

    public String getUID() {
        return "extrabees.flower." + this.toString().toLowerCase();
    }

    public boolean isDominant() {
        return this.dominant;
    }

    public IFlowerProvider getProvider() {
        return this;
    }

    public String getDescription() {
        return I18N.localise("extrabees.flowers." + this.name().toLowerCase() + ".name");
    }

    public void register() {
        for (ItemStack stack : this.getItemStacks()) {
            FlowerManager.flowerRegistry.registerAcceptableFlower(Block.func_149634_a((Item)stack.func_77973_b()), new String[]{this.getUID()});
        }
        AlleleManager.alleleRegistry.registerAllele((IAllele)this, new IChromosomeType[]{this});
    }

    public ItemStack[] getItemStacks() {
        ItemStack[] itemStackArray;
        switch (this) {
            case WATER: {
                ItemStack[] itemStackArray2 = new ItemStack[1];
                itemStackArray = itemStackArray2;
                itemStackArray2[0] = new ItemStack(Blocks.field_150392_bi);
                break;
            }
            case SUGAR: {
                ItemStack[] itemStackArray3 = new ItemStack[1];
                itemStackArray = itemStackArray3;
                itemStackArray3[0] = new ItemStack(Blocks.field_150436_aH);
                break;
            }
            case ROCK: {
                ItemStack[] itemStackArray4 = new ItemStack[1];
                itemStackArray = itemStackArray4;
                itemStackArray4[0] = new ItemStack(Blocks.field_150347_e);
                break;
            }
            case BOOK: {
                ItemStack[] itemStackArray5 = new ItemStack[1];
                itemStackArray = itemStackArray5;
                itemStackArray5[0] = new ItemStack(Blocks.field_150342_X);
                break;
            }
            case REDSTONE: {
                ItemStack[] itemStackArray6 = new ItemStack[1];
                itemStackArray = itemStackArray6;
                itemStackArray6[0] = new ItemStack(Blocks.field_150429_aA);
                break;
            }
            case DEAD: {
                ItemStack[] itemStackArray7 = new ItemStack[1];
                itemStackArray = itemStackArray7;
                itemStackArray7[0] = new ItemStack((Block)Blocks.field_150330_I);
                break;
            }
            case FRUIT: {
                ItemStack[] itemStackArray8 = new ItemStack[1];
                itemStackArray = itemStackArray8;
                itemStackArray8[0] = new ItemStack(Items.field_151034_e);
                break;
            }
            case LEAVES: {
                ItemStack[] itemStackArray9 = new ItemStack[1];
                itemStackArray = itemStackArray9;
                itemStackArray9[0] = new ItemStack((Block)Blocks.field_150362_t);
                break;
            }
            case SAPLING: {
                ItemStack[] itemStackArray10 = new ItemStack[1];
                itemStackArray = itemStackArray10;
                itemStackArray10[0] = new ItemStack(Blocks.field_150345_g);
                break;
            }
            case WOOD: {
                ItemStack[] itemStackArray11 = new ItemStack[1];
                itemStackArray = itemStackArray11;
                itemStackArray11[0] = new ItemStack(Blocks.field_150364_r);
                break;
            }
            case BEDROCK: {
                ItemStack[] itemStackArray12 = new ItemStack[1];
                itemStackArray = itemStackArray12;
                itemStackArray12[0] = new ItemStack(Blocks.field_150357_h);
                break;
            }
            default: {
                itemStackArray = new ItemStack[]{};
            }
        }
        return itemStackArray;
    }

    public boolean isAcceptedPollinatable(World world, IPollinatable pollinatable) {
        EnumSet types = pollinatable.getPlantType();
        return types.size() > 1 || !types.contains(EnumPlantType.Nether);
    }

    public boolean isAcceptedFlower(World world, int x, int y, int z) {
        boolean bl;
        Block block = world.func_147439_a(x, y, z);
        if (block == null) {
            return false;
        }
        switch (this) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case WATER: {
                if (block == Blocks.field_150392_bi) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case ROCK: {
                if (block.func_149688_o() == Material.field_151576_e) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case SUGAR: {
                if (block == Blocks.field_150436_aH) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case BOOK: {
                if (block == Blocks.field_150342_X) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case REDSTONE: {
                if (block == Blocks.field_150429_aA) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case DEAD: {
                if (block == Blocks.field_150330_I) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case WOOD: {
                bl = block.isWood((IBlockAccess)world, x, y, z);
                break;
            }
            case FRUIT: {
                bl = world.func_147438_o(x, y, z) instanceof IFruitBearer;
                break;
            }
            case LEAVES: {
                bl = block.isLeaves((IBlockAccess)world, x, y, z);
                break;
            }
            case SAPLING: {
                bl = block.getClass().getName().toLowerCase().contains("sapling");
                break;
            }
            case MYSTICAL: {
                if (block == Mods.botania.block("flower")) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case BEDROCK: {
                bl = block == Blocks.field_150357_h;
            }
        }
        return bl;
    }

    public boolean growFlower(World world, IIndividual individual, int x, int y, int z) {
        boolean bl;
        switch (this) {
            case WATER: {
                if (world.func_147437_c(x, y, z) && world.func_147439_a(x, y - 1, z) == Blocks.field_150355_j && world.func_147465_d(x, y, z, Blocks.field_150392_bi, 0, 2)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case SUGAR: {
                if (world.func_147439_a(x, y - 1, z) == Blocks.field_150436_aH && world.func_147437_c(x, y, z) && world.func_147465_d(x, y, z, Blocks.field_150436_aH, 0, 0)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public ItemStack[] affectProducts(World world, IIndividual individual, int x, int y, int z, ItemStack[] products) {
        if (this == MYSTICAL) {
            ArrayList<ItemStack> prods = new ArrayList<ItemStack>();
            Collections.addAll(prods, products);
            for (int k = 0; k < 50; ++k) {
                int z2;
                int y2;
                int tX = 7;
                int tY = 7;
                int tZ = 3;
                int x2 = x - tX + world.field_73012_v.nextInt(1 + 2 * tX);
                Block block = world.func_147439_a(x2, y2 = y - tY + world.field_73012_v.nextInt(1 + 2 * tY), z2 = z - tZ + world.field_73012_v.nextInt(1 + 2 * tZ));
                if (block == null || block != Mods.botania.block("flower")) continue;
                int meta = world.func_72805_g(x2, y2, z2);
                Item item = Mods.botania.item("petal");
                if (item == null) continue;
                prods.add(new ItemStack(item, 1, meta));
            }
            return prods.toArray(new ItemStack[0]);
        }
        return products;
    }

    public String getName() {
        return this.getDescription();
    }

    public String getUnlocalizedName() {
        return this.getUID();
    }

    public String getFlowerType() {
        return this.getUID();
    }

    public Set<IFlower> getFlowers() {
        return new HashSet<IFlower>();
    }

    public Class<? extends IAllele> getAlleleClass() {
        return ((Object)((Object)this)).getClass();
    }

    public ISpeciesRoot getSpeciesRoot() {
        return AlleleManager.alleleRegistry.getSpeciesRoot(this.getUID());
    }
}

