/*
 * Decompiled with CFR 0.152.
 */
package binnie.botany.flower;

import binnie.Binnie;
import binnie.botany.Botany;
import binnie.botany.CreativeTabBotany;
import binnie.botany.api.EnumFlowerStage;
import binnie.botany.api.IFlower;
import binnie.botany.api.IFlowerColor;
import binnie.botany.api.IFlowerGenome;
import binnie.botany.api.IFlowerType;
import binnie.botany.core.BotanyCore;
import binnie.botany.flower.BlockFlower;
import binnie.botany.genetics.EnumFlowerType;
import binnie.botany.genetics.Flower;
import binnie.core.BinnieCore;
import binnie.core.util.I18N;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IPollinatable;
import forestry.core.config.Config;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class ItemBotany
extends Item {
    public ItemBotany(String name) {
        this.func_77637_a(CreativeTabBotany.instance);
        this.func_77655_b(name);
        this.field_77787_bX = true;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_94901_k() {
        return 0;
    }

    public boolean func_77645_m() {
        return false;
    }

    public boolean isRepairable() {
        return false;
    }

    public boolean hasEffect(ItemStack stack, int pass) {
        if (!stack.func_77942_o()) {
            return false;
        }
        IIndividual individual = this.getIndividual(stack);
        return individual != null && individual.getGenome() != null && individual.hasEffect();
    }

    public void func_77624_a(ItemStack itemstack, EntityPlayer player, List<String> tooltip, boolean flag) {
        if (!itemstack.func_77942_o()) {
            return;
        }
        IFlower individual = (IFlower)this.getIndividual(itemstack);
        if (individual == null) {
            tooltip.add(I18N.localise("botany.item.tooltip.bugged"));
            return;
        }
        IFlowerGenome genome = individual.getGenome();
        IFlowerColor primaryColor = genome.getPrimaryColor();
        IFlowerColor secondColor = genome.getSecondaryColor();
        IFlowerColor stemColor = genome.getStemColor();
        if (primaryColor == secondColor) {
            tooltip.add(EnumChatFormatting.YELLOW + I18N.localise("botany.item.tooltip.flowerColor1", primaryColor.getName(), stemColor.getName()));
        } else {
            tooltip.add(EnumChatFormatting.YELLOW + I18N.localise("botany.item.tooltip.flowerColor2", primaryColor.getName(), secondColor.getName(), stemColor.getName()));
        }
        if (individual.isAnalyzed()) {
            if (BinnieCore.proxy.isShiftDown()) {
                individual.addTooltip(tooltip);
            } else {
                tooltip.add(EnumChatFormatting.GRAY + I18N.localise("botany.item.tooltip.holdMore"));
            }
        } else {
            tooltip.add(I18N.localise("botany.item.tooltip.unknownGenome"));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister par1IconRegister) {
    }

    protected IIndividual getIndividual(ItemStack itemstack) {
        return new Flower(itemstack.func_77978_p());
    }

    public String func_77653_i(ItemStack itemstack) {
        if (!itemstack.func_77942_o()) {
            return I18N.localise("botany.item.tooltip.unknown");
        }
        IIndividual individual = this.getIndividual(itemstack);
        if (individual != null && individual.getGenome() != null) {
            String tag = this.getTag();
            if (tag == null || tag.isEmpty()) {
                return individual.getDisplayName();
            }
            return I18N.localise("botany.item.botany.name", individual.getDisplayName(), tag);
        }
        return I18N.localise("botany.item.flowerCorrupted.name");
    }

    public void func_150895_a(Item item, CreativeTabs par2CreativeTabs, List<ItemStack> itemList) {
        this.addCreativeItems(itemList, true);
    }

    public void addCreativeItems(List<ItemStack> itemList, boolean hideSecrets) {
        for (IIndividual individual : BotanyCore.speciesRoot.getIndividualTemplates()) {
            if (hideSecrets && individual.isSecret() && !Config.isDebug) continue;
            itemList.add(BotanyCore.speciesRoot.getMemberStack(individual.copy(), this.getStage().ordinal()));
        }
    }

    public int func_82790_a(ItemStack itemstack, int renderPass) {
        IFlower flower = BotanyCore.speciesRoot.getMember(itemstack);
        if (flower == null || flower.getGenome() == null) {
            return 0xFFFFFF;
        }
        if (renderPass == 0) {
            return flower.getGenome().getStemColor().getColor(flower.isWilted());
        }
        return renderPass == 1 ? flower.getGenome().getPrimaryColor().getColor(flower.isWilted()) : flower.getGenome().getSecondaryColor().getColor(flower.isWilted());
    }

    public boolean func_77623_v() {
        return true;
    }

    public int getRenderPasses(int metadata) {
        return 3;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack itemstack, int renderPass) {
        IFlower flower = BotanyCore.speciesRoot.getMember(itemstack);
        if (flower == null || flower.getGenome() == null || flower.getGenome().getPrimary() == null) {
            return EnumFlowerType.ALLIUM.getBlank();
        }
        IFlowerType type = flower.getGenome().getPrimary().getType();
        if (renderPass == 0) {
            return type.getStem(this.getStage(), flower.hasFlowered(), type.getSections() - 1);
        }
        if (renderPass == 1) {
            return type.getPetalIcon(this.getStage(), flower.hasFlowered(), type.getSections() - 1);
        }
        return type.getVariantIcon(this.getStage(), flower.hasFlowered(), type.getSections() - 1);
    }

    public boolean func_77648_a(ItemStack itemstack, EntityPlayer player, World world, int x, int y, int z, int side, float px, float py, float pz) {
        if (this.getStage() == EnumFlowerStage.POLLEN) {
            IFlower flower = Binnie.Genetics.getFlowerRoot().getMember(itemstack);
            TileEntity target = world.func_147438_o(x, y, z);
            if (!(target instanceof IPollinatable)) {
                return false;
            }
            IPollinatable pollinatable = (IPollinatable)target;
            if (!pollinatable.canMateWith((IIndividual)flower)) {
                return false;
            }
            pollinatable.mateWith((IIndividual)flower);
            if (!player.field_71075_bZ.field_75098_d) {
                --itemstack.field_77994_a;
            }
            return true;
        }
        BlockFlower blockFlower = Botany.flower;
        Block blockAlreadyThere = world.func_147439_a(x, y, z);
        if (blockAlreadyThere == Blocks.field_150431_aC && (world.func_72805_g(x, y, z) & 7) < 1) {
            side = 1;
        } else if (blockAlreadyThere != Blocks.field_150395_bd && blockAlreadyThere != Blocks.field_150329_H && blockAlreadyThere != Blocks.field_150330_I && !blockAlreadyThere.isReplaceable((IBlockAccess)world, x, y, z)) {
            if (side == 0) {
                --y;
            } else if (side == 1) {
                ++y;
            } else if (side == 2) {
                --z;
            } else if (side == 3) {
                ++z;
            } else if (side == 4) {
                --x;
            } else if (side == 5) {
                ++x;
            }
        }
        if (itemstack.field_77994_a == 0 || !player.func_82247_a(x, y, z, side, itemstack)) {
            return false;
        }
        if (y == 255 && blockFlower.func_149688_o().func_76220_a()) {
            return false;
        }
        if (world.func_147472_a((Block)blockFlower, x, y, z, false, side, (Entity)player, itemstack)) {
            int i1 = this.func_77647_b(itemstack.func_77960_j());
            int j1 = blockFlower.func_149660_a(world, x, y, z, side, px, py, pz, i1);
            if (this.placeBlockAt(itemstack, player, world, x, y, z, side, px, py, pz, j1)) {
                world.func_72908_a((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), ((Block)blockFlower).field_149762_H.func_150496_b(), (((Block)blockFlower).field_149762_H.func_150497_c() + 1.0f) / 2.0f, ((Block)blockFlower).field_149762_H.func_150494_d() * 0.8f);
                --itemstack.field_77994_a;
            }
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_150936_a(World world, int x, int y, int z, int side, EntityPlayer player, ItemStack stack) {
        BlockFlower field_150939_a = Botany.flower;
        Block block = world.func_147439_a(x, y, z);
        if (block == Blocks.field_150431_aC) {
            side = 1;
        } else if (block != Blocks.field_150395_bd && block != Blocks.field_150329_H && block != Blocks.field_150330_I && !block.isReplaceable((IBlockAccess)world, x, y, z)) {
            if (side == 0) {
                --y;
            } else if (side == 1) {
                ++y;
            } else if (side == 2) {
                --z;
            } else if (side == 3) {
                ++z;
            } else if (side == 4) {
                --x;
            } else if (side == 5) {
                ++x;
            }
        }
        return world.func_147472_a((Block)field_150939_a, x, y, z, false, side, null, stack);
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata) {
        BlockFlower block = Botany.flower;
        if (!world.func_147465_d(x, y, z, (Block)block, metadata, 3)) {
            return false;
        }
        if (world.func_147439_a(x, y, z) == block) {
            block.func_149689_a(world, x, y, z, (EntityLivingBase)player, stack);
            block.func_149714_e(world, x, y, z, metadata);
        }
        return true;
    }

    public abstract EnumFlowerStage getStage();

    public abstract String getTag();
}

