/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mods.load.gui;

import alexiil.mods.load.gui.GuiPreview;
import alexiil.mods.load.json.EType;
import alexiil.mods.load.json.ImageRender;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.commons.lang3.StringUtils;

public class FrameEditor
extends JFrame {
    private JPanel contentPane;
    private JPanel settingsPanel;
    private JList<String> renderList;
    private DefaultListModel<String> renderListInternal;
    private final GuiPreview gui;
    private ImageRender[] renders;

    public FrameEditor(GuiPreview preview) {
        this.gui = preview;
        this.renders = this.gui.getImageData();
        this.setDefaultCloseOperation(2);
        this.setBounds(100, 100, 450, 300);
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.contentPane.setLayout(new BorderLayout(0, 0));
        this.setContentPane(this.contentPane);
        this.renderList = new JList();
        this.renderList.setSelectionMode(0);
        this.renderList.setLayoutOrientation(0);
        this.renderListInternal = new DefaultListModel();
        this.renderList.setModel(this.renderListInternal);
        this.renderList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                FrameEditor.this.settingsPanel.removeAll();
                int index = FrameEditor.this.renderList.getSelectedIndex();
                if (index == -1) {
                    FrameEditor.this.settingsPanel.removeAll();
                } else {
                    FrameEditor.this.settingsPanel.add(FrameEditor.this.handle(FrameEditor.this.renders[index]));
                }
                FrameEditor.this.settingsPanel.invalidate();
                FrameEditor.this.settingsPanel.repaint();
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.renderList);
        this.contentPane.add((Component)scrollPane, "West");
        this.settingsPanel = new JPanel();
        this.settingsPanel.setLayout(new BoxLayout(this.settingsPanel, 1));
        this.contentPane.add((Component)this.settingsPanel, "Center");
        this.resetRenders();
    }

    private void resetRenders() {
        this.settingsPanel.removeAll();
        this.renderListInternal.clear();
        for (ImageRender render : this.renders) {
            if (StringUtils.isEmpty((CharSequence)render.comment)) {
                render.comment = "<unnamed>";
            }
            this.renderListInternal.addElement(render.comment);
        }
    }

    private JPanel handle(final ImageRender render) {
        JPanel panel = new JPanel();
        panel.setBorder(LineBorder.createGrayLineBorder());
        panel.setLayout(new BoxLayout(panel, 1));
        JTextField comment = new JTextField(20);
        comment.setText(render.comment);
        panel.add(comment);
        JComboBox<EType> type = new JComboBox<EType>(EType.values());
        type.setSelectedItem((Object)render.type);
        panel.add(type);
        JPanel colour = new JPanel();
        colour.setLayout(new BoxLayout(colour, 0));
        JButton colourChanger = new JButton("Change colour");
        colour.add(colourChanger);
        final JPanel colourPreview = new JPanel();
        colourPreview.setSize(100, 100);
        colourPreview.setBackground(new Color(render.getColour()));
        colour.add(colourPreview);
        colourChanger.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color c = JColorChooser.showDialog(null, "Choose a colour", new Color(render.getColour()));
                colourPreview.setBackground(c);
                render.setColour(c);
            }
        });
        if (render.type == EType.STATIC_TEXT) {
            JTextField jTextField = new JTextField(20);
        }
        panel.add(colour);
        return panel;
    }
}

