/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2.asm.transformers;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.Map;
import mods.battlegear2.asm.MethodMapping;
import mods.battlegear2.asm.loader.BattlegearLoadingPlugin;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.Launch;
import org.apache.commons.io.FileUtils;
import org.spongepowered.asm.lib.ClassReader;
import org.spongepowered.asm.lib.ClassVisitor;
import org.spongepowered.asm.lib.Opcodes;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.lib.tree.ClassNode;
import org.spongepowered.asm.lib.tree.FieldInsnNode;
import org.spongepowered.asm.lib.tree.InsnList;
import org.spongepowered.asm.lib.tree.InsnNode;
import org.spongepowered.asm.lib.tree.JumpInsnNode;
import org.spongepowered.asm.lib.tree.LabelNode;
import org.spongepowered.asm.lib.tree.MethodInsnNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.lib.tree.VarInsnNode;
import org.spongepowered.asm.transformers.MixinClassWriter;

public class InventoryArrayAccessTransformer
implements IClassTransformer,
Opcodes {
    private File outputDir = null;
    private final Map<String, MethodMapping> targetClassesAndMethods = new HashMap<String, MethodMapping>();

    public InventoryArrayAccessTransformer() {
        this.targetClassesAndMethods.put("net.minecraft.entity.ai.EntityAIControlledByPlayer", MethodMapping.ENTITYAICONTROLLEDBYPLAYER_UPDATETASK);
        this.targetClassesAndMethods.put("net.minecraft.client.entity.EntityOtherPlayerMP", MethodMapping.ENTITYOTHERPLAYERMP_SETCURRENTITEMORARMOR);
        this.targetClassesAndMethods.put("net.minecraft.entity.player.EntityPlayer", MethodMapping.ENTITYPLAYER_SETCURRENTITEMORARMOR);
        this.targetClassesAndMethods.put("net.minecraft.server.management.ItemInWorldManager", MethodMapping.ITEMINWORLDMANAGER_TRYUSEITEM);
        this.targetClassesAndMethods.put("net.minecraft.client.Minecraft", MethodMapping.MINECRAFT_RIGHTCLICKMOUSE);
        this.targetClassesAndMethods.put("net.minecraft.client.network.NetHandlerPlayClient", MethodMapping.NETHANDLERPLAYCLIENT_HANDLESPAWNPLAYER);
        this.targetClassesAndMethods.put("net.minecraft.network.NetHandlerPlayServer", MethodMapping.NETHANDLERPLAYSERVER_PROCESSPLAYERBLOCKPLACEMENT);
        this.targetClassesAndMethods.put("net.minecraft.client.multiplayer.PlayerControllerMP", MethodMapping.PLAYERCONTROLLERMP_SENDUSEITEM);
    }

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (basicClass == null) {
            return null;
        }
        if (this.targetClassesAndMethods.containsKey(transformedName)) {
            this.saveTransformedClass(basicClass, transformedName + "_pre");
            ClassNode classNode = new ClassNode();
            ClassReader classReader = new ClassReader(basicClass);
            classReader.accept((ClassVisitor)classNode, 0);
            InventoryArrayAccessTransformer.transform(classNode, this.targetClassesAndMethods.get(transformedName));
            MixinClassWriter classWriter = new MixinClassWriter(3);
            classNode.accept((ClassVisitor)classWriter);
            basicClass = classWriter.toByteArray();
            this.saveTransformedClass(basicClass, transformedName + "_post");
            return basicClass;
        }
        return basicClass;
    }

    private static void transform(ClassNode classNode, MethodMapping targetMethod) {
        int injectionCount = -1;
        for (MethodNode methodNode : classNode.methods) {
            if (!(methodNode.name + methodNode.desc).equals(targetMethod.getMapping())) continue;
            if (targetMethod == MethodMapping.NETHANDLERPLAYSERVER_PROCESSPLAYERBLOCKPLACEMENT) {
                InventoryArrayAccessTransformer.cleanUnsafeArrayAccess(methodNode.instructions);
            }
            injectionCount = InventoryArrayAccessTransformer.wrapInventoryAccess(methodNode.instructions);
        }
        int expectedCount = targetMethod.targetCount;
        if (injectionCount == -1) {
            BattlegearLoadingPlugin.logger.error("Couldn't find target method in " + classNode.name);
        } else if (injectionCount == expectedCount) {
            String msg = "Transformed " + classNode.name + "#" + targetMethod.clearMapping + " to wrap " + injectionCount + " inventory access array";
            if (BattlegearLoadingPlugin.isObf()) {
                BattlegearLoadingPlugin.logger.debug(msg);
            } else {
                BattlegearLoadingPlugin.logger.info(msg);
            }
        } else if (injectionCount < expectedCount) {
            BattlegearLoadingPlugin.logger.error("Expected " + expectedCount + " injections, but could only inject " + injectionCount + " time when transforming " + classNode.name + "#" + targetMethod.clearMapping);
        } else {
            BattlegearLoadingPlugin.logger.error("Expected " + expectedCount + " injections, but injected " + injectionCount + " times when transforming " + classNode.name + "#" + targetMethod.clearMapping);
        }
    }

    private static int wrapInventoryAccess(InsnList instructions) {
        int injectionCount = 0;
        for (AbstractInsnNode insnNode : instructions.toArray()) {
            AbstractInsnNode node;
            AbstractInsnNode sixthNode;
            AbstractInsnNode fifthNode;
            AbstractInsnNode fourthNode;
            AbstractInsnNode thirdNode;
            AbstractInsnNode secondNode;
            if (!InventoryArrayAccessTransformer.isLoadPlayerNode(insnNode)) continue;
            boolean isPlayerField = insnNode instanceof FieldInsnNode;
            AbstractInsnNode prevNode = insnNode.getPrevious();
            if (isPlayerField && (!(prevNode instanceof VarInsnNode) || prevNode.getOpcode() != 25 || ((VarInsnNode)prevNode).var != 0) || !InventoryArrayAccessTransformer.isPlayerInventoryFieldNode(secondNode = insnNode.getNext()) || !InventoryArrayAccessTransformer.isMainInventoryFieldNode(thirdNode = secondNode.getNext())) continue;
            if (isPlayerField) {
                if (!(thirdNode.getNext() instanceof VarInsnNode) || thirdNode.getNext().getOpcode() != 25 || ((VarInsnNode)thirdNode.getNext()).var != 0) continue;
                fourthNode = thirdNode.getNext().getNext();
            } else {
                fourthNode = thirdNode.getNext();
            }
            if (!InventoryArrayAccessTransformer.isLoadPlayerNode(fourthNode) || !InventoryArrayAccessTransformer.isPlayerInventoryFieldNode(fifthNode = fourthNode.getNext()) || !InventoryArrayAccessTransformer.isCurrentItemFieldNode(sixthNode = fifthNode.getNext())) continue;
            InsnList loadItemStackInsnList = new InsnList();
            for (node = sixthNode.getNext(); node != null && node.getOpcode() != 83; node = node.getNext()) {
                loadItemStackInsnList.add(node.clone(null));
            }
            if (!(node instanceof InsnNode) || node.getOpcode() != 83) continue;
            LabelNode label = new LabelNode();
            InsnList list = new InsnList();
            AbstractInsnNode firstNode = insnNode;
            if (insnNode instanceof FieldInsnNode) {
                list.add(insnNode.getPrevious().clone(null));
                firstNode = insnNode.getPrevious();
            }
            list.add(insnNode.clone(null));
            list.add(loadItemStackInsnList);
            list.add((AbstractInsnNode)new MethodInsnNode(184, "mods/battlegear2/asm/hooks/InventoryAccessHook", "setPlayerCurrentItem", InventoryArrayAccessTransformer.deobf("(Lyz;Ladd;)Z", "(Lnet/minecraft/entity/player/EntityPlayer;Lnet/minecraft/item/ItemStack;)Z"), false));
            list.add((AbstractInsnNode)new JumpInsnNode(154, label));
            instructions.insertBefore(firstNode, list);
            instructions.insert(node, (AbstractInsnNode)label);
            ++injectionCount;
        }
        return injectionCount;
    }

    private static void cleanUnsafeArrayAccess(InsnList list) {
        for (AbstractInsnNode insnNode : list.toArray()) {
            AbstractInsnNode sixthNode;
            AbstractInsnNode fifthNode;
            AbstractInsnNode fourthNode;
            AbstractInsnNode thirdNode;
            AbstractInsnNode secondNode;
            if (!InventoryArrayAccessTransformer.isMainInventoryFieldNode(insnNode) || !((secondNode = insnNode.getNext()) instanceof VarInsnNode) || secondNode.getOpcode() != 25 || ((VarInsnNode)secondNode).var != 0 || !InventoryArrayAccessTransformer.isLoadPlayerNode(thirdNode = secondNode.getNext()) || !InventoryArrayAccessTransformer.isPlayerInventoryFieldNode(fourthNode = thirdNode.getNext()) || !InventoryArrayAccessTransformer.isCurrentItemFieldNode(fifthNode = fourthNode.getNext()) || !((sixthNode = fifthNode.getNext()) instanceof InsnNode) || sixthNode.getOpcode() != 50) continue;
            list.insertBefore(insnNode, (AbstractInsnNode)new MethodInsnNode(182, InventoryArrayAccessTransformer.deobf("yx", "net/minecraft/entity/player/InventoryPlayer"), InventoryArrayAccessTransformer.deobf("h", "getCurrentItem"), InventoryArrayAccessTransformer.deobf("()Ladd;", "()Lnet/minecraft/item/ItemStack;"), false));
            list.remove(insnNode);
            list.remove(secondNode);
            list.remove(thirdNode);
            list.remove(fourthNode);
            list.remove(fifthNode);
            list.remove(sixthNode);
        }
    }

    private static boolean isLoadPlayerNode(AbstractInsnNode node) {
        return node instanceof VarInsnNode && node.getOpcode() == 25 || node instanceof FieldInsnNode && node.getOpcode() == 180 && ((FieldInsnNode)node).owner.equals(InventoryArrayAccessTransformer.deobf("bao", "net/minecraft/client/Minecraft")) && ((FieldInsnNode)node).name.equals(InventoryArrayAccessTransformer.deobf("h", "thePlayer")) && ((FieldInsnNode)node).desc.equals(InventoryArrayAccessTransformer.deobf("Lbjk;", "Lnet/minecraft/client/entity/EntityClientPlayerMP;")) || node instanceof FieldInsnNode && node.getOpcode() == 180 && ((FieldInsnNode)node).owner.equals(InventoryArrayAccessTransformer.deobf("nh", "net/minecraft/network/NetHandlerPlayServer")) && ((FieldInsnNode)node).name.equals(InventoryArrayAccessTransformer.deobf("b", "playerEntity")) && ((FieldInsnNode)node).desc.equals(InventoryArrayAccessTransformer.deobf("Lmw;", "Lnet/minecraft/entity/player/EntityPlayerMP;"));
    }

    private static boolean isPlayerInventoryFieldNode(AbstractInsnNode node) {
        return node instanceof FieldInsnNode && node.getOpcode() == 180 && (((FieldInsnNode)node).owner.equals(InventoryArrayAccessTransformer.deobf("yz", "net/minecraft/entity/player/EntityPlayer")) || ((FieldInsnNode)node).owner.equals(InventoryArrayAccessTransformer.deobf("bll", "net/minecraft/client/entity/EntityOtherPlayerMP")) || ((FieldInsnNode)node).owner.equals(InventoryArrayAccessTransformer.deobf("bjk", "net/minecraft/client/entity/EntityClientPlayerMP")) || ((FieldInsnNode)node).owner.equals(InventoryArrayAccessTransformer.deobf("mw", "net/minecraft/entity/player/EntityPlayerMP"))) && ((FieldInsnNode)node).name.equals(InventoryArrayAccessTransformer.deobf("bm", "inventory")) && ((FieldInsnNode)node).desc.equals(InventoryArrayAccessTransformer.deobf("Lyx;", "Lnet/minecraft/entity/player/InventoryPlayer;"));
    }

    private static boolean isMainInventoryFieldNode(AbstractInsnNode node) {
        return node instanceof FieldInsnNode && node.getOpcode() == 180 && ((FieldInsnNode)node).owner.equals(InventoryArrayAccessTransformer.deobf("yx", "net/minecraft/entity/player/InventoryPlayer")) && ((FieldInsnNode)node).name.equals(InventoryArrayAccessTransformer.deobf("a", "mainInventory")) && ((FieldInsnNode)node).desc.equals(InventoryArrayAccessTransformer.deobf("[Ladd;", "[Lnet/minecraft/item/ItemStack;"));
    }

    private static boolean isCurrentItemFieldNode(AbstractInsnNode node) {
        return node instanceof FieldInsnNode && node.getOpcode() == 180 && ((FieldInsnNode)node).owner.equals(InventoryArrayAccessTransformer.deobf("yx", "net/minecraft/entity/player/InventoryPlayer")) && ((FieldInsnNode)node).name.equals(InventoryArrayAccessTransformer.deobf("c", "currentItem")) && ((FieldInsnNode)node).desc.equals("I");
    }

    private void saveTransformedClass(byte[] data, String transformedName) {
        File outFile;
        File outDir;
        if (BattlegearLoadingPlugin.isObf()) {
            return;
        }
        if (this.outputDir == null) {
            this.emptyClassOutputFolder();
        }
        if (!(outDir = (outFile = new File(this.outputDir, transformedName.replace('.', File.separatorChar) + ".class")).getParentFile()).exists()) {
            outDir.mkdirs();
        }
        if (outFile.exists()) {
            outFile.delete();
        }
        try {
            OutputStream output = Files.newOutputStream(outFile.toPath(), new OpenOption[0]);
            output.write(data);
            output.close();
        }
        catch (IOException ex) {
            BattlegearLoadingPlugin.logger.error("Could not save transformed class " + transformedName);
        }
    }

    private void emptyClassOutputFolder() {
        this.outputDir = new File(Launch.minecraftHome, "ASM_BG2");
        try {
            FileUtils.deleteDirectory((File)this.outputDir);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!this.outputDir.exists()) {
            this.outputDir.mkdirs();
        }
    }

    private static String deobf(String obf, String clean) {
        return BattlegearLoadingPlugin.isObf() ? obf : clean;
    }
}

