/*
 * Decompiled with CFR 0.152.
 */
package de.eydamos.backpack.util;

import de.eydamos.backpack.misc.ConfigurationBackpack;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class EnchUtils {
    private static final int SOUL_BOUND_ID = EnchUtils.setSoulBoundID();

    private EnchUtils() {
    }

    private static int setSoulBoundID() {
        if (!ConfigurationBackpack.ALLOW_SOULBOUND) {
            return -3;
        }
        for (Enchantment ench : Enchantment.field_77331_b) {
            if (ench == null || !ench.func_77320_a().equals("enchantment.enderio.soulBound")) continue;
            return ench.field_77352_x;
        }
        return -1;
    }

    public static boolean isSoulBound(ItemStack stack) {
        return SOUL_BOUND_ID >= 0 && EnchantmentHelper.func_77506_a((int)SOUL_BOUND_ID, (ItemStack)stack) > 0;
    }

    public static boolean isSoulBook(ItemStack book) {
        NBTTagList bookEnch;
        NBTTagCompound bookData;
        if (SOUL_BOUND_ID >= 0 && book.func_77942_o() && (bookData = book.field_77990_d).func_74764_b("StoredEnchantments") && (bookEnch = bookData.func_150295_c("StoredEnchantments", 10)).func_74745_c() == 1) {
            int id = bookEnch.func_150305_b(0).func_74762_e("id");
            return id == SOUL_BOUND_ID;
        }
        return false;
    }
}

