/*
 * Decompiled with CFR 0.152.
 */
package zone.rong.loliasm.api;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Map;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.launchwrapper.LaunchClassLoader;
import org.embeddedt.archaicfix.ArchaicLogger;
import zone.rong.loliasm.api.LoliReflector;

public class LoliHelpers {
    private static final boolean noClassCache = false;
    private static final boolean weakClassCache = true;
    private static final boolean noResourceCache = false;
    private static final boolean weakResourceCache = true;

    public static void cleanupLaunchClassLoader() {
        try {
            ArchaicLogger.LOGGER.info("Cleaning up LaunchClassLoader");
            Map oldClassCache = LoliReflector.resolveFieldGetter(LaunchClassLoader.class, "cachedClasses").invoke(Launch.classLoader);
            Cache newClassCache = CacheBuilder.newBuilder().concurrencyLevel(2).weakValues().build();
            newClassCache.putAll(oldClassCache);
            LoliReflector.resolveFieldSetter(LaunchClassLoader.class, "cachedClasses").invoke(Launch.classLoader, newClassCache.asMap());
            Map oldResourceCache = LoliReflector.resolveFieldGetter(LaunchClassLoader.class, "resourceCache").invoke(Launch.classLoader);
            Cache newResourceCache = CacheBuilder.newBuilder().concurrencyLevel(2).weakValues().build();
            newResourceCache.putAll(oldResourceCache);
            LoliReflector.resolveFieldSetter(LaunchClassLoader.class, "resourceCache").invoke(Launch.classLoader, newResourceCache.asMap());
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }
}

