/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.archaicfix.asm.transformer;

import cpw.mods.fml.relauncher.ReflectionHelper;
import java.util.Set;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.launchwrapper.LaunchClassLoader;
import org.embeddedt.archaicfix.ArchaicLogger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;

public class VampirismTransformer
implements IClassTransformer {
    public static void init() {
        try {
            Set transformerExceptions = (Set)ReflectionHelper.getPrivateValue(LaunchClassLoader.class, (Object)Launch.classLoader, (String[])new String[]{"transformerExceptions"});
            transformerExceptions.remove("de.teamlapen.vampirism");
        }
        catch (Exception e) {
            ArchaicLogger.LOGGER.error("Failed to remove Vampirism from transformer exceptions.");
            e.printStackTrace();
        }
    }

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (transformedName.equals("de.teamlapen.vampirism.generation.castle.BlockList")) {
            ArchaicLogger.LOGGER.info("Transforming " + transformedName + " to set Block field as transient");
            try {
                ClassReader cr = new ClassReader(basicClass);
                ClassWriter cw = new ClassWriter(3);
                ClassNode cn = new ClassNode(327680);
                cr.accept((ClassVisitor)cn, 0);
                for (FieldNode fn : cn.fields) {
                    if (!fn.name.equals("block") || !fn.desc.equals("Lnet/minecraft/block/Block;")) continue;
                    fn.access |= 0x80;
                }
                cn.accept((ClassVisitor)cw);
                return cw.toByteArray();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return basicClass;
    }
}

