/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.pathfinding;

import appeng.me.cache.PathGridCache;
import appeng.me.pathfinding.IPathItem;
import appeng.me.pathfinding.PathSegment;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BackbonePathSegment
extends PathSegment {
    IPathItem startNode;
    private Set<IPathItem> controllerRoutes = new HashSet<IPathItem>();
    Map<BackbonePathSegment, List<IPathItem>> neighbours = new HashMap<BackbonePathSegment, List<IPathItem>>();

    public BackbonePathSegment(IPathItem node, PathGridCache myPGC, Set<IPathItem> semiOpen, Set<IPathItem> closed) {
        super(myPGC, new LinkedList<IPathItem>(), semiOpen, closed);
        this.startNode = node;
    }

    void addControllerRoute(IPathItem pi) {
        this.controllerRoutes.add(pi);
    }

    void addPathToNeighbour(BackbonePathSegment nb, IPathItem connection) {
        LinkedList<IPathItem> path = new LinkedList<IPathItem>();
        for (IPathItem pi = connection; pi != null && pi != nb.startNode; pi = pi.getControllerRoute()) {
            path.add(0, pi);
        }
        this.neighbours.put(nb, path);
    }

    public void selectControllerRoute() {
        this.startNode.setControllerRoute(this.controllerRoutes.iterator().next(), false);
    }

    public boolean switchControllerRoute() {
        if (this.controllerRoutes.isEmpty() || this.startNode.getControllerRoute() == null) {
            return false;
        }
        if (this.startNode.getControllerRoute().getControllerRoute() != null && this.startNode.getControllerRoute().getControllerRoute().canSupportMoreChannels()) {
            return true;
        }
        this.controllerRoutes.remove(this.startNode.getControllerRoute());
        if (this.controllerRoutes.isEmpty()) {
            return false;
        }
        this.startNode.setControllerRoute(this.controllerRoutes.iterator().next(), false);
        return true;
    }

    void removeNeigbour(BackbonePathSegment bs) {
        List<IPathItem> pathToRemoved = this.neighbours.get(bs);
        for (BackbonePathSegment nb : bs.neighbours.keySet()) {
            if (nb == this || this.neighbours.containsKey(nb)) continue;
            List<IPathItem> path = bs.neighbours.get(nb);
            path.addAll(pathToRemoved);
            this.neighbours.put(nb, path);
        }
        this.neighbours.remove(bs);
    }

    public void transferToNeighbours() {
        if (this.neighbours.isEmpty()) {
            return;
        }
        for (BackbonePathSegment nb : this.neighbours.keySet()) {
            nb.removeNeigbour(this);
        }
        BackbonePathSegment nb = this.neighbours.keySet().iterator().next();
        List<IPathItem> path = this.neighbours.get(nb);
        IPathItem controller = nb.startNode;
        for (IPathItem pi : path) {
            pi.setControllerRoute(controller, false);
            controller = pi;
        }
        this.startNode.setControllerRoute(controller, false);
    }

    private void reset() {
        this.open.add(this.startNode);
        this.closed.add(this.startNode);
        this.closed.addAll(this.controllerRoutes);
    }

    public static void reset(Map<IPathItem, BackbonePathSegment> backbone) {
        if (backbone.isEmpty()) {
            return;
        }
        backbone.values().iterator().next().closed.clear();
        for (BackbonePathSegment bs : backbone.values()) {
            bs.reset();
        }
    }

    public boolean isValid() {
        return !this.controllerRoutes.isEmpty();
    }
}

