/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.implementations;

import appeng.api.AEApi;
import appeng.api.config.CraftingMode;
import appeng.api.config.Settings;
import appeng.api.definitions.IDefinitions;
import appeng.api.definitions.IParts;
import appeng.api.storage.ITerminalHost;
import appeng.client.gui.implementations.GuiAmount;
import appeng.client.gui.widgets.GuiImgButton;
import appeng.container.implementations.ContainerCraftAmount;
import appeng.core.localization.GuiColors;
import appeng.core.localization.GuiText;
import appeng.core.sync.GuiBridge;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketCraftRequest;
import appeng.helpers.WirelessTerminalGuiObject;
import appeng.parts.reporting.PartCraftingTerminal;
import appeng.parts.reporting.PartPatternTerminal;
import appeng.parts.reporting.PartPatternTerminalEx;
import appeng.parts.reporting.PartTerminal;
import appeng.util.Platform;
import java.util.Iterator;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import org.lwjgl.input.Mouse;

public class GuiCraftAmount
extends GuiAmount {
    private GuiImgButton craftingMode;

    public GuiCraftAmount(InventoryPlayer inventoryPlayer, ITerminalHost te) {
        super(new ContainerCraftAmount(inventoryPlayer, te));
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.craftingMode = new GuiImgButton(this.field_147003_i + 10, this.field_147009_r + 53, Settings.CRAFTING_MODE, CraftingMode.STANDARD);
        this.field_146292_n.add(this.craftingMode);
        this.amountTextField.func_146180_a("1");
        this.amountTextField.func_146199_i(0);
    }

    @Override
    protected void setOriginGUI(Object target) {
        ItemStack stack;
        Iterator iterator;
        IDefinitions definitions = AEApi.instance().definitions();
        IParts parts = definitions.parts();
        if (target instanceof WirelessTerminalGuiObject) {
            iterator = definitions.items().wirelessTerminal().maybeStack(1).asSet().iterator();
            while (iterator.hasNext()) {
                ItemStack wirelessTerminalStack;
                this.myIcon = wirelessTerminalStack = (ItemStack)iterator.next();
            }
            this.originalGui = GuiBridge.GUI_WIRELESS_TERM;
        }
        if (target instanceof PartTerminal) {
            iterator = parts.terminal().maybeStack(1).asSet().iterator();
            while (iterator.hasNext()) {
                this.myIcon = stack = (ItemStack)iterator.next();
            }
            this.originalGui = GuiBridge.GUI_ME;
        }
        if (target instanceof PartCraftingTerminal) {
            iterator = parts.craftingTerminal().maybeStack(1).asSet().iterator();
            while (iterator.hasNext()) {
                this.myIcon = stack = (ItemStack)iterator.next();
            }
            this.originalGui = GuiBridge.GUI_CRAFTING_TERMINAL;
        }
        if (target instanceof PartPatternTerminal) {
            iterator = parts.patternTerminal().maybeStack(1).asSet().iterator();
            while (iterator.hasNext()) {
                this.myIcon = stack = (ItemStack)iterator.next();
            }
            this.originalGui = GuiBridge.GUI_PATTERN_TERMINAL;
        }
        if (target instanceof PartPatternTerminalEx) {
            iterator = parts.patternTerminalEx().maybeStack(1).asSet().iterator();
            while (iterator.hasNext()) {
                this.myIcon = stack = (ItemStack)iterator.next();
            }
            this.originalGui = GuiBridge.GUI_PATTERN_TERMINAL_EX;
        }
    }

    @Override
    public void drawFG(int offsetX, int offsetY, int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(GuiText.SelectAmount.getLocal(), 8, 6, GuiColors.CraftAmountSelectAmount.getColor());
    }

    @Override
    public void drawBG(int offsetX, int offsetY, int mouseX, int mouseY) {
        super.drawBG(offsetX, offsetY, mouseX, mouseY);
        this.nextBtn.field_146126_j = GuiCraftAmount.func_146272_n() ? GuiText.Start.getLocal() : GuiText.Next.getLocal();
        try {
            int resultI = this.getAmount();
            this.nextBtn.field_146124_l = resultI > 0;
        }
        catch (NumberFormatException e) {
            this.nextBtn.field_146124_l = false;
        }
        this.amountTextField.func_146194_f();
    }

    @Override
    protected void func_146284_a(GuiButton btn) {
        super.func_146284_a(btn);
        try {
            if (btn == this.craftingMode) {
                GuiImgButton iBtn = (GuiImgButton)btn;
                Enum cv = iBtn.getCurrentValue();
                boolean backwards = Mouse.isButtonDown((int)1);
                Enum next = Platform.rotateEnum(cv, backwards, iBtn.getSetting().getPossibleValues());
                iBtn.set(next);
            }
            if (btn == this.nextBtn && btn.field_146124_l) {
                NetworkHandler.instance.sendToServer(new PacketCraftRequest(this.addOrderAmount(0), GuiCraftAmount.func_146272_n(), (CraftingMode)this.craftingMode.getCurrentValue()));
            }
        }
        catch (NumberFormatException e) {
            this.amountTextField.func_146180_a("1");
        }
    }

    @Override
    protected String getBackground() {
        return "guis/craftAmt.png";
    }
}

