/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.transform;

import com.google.common.collect.ImmutableSet;
import com.gtnewhorizon.gtnhlib.asm.ClassConstantPoolParser;
import com.gtnewhorizons.angelica.loading.AngelicaTweaker;
import com.gtnewhorizons.angelica.transform.BlockTransformer;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.coderbot.iris.IrisLogging;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.Launch;
import org.apache.commons.lang3.tuple.Pair;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class RedirectorTransformer
implements IClassTransformer {
    private static final boolean ASSERT_MAIN_THREAD = Boolean.parseBoolean(System.getProperty("angelica.assertMainThread", "false"));
    private static final String Drawable = "org/lwjgl/opengl/Drawable";
    private static final String GLStateManager = "com/gtnewhorizons/angelica/glsm/GLStateManager";
    private static final String GL11 = "org/lwjgl/opengl/GL11";
    private static final String GL13 = "org/lwjgl/opengl/GL13";
    private static final String GL14 = "org/lwjgl/opengl/GL14";
    private static final String GL20 = "org/lwjgl/opengl/GL20";
    private static final String Project = "org/lwjgl/util/glu/Project";
    private static final String BlockClass = "net/minecraft/block/Block";
    private static final String BlockPackage = "net/minecraft/block/Block";
    private static final String OpenGlHelper = "net/minecraft/client/renderer/OpenGlHelper";
    private static final String EXTBlendFunc = "org/lwjgl/opengl/EXTBlendFuncSeparate";
    private static final String ARBMultiTexture = "org/lwjgl/opengl/ARBMultitexture";
    private static final String MinecraftClient = "net.minecraft.client";
    private static final String SplashProgress = "cpw.mods.fml.client.SplashProgress";
    private static final String ThreadedBlockData = "com/gtnewhorizons/angelica/glsm/ThreadedBlockData";
    private static final Set<String> ExcludedMinecraftMainThreadChecks = ImmutableSet.of((Object)"startGame", (Object)"func_71384_a", (Object)"initializeTextures", (Object)"func_77474_a");
    private static final List<String> VanillaBlockExclusions = Arrays.asList("net/minecraft/block/IGrowable", "net/minecraft/block/ITileEntityProvider", "net/minecraft/block/BlockEventData", "net/minecraft/block/BlockSourceImpl", "net/minecraft/block/material/");
    private static final ClassConstantPoolParser cstPoolParser = new ClassConstantPoolParser(new String[]{"org/lwjgl/opengl/GL11", "org/lwjgl/opengl/GL13", "org/lwjgl/opengl/GL14", "net/minecraft/client/renderer/OpenGlHelper", "org/lwjgl/opengl/EXTBlendFuncSeparate", "org/lwjgl/opengl/ARBMultitexture", "net/minecraft/block/Block", "org/lwjgl/util/glu/Project"});
    private static final Map<String, Map<String, String>> methodRedirects = new HashMap<String, Map<String, String>>();
    private static final Map<Integer, String> glCapRedirects = new HashMap<Integer, String>();
    private static final List<String> TransformerExclusions = Arrays.asList("org.lwjgl", "com.gtnewhorizons.angelica.glsm.", "com.gtnewhorizons.angelica.transform", "me.eigenraven.lwjgl3ify");
    private static int remaps = 0;
    private static final Set<String> moddedBlockSubclasses = Collections.newSetFromMap(new ConcurrentHashMap());
    private static final Set<String> blockOwnerExclusions = Collections.newSetFromMap(new ConcurrentHashMap());
    private static final MethodHandle angelicaConfigSodiumEnabledGetter;

    private static boolean isSodiumEnabled() {
        try {
            return angelicaConfigSodiumEnabledGetter.invokeExact();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isVanillaBlockSubclass(String className) {
        if (className.startsWith("net/minecraft/block/Block")) {
            for (String exclusion : VanillaBlockExclusions) {
                if (!className.startsWith(exclusion)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean isBlockSubclass(String className) {
        return this.isVanillaBlockSubclass(className) || moddedBlockSubclasses.contains(className);
    }

    public static List<String> getTransformerExclusions() {
        return Collections.unmodifiableList(TransformerExclusions);
    }

    public boolean shouldRfbTransform(byte[] basicClass) {
        return cstPoolParser.find(basicClass, true);
    }

    public byte[] transform(String className, String transformedName, byte[] basicClass) {
        if (basicClass == null) {
            return null;
        }
        for (String exclusion : TransformerExclusions) {
            if (!className.startsWith(exclusion)) continue;
            return basicClass;
        }
        if (!cstPoolParser.find(basicClass, true)) {
            return basicClass;
        }
        ClassReader cr = new ClassReader(basicClass);
        ClassNode cn = new ClassNode();
        cr.accept((ClassVisitor)cn, 0);
        boolean changed = this.transformClassNode(transformedName, cn);
        if (changed) {
            ClassWriter cw = new ClassWriter(1);
            cn.accept((ClassVisitor)cw);
            byte[] bytes = cw.toByteArray();
            AngelicaTweaker.dumpClass(transformedName, basicClass, bytes, this);
            return bytes;
        }
        return basicClass;
    }

    public boolean transformClassNode(String transformedName, ClassNode cn) {
        if (cn == null) {
            return false;
        }
        if (!this.isVanillaBlockSubclass(cn.name) && this.isBlockSubclass(cn.superName)) {
            moddedBlockSubclasses.add(cn.name);
            cstPoolParser.addString(cn.name);
        }
        if (moddedBlockSubclasses.contains(cn.name)) {
            boolean doWeShadow;
            if (blockOwnerExclusions.contains(cn.superName)) {
                doWeShadow = true;
            } else {
                Set fieldsDeclaredByClass = cn.fields.stream().map(f -> f.name).collect(Collectors.toSet());
                doWeShadow = BlockTransformer.BlockBoundsFields.stream().anyMatch(pair -> fieldsDeclaredByClass.contains(pair.getLeft()) || fieldsDeclaredByClass.contains(pair.getRight()));
            }
            if (doWeShadow) {
                AngelicaTweaker.LOGGER.info("Class '{}' shadows one or more block bounds fields, these accesses won't be redirected!", new Object[]{cn.name});
                blockOwnerExclusions.add(cn.name);
            }
        }
        boolean changed = false;
        for (MethodNode mn : cn.methods) {
            if (transformedName.equals("net.minecraft.client.renderer.OpenGlHelper") && (mn.name.equals("glBlendFunc") || mn.name.equals("func_148821_a"))) continue;
            boolean redirectInMethod = false;
            for (AbstractInsnNode node : mn.instructions.toArray()) {
                if (node instanceof MethodInsnNode) {
                    MethodInsnNode mNode = (MethodInsnNode)node;
                    if (mNode.owner.equals(GL11) && (mNode.name.equals("glEnable") || mNode.name.equals("glDisable")) && mNode.desc.equals("(I)V")) {
                        AbstractInsnNode prevNode = node.getPrevious();
                        String name = null;
                        if (prevNode instanceof LdcInsnNode) {
                            LdcInsnNode ldcNode = (LdcInsnNode)prevNode;
                            name = glCapRedirects.get((Integer)ldcNode.cst);
                        } else if (prevNode instanceof IntInsnNode) {
                            IntInsnNode intNode = (IntInsnNode)prevNode;
                            name = glCapRedirects.get(intNode.operand);
                        }
                        if (name != null) {
                            name = mNode.name.equals("glEnable") ? "enable" + name : "disable" + name;
                        }
                        if (IrisLogging.ENABLE_SPAM) {
                            if (name == null) {
                                AngelicaTweaker.LOGGER.info("Redirecting call in {} from GL11.{}(I)V to GLStateManager.{}(I)V", new Object[]{transformedName, mNode.name, mNode.name});
                            } else {
                                AngelicaTweaker.LOGGER.info("Redirecting call in {} from GL11.{}(I)V to GLStateManager.{}()V", new Object[]{transformedName, mNode.name, name});
                            }
                        }
                        mNode.owner = GLStateManager;
                        if (name != null) {
                            mNode.name = name;
                            mNode.desc = "()V";
                            mn.instructions.remove(prevNode);
                        }
                        changed = true;
                        redirectInMethod = true;
                        ++remaps;
                        continue;
                    }
                    if (mNode.owner.startsWith(Drawable) && mNode.name.equals("makeCurrent")) {
                        mNode.setOpcode(184);
                        mNode.owner = GLStateManager;
                        mNode.desc = "(Lorg/lwjgl/opengl/Drawable;)V";
                        mNode.itf = false;
                        changed = true;
                        if (!IrisLogging.ENABLE_SPAM) continue;
                        AngelicaTweaker.LOGGER.info("Redirecting call in {} to GLStateManager.makeCurrent()", new Object[]{transformedName});
                        continue;
                    }
                    Map<String, String> redirects = methodRedirects.get(mNode.owner);
                    if (redirects == null || !redirects.containsKey(mNode.name)) continue;
                    if (IrisLogging.ENABLE_SPAM) {
                        String shortOwner = mNode.owner.substring(mNode.owner.lastIndexOf("/") + 1);
                        AngelicaTweaker.LOGGER.info("Redirecting call in {} from {}.{}{} to GLStateManager.{}{}", new Object[]{transformedName, shortOwner, mNode.name, mNode.desc, redirects.get(mNode.name), mNode.desc});
                    }
                    mNode.owner = GLStateManager;
                    mNode.name = redirects.get(mNode.name);
                    changed = true;
                    redirectInMethod = true;
                    ++remaps;
                    continue;
                }
                if (node.getOpcode() != 180 && node.getOpcode() != 181 || !(node instanceof FieldInsnNode)) continue;
                FieldInsnNode fNode = (FieldInsnNode)node;
                if (blockOwnerExclusions.contains(fNode.owner) || !this.isBlockSubclass(fNode.owner) || !RedirectorTransformer.isSodiumEnabled()) continue;
                Pair<String, String> fieldToRedirect = null;
                for (Pair<String, String> blockPairs : BlockTransformer.BlockBoundsFields) {
                    if (!fNode.name.equals(blockPairs.getLeft()) && !fNode.name.equals(blockPairs.getRight())) continue;
                    fieldToRedirect = blockPairs;
                    break;
                }
                if (fieldToRedirect == null) continue;
                if (IrisLogging.ENABLE_SPAM) {
                    AngelicaTweaker.LOGGER.info("Redirecting Block.{} in {} to thread-safe wrapper", new Object[]{fNode.name, transformedName});
                }
                fNode.name = (String)fieldToRedirect.getLeft();
                fNode.owner = ThreadedBlockData;
                MethodInsnNode getter = new MethodInsnNode(184, ThreadedBlockData, "get", "(Lnet/minecraft/block/Block;)Lcom/gtnewhorizons/angelica/glsm/ThreadedBlockData;", false);
                if (node.getOpcode() == 180) {
                    mn.instructions.insertBefore((AbstractInsnNode)fNode, (AbstractInsnNode)getter);
                } else if (node.getOpcode() == 181) {
                    InsnList beforePut = new InsnList();
                    beforePut.add((AbstractInsnNode)new InsnNode(93));
                    beforePut.add((AbstractInsnNode)new InsnNode(88));
                    beforePut.add((AbstractInsnNode)getter);
                    beforePut.add((AbstractInsnNode)new InsnNode(91));
                    beforePut.add((AbstractInsnNode)new InsnNode(87));
                    mn.instructions.insertBefore((AbstractInsnNode)fNode, beforePut);
                }
                changed = true;
            }
            if (!ASSERT_MAIN_THREAD || !redirectInMethod || transformedName.startsWith(SplashProgress) || transformedName.startsWith(MinecraftClient) && ExcludedMinecraftMainThreadChecks.contains(mn.name)) continue;
            mn.instructions.insert((AbstractInsnNode)new MethodInsnNode(184, GLStateManager, "assertMainThread", "()V", false));
        }
        return changed;
    }

    static {
        glCapRedirects.put(3008, "AlphaTest");
        glCapRedirects.put(3042, "Blend");
        glCapRedirects.put(2929, "DepthTest");
        glCapRedirects.put(2884, "Cull");
        glCapRedirects.put(2896, "Lighting");
        glCapRedirects.put(3553, "Texture");
        glCapRedirects.put(2912, "Fog");
        glCapRedirects.put(32826, "RescaleNormal");
        glCapRedirects.put(3089, "ScissorTest");
        methodRedirects.put(GL11, RedirectMap.newMap().add("glAlphaFunc").add("glBegin").add("glBindTexture").add("glBlendFunc").add("glCallList").add("glClear").add("glClearColor").add("glClearDepth").add("glColor3b").add("glColor3d").add("glColor3f").add("glColor3ub").add("glColor4b").add("glColor4d").add("glColor4f").add("glColor4ub").add("glColorMask").add("glColorMaterial").add("glDeleteTextures").add("glDepthFunc").add("glDepthMask").add("glDepthRange").add("glDrawArrays").add("glDrawBuffer").add("glDrawElements").add("glEdgeFlag").add("glEndList").add("glFog").add("glFogf").add("glFogi").add("glFrustum").add("glGetBoolean").add("glGetFloat").add("glGetInteger").add("glGetLight").add("glGetMaterial").add("glGetTexLevelParameteri").add("glGetTexParameterf").add("glGetTexParameteri").add("glIsEnabled").add("glMaterial").add("glMaterialf").add("glMateriali").add("glLight").add("glLightf").add("glLighti").add("glLightModel").add("glLightModelf").add("glLightModeli").add("glLoadIdentity").add("glLoadMatrix").add("glLogicOp").add("glMatrixMode").add("glMultMatrix").add("glNewList").add("glNormal3b").add("glNormal3d").add("glNormal3f").add("glNormal3i").add("glOrtho").add("glPopAttrib").add("glPopMatrix").add("glPushAttrib").add("glPushMatrix").add("glRasterPos2d").add("glRasterPos2f").add("glRasterPos2i").add("glRasterPos3d").add("glRasterPos3f").add("glRasterPos3i").add("glRasterPos4d").add("glRasterPos4f").add("glRasterPos4i").add("glRotated").add("glRotatef").add("glScaled").add("glScalef").add("glShadeModel").add("glTexCoord1d").add("glTexCoord1f").add("glTexCoord2d").add("glTexCoord2f").add("glTexCoord3d").add("glTexCoord3f").add("glTexCoord4d").add("glTexCoord4f").add("glTexImage2D").add("glTexParameter").add("glTexParameterf").add("glTexParameteri").add("glTexParameteri").add("glTranslated").add("glTranslatef").add("glViewport"));
        methodRedirects.put(GL13, RedirectMap.newMap().add("glActiveTexture"));
        methodRedirects.put(GL14, RedirectMap.newMap().add("glBlendFuncSeparate", "tryBlendFuncSeparate").add("glBlendColor").add("glBlendEquation"));
        methodRedirects.put(GL20, RedirectMap.newMap().add("glBlendEquationSeparate").add("glUseProgram"));
        methodRedirects.put(OpenGlHelper, RedirectMap.newMap().add("glBlendFunc", "tryBlendFuncSeparate").add("func_148821_a", "tryBlendFuncSeparate"));
        methodRedirects.put(EXTBlendFunc, RedirectMap.newMap().add("glBlendFuncSeparateEXT", "tryBlendFuncSeparate"));
        methodRedirects.put(ARBMultiTexture, RedirectMap.newMap().add("glActiveTextureARB"));
        methodRedirects.put(Project, RedirectMap.newMap().add("gluPerspective"));
        try {
            MethodHandle sodiumGetter;
            Class<?> angelicaConfig = Class.forName("com.gtnewhorizons.angelica.config.AngelicaConfig", true, (ClassLoader)Launch.classLoader);
            angelicaConfigSodiumEnabledGetter = sodiumGetter = MethodHandles.lookup().findStaticGetter(angelicaConfig, "enableSodium", Boolean.TYPE);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    private static class RedirectMap<K>
    extends HashMap<K, K> {
        private RedirectMap() {
        }

        public static RedirectMap<String> newMap() {
            return new RedirectMap<String>();
        }

        public RedirectMap<K> add(K name) {
            this.put(name, name);
            return this;
        }

        public RedirectMap<K> add(K name, K newName) {
            this.put(name, newName);
            return this;
        }
    }
}

