/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.dynamiclights;

import baubles.common.container.InventoryBaubles;
import baubles.common.lib.PlayerHandler;
import com.gtnewhorizon.gtnhlib.blockpos.BlockPos;
import com.gtnewhorizon.gtnhlib.blockpos.IBlockPos;
import com.gtnewhorizon.gtnhlib.util.CoordinatePacker;
import com.gtnewhorizons.angelica.api.IDynamicLightProducer;
import com.gtnewhorizons.angelica.compat.ModStatus;
import com.gtnewhorizons.angelica.config.AngelicaConfig;
import com.gtnewhorizons.angelica.dynamiclights.DynamicLightsMode;
import com.gtnewhorizons.angelica.dynamiclights.IDynamicLightSource;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Predicate;
import me.jellysquid.mods.sodium.client.render.SodiumWorldRenderer;
import mods.battlegear2.api.core.IBattlePlayer;
import mods.battlegear2.api.core.IInventoryPlayerBattle;
import net.irisshaders.iris.api.v0.IrisApi;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xonin.backhand.api.core.BackhandUtils;

public class DynamicLights {
    private static DynamicLights instance;
    public static DynamicLightsMode Mode;
    public static boolean ShaderForce;
    private static final double MAX_RADIUS = 7.75;
    private static final double MAX_RADIUS_SQUARED = 60.0625;
    private final Set<IDynamicLightSource> dynamicLightSources = new ObjectOpenHashSet();
    private final ReentrantReadWriteLock lightSourcesLock = new ReentrantReadWriteLock();
    private long lastUpdate = System.currentTimeMillis();
    private int lastUpdateCount = 0;

    public static DynamicLights get() {
        if (instance == null) {
            instance = new DynamicLights();
        }
        return instance;
    }

    public static boolean isEnabled() {
        return AngelicaConfig.enableDynamicLights && Mode.isEnabled() && (ShaderForce || !IrisApi.getInstance().isShaderPackInUse());
    }

    public void updateAll(@NotNull SodiumWorldRenderer renderer) {
        if (!DynamicLights.isEnabled()) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now >= this.lastUpdate + (long)Mode.getDelay()) {
            this.lastUpdate = now;
            this.lastUpdateCount = 0;
            this.lightSourcesLock.readLock().lock();
            for (IDynamicLightSource lightSource : this.dynamicLightSources) {
                if (!lightSource.angelica$updateDynamicLight(renderer)) continue;
                ++this.lastUpdateCount;
            }
            this.lightSourcesLock.readLock().unlock();
        }
    }

    public int getLastUpdateCount() {
        return this.lastUpdateCount;
    }

    public void addLightSource(IDynamicLightSource lightSource) {
        this.lightSourcesLock.writeLock().lock();
        this.dynamicLightSources.add(lightSource);
        this.lightSourcesLock.writeLock().unlock();
    }

    public void removeLightSource(@NotNull IDynamicLightSource lightSource) {
        this.lightSourcesLock.writeLock().lock();
        Iterator<IDynamicLightSource> dynamicLightSources = this.dynamicLightSources.iterator();
        while (dynamicLightSources.hasNext()) {
            IDynamicLightSource it = dynamicLightSources.next();
            if (!it.equals(lightSource)) continue;
            dynamicLightSources.remove();
            if (SodiumWorldRenderer.getInstance() == null) break;
            lightSource.angelica$scheduleTrackedChunksRebuild(SodiumWorldRenderer.getInstance());
            break;
        }
        this.lightSourcesLock.writeLock().unlock();
    }

    public void removeLightSources(@NotNull Predicate<IDynamicLightSource> filter) {
        this.lightSourcesLock.writeLock().lock();
        Iterator<IDynamicLightSource> dynamicLightSources = this.dynamicLightSources.iterator();
        while (dynamicLightSources.hasNext()) {
            IDynamicLightSource it = dynamicLightSources.next();
            if (!filter.test(it)) continue;
            dynamicLightSources.remove();
            if (SodiumWorldRenderer.getInstance() == null) break;
            if (it.angelica$getLuminance() > 0) {
                it.angelica$resetDynamicLight();
            }
            it.angelica$scheduleTrackedChunksRebuild(SodiumWorldRenderer.getInstance());
            break;
        }
        this.lightSourcesLock.writeLock().unlock();
    }

    public void clearLightSources() {
        this.lightSourcesLock.writeLock().lock();
        Iterator<IDynamicLightSource> dynamicLightSources = this.dynamicLightSources.iterator();
        while (dynamicLightSources.hasNext()) {
            IDynamicLightSource it = dynamicLightSources.next();
            dynamicLightSources.remove();
            if (SodiumWorldRenderer.getInstance() == null) continue;
            if (it.angelica$getLuminance() > 0) {
                it.angelica$resetDynamicLight();
            }
            it.angelica$scheduleTrackedChunksRebuild(SodiumWorldRenderer.getInstance());
        }
        this.lightSourcesLock.writeLock().unlock();
    }

    public boolean containsLightSource(@NotNull IDynamicLightSource lightSource) {
        this.lightSourcesLock.readLock().lock();
        boolean result = this.dynamicLightSources.contains(lightSource);
        this.lightSourcesLock.readLock().unlock();
        return result;
    }

    public int getLightSourcesCount() {
        this.lightSourcesLock.readLock().lock();
        int result = this.dynamicLightSources.size();
        this.lightSourcesLock.readLock().unlock();
        return result;
    }

    public double getDynamicLightLevel(int x, int y, int z) {
        double result = 0.0;
        this.lightSourcesLock.readLock().lock();
        for (IDynamicLightSource lightSource : this.dynamicLightSources) {
            result = DynamicLights.maxDynamicLightLevel(x, y, z, lightSource, result);
        }
        this.lightSourcesLock.readLock().unlock();
        return MathHelper.func_151237_a((double)result, (double)0.0, (double)15.0);
    }

    public double getDynamicLightLevel(@NotNull BlockPos pos) {
        return this.getDynamicLightLevel(pos.getX(), pos.getY(), pos.getZ());
    }

    public static double maxDynamicLightLevel(int x, int y, int z, @NotNull IDynamicLightSource lightSource, double currentLightLevel) {
        double multiplier;
        double lightLevel;
        double dz;
        double dy;
        double dx;
        double distanceSquared;
        int luminance = lightSource.angelica$getLuminance();
        if (luminance > 0 && (distanceSquared = (dx = (double)x - lightSource.angelica$getDynamicLightX() + 0.5) * dx + (dy = (double)y - lightSource.angelica$getDynamicLightY() + 0.5) * dy + (dz = (double)z - lightSource.angelica$getDynamicLightZ() + 0.5) * dz) <= 60.0625 && (lightLevel = (multiplier = 1.0 - Math.sqrt(distanceSquared) / 7.75) * (double)luminance) > currentLightLevel) {
            return lightLevel;
        }
        return currentLightLevel;
    }

    public static double maxDynamicLightLevel(@NotNull BlockPos pos, @NotNull IDynamicLightSource lightSource, double currentLightLevel) {
        return DynamicLights.maxDynamicLightLevel(pos.getX(), pos.getY(), pos.getZ(), lightSource, currentLightLevel);
    }

    public int getLightmapWithDynamicLight(int x, int y, int z, int lightmap) {
        return this.getLightmapWithDynamicLight(this.getDynamicLightLevel(x, y, z), lightmap);
    }

    public int getLightmapWithDynamicLight(double dynamicLightLevel, int lightmap) {
        int blockLevel;
        if (dynamicLightLevel > 0.0 && dynamicLightLevel > (double)(blockLevel = (lightmap & 0xFFFF) >> 4)) {
            int luminance = (int)(dynamicLightLevel * 16.0);
            lightmap &= 0xFFF00000;
            lightmap |= luminance & 0xFFFFF;
        }
        return lightmap;
    }

    public static void scheduleChunkRebuild(@NotNull SodiumWorldRenderer renderer, @NotNull IBlockPos chunkPos) {
        DynamicLights.scheduleChunkRebuild(renderer, chunkPos.getX(), chunkPos.getY(), chunkPos.getZ());
    }

    public static void scheduleChunkRebuild(@NotNull SodiumWorldRenderer renderer, long chunkPos) {
        DynamicLights.scheduleChunkRebuild(renderer, CoordinatePacker.unpackX((long)chunkPos), CoordinatePacker.unpackY((long)chunkPos), CoordinatePacker.unpackZ((long)chunkPos));
    }

    public static void scheduleChunkRebuild(@NotNull SodiumWorldRenderer renderer, int x, int y, int z) {
        renderer.scheduleRebuildForChunk(x, y, z, false);
    }

    public static void updateTrackedChunks(@NotNull IBlockPos chunkPos, @Nullable LongOpenHashSet old, @Nullable LongOpenHashSet newPos) {
        if (old != null || newPos != null) {
            long pos = chunkPos.asLong();
            if (old != null) {
                old.remove(pos);
            }
            if (newPos != null) {
                newPos.add(pos);
            }
        }
    }

    public static void updateTracking(@NotNull IDynamicLightSource lightSource) {
        boolean enabled = lightSource.angelica$isDynamicLightEnabled();
        int luminance = lightSource.angelica$getLuminance();
        if (!enabled && luminance > 0) {
            lightSource.angelica$setDynamicLightEnabled(true);
        } else if (enabled && luminance < 1) {
            lightSource.angelica$setDynamicLightEnabled(false);
        }
    }

    public static int getLuminanceFromItemStack(@NotNull ItemStack stack, boolean submergedInWater) {
        if (submergedInWater) {
            return 0;
        }
        Item item = stack.func_77973_b();
        if (item instanceof ItemBlock) {
            ItemBlock itemBlock = (ItemBlock)item;
            Block block = itemBlock.field_150939_a;
            if (block != null) {
                return block.func_149750_m();
            }
        } else if (item instanceof IDynamicLightProducer) {
            IDynamicLightProducer lightProducer = (IDynamicLightProducer)item;
            return lightProducer.getLuminance();
        }
        if (item == Items.field_151129_at) {
            return Blocks.field_150353_l.func_149750_m();
        }
        return 0;
    }

    public static int getLuminanceFromEntity(@NotNull Entity entity) {
        if (entity.field_70151_c > 0) {
            return 15;
        }
        if (entity instanceof EntityItem) {
            EntityItem item = (EntityItem)entity;
            return DynamicLights.getLuminanceFromItemStack(item.func_92059_d(), item.func_70055_a(Material.field_151586_h));
        }
        if (entity instanceof EntityLivingBase) {
            InventoryBaubles playerBaubles;
            EntityPlayer player;
            ItemStack offhand;
            IBattlePlayer battlePlayer;
            EntityPlayer player2;
            EntityLivingBase living = (EntityLivingBase)entity;
            int luminance = 0;
            boolean inWater = living.func_70055_a(Material.field_151586_h);
            for (int i = 0; i < 5; ++i) {
                ItemStack itemStack = living.func_71124_b(i);
                if (itemStack == null) continue;
                luminance = Math.max(luminance, DynamicLights.getLuminanceFromItemStack(itemStack, inWater));
            }
            if (ModStatus.isBattlegearLoaded && living instanceof EntityPlayer && (player2 = (EntityPlayer)living) instanceof IBattlePlayer && (battlePlayer = (IBattlePlayer)player2).battlegear2$isBattlemode()) {
                offhand = ((IInventoryPlayerBattle)player2.field_71071_by).battlegear2$getCurrentOffhandWeapon();
                if (offhand != null) {
                    luminance = Math.max(luminance, DynamicLights.getLuminanceFromItemStack(offhand, inWater));
                }
            } else if (ModStatus.isBackhandLoaded && living instanceof EntityPlayer && (offhand = BackhandUtils.getOffhandItem((EntityPlayer)(player = (EntityPlayer)living))) != null) {
                luminance = Math.max(luminance, DynamicLights.getLuminanceFromItemStack(offhand, inWater));
            }
            if (ModStatus.isBaublesLoaded && living instanceof EntityPlayer && (playerBaubles = PlayerHandler.getPlayerBaubles((EntityPlayer)(player = (EntityPlayer)living))) != null) {
                for (int i = 0; i < playerBaubles.func_70302_i_(); ++i) {
                    ItemStack stack = playerBaubles.func_70301_a(i);
                    if (stack == null) continue;
                    luminance = Math.max(luminance, DynamicLights.getLuminanceFromItemStack(stack, inWater));
                }
            }
            return luminance;
        }
        return 0;
    }

    static {
        Mode = DynamicLightsMode.OFF;
        ShaderForce = false;
    }
}

