/*
 * Decompiled with CFR 0.152.
 */
package glowredman.amazingtrophies.model.complex;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import cpw.mods.fml.common.registry.GameData;
import glowredman.amazingtrophies.ConfigHandler;
import glowredman.amazingtrophies.model.PedestalTrophyModelHandler;
import glowredman.amazingtrophies.model.complex.BaseModelStructure;
import glowredman.amazingtrophies.model.complex.GeneratedModelStructure;
import glowredman.amazingtrophies.model.complex.RenderHelperVBO;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.opengl.GL11;

public class ComplexTrophyModelHandler
extends PedestalTrophyModelHandler {
    public static final String ID = "complex";
    public static final String PROPERTY_KEYS = "keys";
    public static final String PROPERTY_METADATA = "metadata";
    public static final String PROPERTY_STRUCTURE = "structure";
    public static final String PROPERTY_TRANSPOSE = "transpose";
    private static final double TROPHY_PEDESTAL_HEIGHT = 0.3125;
    private BaseModelStructure model;

    public ComplexTrophyModelHandler() {
    }

    public ComplexTrophyModelHandler(BaseModelStructure model) {
        this.model = model;
    }

    @Override
    public void parse(String id, JsonObject json) throws JsonSyntaxException {
        Map<Character, Pair<Block, Integer>> blockInfoMap = this.parseKeysToBlockInfoMap(json);
        String[][] structure = this.parseStructureToArray(json, blockInfoMap.keySet());
        this.model = new GeneratedModelStructure(structure, blockInfoMap, ConfigHandler.getBooleanProperty(json, PROPERTY_TRANSPOSE, false));
    }

    private Map<Character, Pair<Block, Integer>> parseKeysToBlockInfoMap(JsonObject json) {
        JsonObject metadata = json.getAsJsonObject(PROPERTY_METADATA);
        JsonObject keys = ConfigHandler.getObjectProperty(json, PROPERTY_KEYS);
        HashMap<Character, Pair<Block, Integer>> resultMap = new HashMap<Character, Pair<Block, Integer>>();
        for (Map.Entry entry : keys.entrySet()) {
            String keyChar = (String)entry.getKey();
            String registryName = ((JsonElement)entry.getValue()).getAsString();
            Block block = (Block)GameData.getBlockRegistry().getRaw(registryName);
            if (block == null) {
                throw new IllegalArgumentException("Could not find block " + registryName + "!");
            }
            if (metadata == null) {
                resultMap.put(Character.valueOf(keyChar.charAt(0)), (Pair<Block, Integer>)Pair.of((Object)block, (Object)0));
                continue;
            }
            int meta = ConfigHandler.getIntegerProperty(metadata, keyChar, 0);
            if (meta < 0 || meta > Short.MAX_VALUE) {
                throw new IllegalArgumentException("Illegal meta value (" + meta + ")!");
            }
            resultMap.put(Character.valueOf(keyChar.charAt(0)), (Pair<Block, Integer>)Pair.of((Object)block, (Object)meta));
        }
        return resultMap;
    }

    private String[][] parseStructureToArray(JsonObject json, Set<Character> blockKeys) {
        if (!json.has(PROPERTY_STRUCTURE)) {
            throw new JsonSyntaxException("Required property \"structure\" is missing!");
        }
        JsonArray outerArray = json.getAsJsonArray(PROPERTY_STRUCTURE);
        String[][] structure = new String[outerArray.size()][];
        int sizeY = 0;
        int sizeZ = 0;
        for (int i = 0; i < outerArray.size(); ++i) {
            JsonArray innerArray = outerArray.get(i).getAsJsonArray();
            if (sizeZ > 0) {
                if (sizeZ != innerArray.size()) {
                    throw new IllegalArgumentException("Inconsistent structure length (inner array sizes)!");
                }
            } else {
                sizeZ = innerArray.size();
            }
            structure[i] = new String[innerArray.size()];
            for (int j = 0; j < innerArray.size(); ++j) {
                String line = innerArray.get(j).getAsString();
                if (sizeY > 0) {
                    if (sizeY != line.length()) {
                        throw new IllegalArgumentException("Inconsistent structure length (line lengths)!");
                    }
                } else {
                    sizeY = line.length();
                }
                for (int k = 0; k < line.length(); ++k) {
                    char c = line.charAt(k);
                    if (Character.isSpaceChar(c) || blockKeys.contains(Character.valueOf(c))) continue;
                    throw new IllegalArgumentException("Structure key '" + c + "' (array=" + i + ", line=" + j + ", char=" + k + ") is not not defined!");
                }
                structure[i][j] = line;
            }
        }
        return structure;
    }

    @Override
    public void render(double x, double y, double z, int rotation, @Nullable String name, long time, float partialTickTime) {
        super.render(x, y, z, rotation, name, time, partialTickTime);
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)1048575);
        GL11.glEnable((int)2896);
        GL11.glTranslated((double)x, (double)(y - 0.5 + 0.3125), (double)z);
        GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(22.5f * (float)rotation), (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelperVBO.renderModel(this.model);
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }
}

