/*
 * Decompiled with CFR 0.152.
 */
package glowredman.amazingtrophies.api;

import glowredman.amazingtrophies.api.AmazingTrophiesAPI;
import glowredman.amazingtrophies.api.ItemDefinition;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.stats.Achievement;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatList;
import net.minecraftforge.common.AchievementPage;

@ParametersAreNonnullByDefault
public class AchievementProperties {
    private final String page;
    private final int x;
    private final int y;
    private final String parent;
    private final boolean isSpecial;
    private final ItemDefinition icon;
    private String id;
    private boolean registered = false;

    private AchievementProperties(@Nullable String page, int x, int y, @Nullable String parent, boolean isSpecial, ItemDefinition icon) {
        this.page = page;
        this.x = x;
        this.y = y;
        this.parent = parent;
        this.isSpecial = isSpecial;
        this.icon = icon;
    }

    public String getPage() {
        return this.page;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    @Nullable
    public String getParent() {
        return this.parent;
    }

    public boolean isSpecial() {
        return this.isSpecial;
    }

    public ItemDefinition getIcon() {
        return this.icon;
    }

    public String getID() {
        return this.id;
    }

    void setID(String id) {
        this.id = id;
    }

    public boolean isRegistered() {
        return this.registered;
    }

    public void register() {
        if (this.registered) {
            return;
        }
        Achievement parent = null;
        String parentID = this.parent;
        if (parentID != null && !parentID.isEmpty()) {
            StatBase stat = StatList.func_151177_a((String)parentID);
            if (!(stat instanceof Achievement)) {
                AmazingTrophiesAPI.LOGGER.error("Parent achievement {} of {} is invalid or not yet registered!", new Object[]{this.parent, this.id});
                return;
            }
            parent = (Achievement)stat;
        }
        Achievement achievement = new Achievement(this.id, this.id, this.x, this.y, this.icon.getAsStack(), parent);
        if (parent == null) {
            achievement.func_75966_h();
        }
        if (this.isSpecial) {
            achievement.func_75987_b();
        }
        if (this.page == null) {
            achievement.func_75971_g();
            this.registered = true;
            return;
        }
        AchievementPage page = AchievementPage.getAchievementPage((String)this.page);
        if (page == null) {
            AmazingTrophiesAPI.LOGGER.error("Achievement page {} of achievement {} is invalid or not yet registered!", new Object[]{this.page, this.id});
            return;
        }
        achievement.func_75971_g();
        page.getAchievements().add(achievement);
        this.registered = true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AchievementProperties)) return false;
        AchievementProperties other = (AchievementProperties)obj;
        if (!this.id.equals(other.id)) return false;
        return true;
    }

    public String toString() {
        return String.format("AchievementProperties(id=\"%s\")", this.id);
    }

    @ParametersAreNonnullByDefault
    public static class Builder {
        private String page;
        private final int x;
        private final int y;
        private String parent;
        private boolean isSpecial;
        private final ItemDefinition icon;

        public Builder(int x, int y, ItemDefinition icon) {
            this.x = x;
            this.y = y;
            this.icon = icon;
        }

        public Builder setPage(@Nullable String page) {
            this.page = page;
            return this;
        }

        public Builder setParent(@Nullable String parent) {
            this.parent = parent;
            return this;
        }

        public Builder setSpecial() {
            this.isSpecial = true;
            return this;
        }

        public Builder setSpecial(boolean isSpecial) {
            this.isSpecial = isSpecial;
            return this;
        }

        public AchievementProperties build() {
            return new AchievementProperties(this.page, this.x, this.y, this.parent, this.isSpecial, this.icon);
        }
    }
}

