/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.inventory.gui;

import appeng.container.AEBaseContainer;
import appeng.container.ContainerOpenContext;
import com.glodblock.github.inventory.gui.PartGuiFactory;
import com.glodblock.github.inventory.item.IItemInventory;
import com.glodblock.github.util.Util;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.tuple.ImmutablePair;

public abstract class PartOrItemGuiFactory<T>
extends PartGuiFactory<T> {
    PartOrItemGuiFactory(Class<T> invClass) {
        super(invClass);
    }

    @Nullable
    protected T getItemInventory(Object inv) {
        return this.invClass.isInstance(inv) ? (T)this.invClass.cast(inv) : null;
    }

    @Override
    @Nullable
    public Object createServerGui(EntityPlayer player, World world, int x, int y, int z, ForgeDirection face) {
        ImmutablePair<Util.GuiHelper.GuiType, Integer> result = Util.GuiHelper.decodeType(y);
        if (result.getLeft() == Util.GuiHelper.GuiType.ITEM) {
            ItemStack item = Util.getWirelessTerminal(player, x);
            if (item == null || !(item.func_77973_b() instanceof IItemInventory)) {
                return null;
            }
            T inv = this.getItemInventory(((IItemInventory)item.func_77973_b()).getInventory(item, world, x, (Integer)result.getRight(), z, player));
            if (inv == null) {
                return null;
            }
            Object gui = this.createServerGui(player, inv);
            if (gui instanceof AEBaseContainer) {
                ContainerOpenContext ctx = new ContainerOpenContext(inv);
                ctx.setWorld(world);
                ctx.setX(x);
                ctx.setY(y);
                ctx.setZ(z);
                ctx.setSide(face);
                ((AEBaseContainer)gui).setOpenContext(ctx);
            }
            return gui;
        }
        return super.createServerGui(player, world, x, (Integer)result.getRight(), z, face);
    }

    @Override
    @Nullable
    public Object createClientGui(EntityPlayer player, World world, int x, int y, int z, ForgeDirection face) {
        ImmutablePair<Util.GuiHelper.GuiType, Integer> result = Util.GuiHelper.decodeType(y);
        if (result.left == Util.GuiHelper.GuiType.ITEM) {
            ItemStack item = Util.getWirelessTerminal(player, x);
            if (item == null || !(item.func_77973_b() instanceof IItemInventory)) {
                return null;
            }
            T inv = this.getItemInventory(((IItemInventory)item.func_77973_b()).getInventory(item, world, x, (Integer)result.getRight(), z, player));
            return inv != null ? this.createClientGui(player, inv) : null;
        }
        return super.createClientGui(player, world, x, (Integer)result.getRight(), z, face);
    }
}

