/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.client.gui;

import appeng.client.gui.widgets.ITooltip;
import com.glodblock.github.FluidCraft;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;

public class GuiFCImgButton
extends GuiButton
implements ITooltip {
    private static final Pattern COMPILE = Pattern.compile("%s");
    private static final Pattern PATTERN_NEW_LINE = Pattern.compile("\\n", 16);
    private static Map<EnumPair, ButtonAppearance> appearances;
    private final String buttonSetting;
    private boolean halfSize = false;
    private String fillVar;
    private String currentValue;
    private final boolean background;
    private static final String prefix = "ae2fc.tooltip.";

    public GuiFCImgButton(int x, int y, String idx, String val) {
        this(x, y, idx, val, true);
    }

    public GuiFCImgButton(int x, int y, String idx, String val, boolean background) {
        super(0, 0, 16, "");
        this.background = background;
        this.buttonSetting = idx;
        this.currentValue = val;
        this.field_146128_h = x;
        this.field_146129_i = y;
        this.field_146120_f = 16;
        this.field_146121_g = 16;
        if (appearances == null) {
            appearances = new HashMap<EnumPair, ButtonAppearance>();
            this.registerApp(0, "NOT_COMBINE", "DONT_COMBINE", "not_combine");
            this.registerApp(1, "FORCE_COMBINE", "DO_COMBINE", "combine");
            this.registerApp(2, "FORCE_PRIO", "DO_PRIO", "prio");
            this.registerApp(3, "NOT_PRIO", "DONT_PRIO", "not_prio");
            this.registerApp(4, "SUBMIT", "SUBMIT", "submit");
            this.registerApp(5, "EDIT", "YES", "edit");
            this.registerApp(6, "DISABLE", "DISABLE", "disable");
            this.registerApp(7, "ENABLE", "ENABLE", "enable");
            this.registerApp(10, "FLUID_TEM", "YES", "fluid_terminal_w");
            this.registerApp(11, "CRAFT_TEM", "YES", "craft_terminal_w");
            this.registerApp(12, "PATTERN_TEM", "YES", "pattern_terminal_w");
            this.registerApp(13, "ESSENTIA_TEM", "YES", "essentia_terminal_w");
            this.registerApp(14, "INTERFACE_TEM", "YES", "interface_terminal_w");
            this.registerApp(15, "PATTERN_EX_TEM", "YES", "pattern_terminal_ex_w");
            this.registerApp(16, "FILL_PATTERN", "DO_FILL", "fill_pattern");
            this.registerApp(17, "NOT_FILL_PATTERN", "DONT_FILL", "not_fill_pattern");
            this.registerApp(20, "LEVEL_TEM", "YES", "level_terminal_w");
            this.registerApp(21, "SWITCH", "ON", "edit");
            this.registerApp(22, "SWITCH", "OFF", "view");
            this.registerApp(21, "SWITCH", "ENABLE", "enable");
            this.registerApp(22, "SWITCH", "DISABLE", "disable");
            this.registerApp(23, "CONFIG", "YES", "open_configuration");
            this.registerApp(24, "HIGHLIGHT", "YES", "block_highlight");
        }
    }

    private void registerApp(int iconIndex, String setting, String val, String title) {
        ButtonAppearance a = new ButtonAppearance();
        a.displayName = StatCollector.func_74838_a((String)(prefix + title));
        a.displayValue = StatCollector.func_74838_a((String)(prefix + title + ".hint")).equals(prefix + title + ".hint") ? null : StatCollector.func_74838_a((String)(prefix + title + ".hint"));
        a.index = iconIndex % 10;
        a.page = iconIndex / 10;
        appearances.put(new EnumPair(setting, val), a);
    }

    public void setVisibility(boolean vis) {
        this.field_146125_m = vis;
        this.field_146124_l = vis;
    }

    private int getIconIndex() {
        if (this.buttonSetting != null && this.currentValue != null) {
            ButtonAppearance app = appearances.get(new EnumPair(this.buttonSetting, this.currentValue));
            if (app == null) {
                return 8;
            }
            return app.index;
        }
        return 8;
    }

    private int getIconPage() {
        if (this.buttonSetting != null && this.currentValue != null) {
            ButtonAppearance app = appearances.get(new EnumPair(this.buttonSetting, this.currentValue));
            if (app == null) {
                return 0;
            }
            return app.page;
        }
        return 0;
    }

    public String getSetting() {
        return this.buttonSetting;
    }

    public String getCurrentValue() {
        return this.currentValue;
    }

    public boolean getMouseIn() {
        return this.field_146123_n;
    }

    public void set(String e) {
        if (!this.currentValue.equals(e)) {
            this.currentValue = e;
        }
    }

    public boolean isHalfSize() {
        return this.halfSize;
    }

    public void setHalfSize(boolean halfSize) {
        this.halfSize = halfSize;
    }

    public String getFillVar() {
        return this.fillVar;
    }

    public void setFillVar(String fillVar) {
        this.fillVar = fillVar;
    }

    public int xPos() {
        return this.field_146128_h;
    }

    public int yPos() {
        return this.field_146129_i;
    }

    public int getWidth() {
        return this.halfSize ? 8 : 16;
    }

    public int getHeight() {
        return this.halfSize ? 8 : 16;
    }

    public boolean isVisible() {
        return this.field_146125_m;
    }

    public String getMessage() {
        String displayName = null;
        String displayValue = null;
        if (this.buttonSetting != null && this.currentValue != null) {
            ButtonAppearance buttonAppearance = appearances.get(new EnumPair(this.buttonSetting, this.currentValue));
            if (buttonAppearance == null) {
                return "No Such Message";
            }
            displayName = buttonAppearance.displayName;
            displayValue = buttonAppearance.displayValue;
        }
        if (displayName != null) {
            String name = StatCollector.func_74838_a(displayName);
            if (name == null || name.isEmpty()) {
                name = displayName;
            }
            if (displayValue != null) {
                StringBuilder sb;
                int i;
                String value = StatCollector.func_74838_a(displayValue);
                if (this.fillVar != null) {
                    value = COMPILE.matcher(value).replaceFirst(this.fillVar);
                }
                if ((i = (sb = new StringBuilder(value = PATTERN_NEW_LINE.matcher(value).replaceAll("\n"))).lastIndexOf("\n")) <= 0) {
                    i = 0;
                }
                while (i + 30 < sb.length() && (i = sb.lastIndexOf(" ", i + 30)) != -1) {
                    sb.replace(i, i + 1, "\n");
                }
                return name + '\n' + sb;
            }
            return name;
        }
        return null;
    }

    public void func_146112_a(Minecraft par1Minecraft, int par2, int par3) {
        if (this.field_146125_m) {
            int iconIndex = this.getIconIndex();
            int iconPage = this.getIconPage();
            if (this.halfSize) {
                this.field_146120_f = 8;
                this.field_146121_g = 8;
                GL11.glPushMatrix();
                GL11.glTranslatef((float)this.field_146128_h, (float)this.field_146129_i, (float)0.0f);
                GL11.glScalef((float)0.09375f, (float)0.09375f, (float)0.09375f);
                if (this.field_146124_l) {
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                } else {
                    GL11.glColor4f((float)0.5f, (float)0.5f, (float)0.5f, (float)1.0f);
                }
                par1Minecraft.field_71446_o.func_110577_a(FluidCraft.resource("textures/gui/states" + iconPage + ".png"));
                this.field_146123_n = par2 >= this.field_146128_h && par3 >= this.field_146129_i && par2 < this.field_146128_h + this.field_146120_f && par3 < this.field_146129_i + this.field_146121_g;
                int uv_y = (int)Math.floor((double)iconIndex / 3.0);
                int uv_x = iconIndex - uv_y * 3;
                if (this.background) {
                    this.func_73729_b(0, 0, Math.round(170.66667f), Math.round(170.66667f), Math.round(85.333336f), Math.round(85.333336f));
                }
                this.func_73729_b(0, 0, Math.round((float)uv_x * 16.0f * 16.0f / 3.0f), Math.round((float)uv_y * 16.0f * 16.0f / 3.0f), Math.round(85.333336f), Math.round(85.333336f));
            } else {
                GL11.glPushMatrix();
                GL11.glTranslatef((float)this.field_146128_h, (float)this.field_146129_i, (float)0.0f);
                GL11.glScalef((float)0.1875f, (float)0.1875f, (float)0.1875f);
                if (this.field_146124_l) {
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                } else {
                    GL11.glColor4f((float)0.5f, (float)0.5f, (float)0.5f, (float)1.0f);
                }
                par1Minecraft.field_71446_o.func_110577_a(FluidCraft.resource("textures/gui/states" + iconPage + ".png"));
                this.field_146123_n = par2 >= this.field_146128_h && par3 >= this.field_146129_i && par2 < this.field_146128_h + this.field_146120_f && par3 < this.field_146129_i + this.field_146121_g;
                int uv_y = (int)Math.floor((double)iconIndex / 3.0);
                int uv_x = iconIndex - uv_y * 3;
                if (this.background) {
                    this.func_73729_b(0, 0, Math.round(170.66667f), Math.round(170.66667f), Math.round(85.333336f), Math.round(85.333336f));
                }
                this.func_73729_b(0, 0, Math.round((float)uv_x * 16.0f * 16.0f / 3.0f), Math.round((float)uv_y * 16.0f * 16.0f / 3.0f), Math.round(85.333336f), Math.round(85.333336f));
            }
            this.func_146119_b(par1Minecraft, par2, par3);
            GL11.glPopMatrix();
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static class ButtonAppearance {
        public int index;
        public int page;
        public String displayName;
        public String displayValue;

        private ButtonAppearance() {
        }
    }

    private static final class EnumPair {
        final String setting;
        final String value;

        EnumPair(String a, String b) {
            this.setting = a;
            this.value = b;
        }

        public int hashCode() {
            return this.setting.hashCode() ^ this.value.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EnumPair other = (EnumPair)obj;
            return other.setting.equals(this.setting) && other.value.equals(this.value);
        }
    }
}

