/*
 * Decompiled with CFR 0.152.
 */
package com.darkona.adventurebackpack.network;

import com.darkona.adventurebackpack.common.ServerActions;
import com.darkona.adventurebackpack.util.Wearing;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;

public class WearableModePacket
implements IMessageHandler<Message, Message> {
    public static final byte COPTER_ON_OFF = 0;
    public static final byte COPTER_TOGGLE = 1;
    public static final byte JETPACK_ON_OFF = 2;
    public static final byte CYCLING_ON_OFF = 3;
    public static final byte NIGHTVISION_ON_OFF = 4;

    public Message onMessage(Message message, MessageContext ctx) {
        if (ctx.side.isServer()) {
            ItemStack backpack;
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            if (player == null || player.field_70128_L) {
                return null;
            }
            if (message.type == 0 || message.type == 1) {
                ItemStack copter = Wearing.getWearingCopter((EntityPlayer)player);
                if (copter != null) {
                    ServerActions.toggleCopterPack((EntityPlayer)player, copter, message.type);
                }
            } else if (message.type == 2) {
                ItemStack jetpack = Wearing.getWearingJetpack((EntityPlayer)player);
                if (jetpack != null) {
                    ServerActions.toggleCoalJetpack((EntityPlayer)player, jetpack);
                }
            } else if ((message.type == 3 || message.type == 4) && (backpack = Wearing.getWearingBackpack((EntityPlayer)player)) != null) {
                if (message.type == 3) {
                    ServerActions.toggleToolCycling((EntityPlayer)player, backpack);
                } else if (message.type == 4) {
                    ServerActions.toggleNightVision((EntityPlayer)player, backpack);
                }
            }
        }
        return null;
    }

    public static class Message
    implements IMessage {
        private byte type;

        public Message() {
        }

        public Message(byte type) {
            this.type = type;
        }

        public void fromBytes(ByteBuf buf) {
            this.type = buf.readByte();
        }

        public void toBytes(ByteBuf buf) {
            buf.writeByte((int)this.type);
        }
    }
}

