/*
 * Decompiled with CFR 0.152.
 */
package com.darkona.adventurebackpack.inventory;

import com.darkona.adventurebackpack.inventory.SlotAdventure;
import com.darkona.adventurebackpack.util.GregtechUtils;
import com.darkona.adventurebackpack.util.ThaumcraftUtils;
import com.darkona.adventurebackpack.util.TinkersUtils;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFishingRod;
import net.minecraft.item.ItemFlintAndSteel;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;

public class SlotTool
extends SlotAdventure {
    private static final String[] VALID_TOOL_NAMES = new String[]{"axe", "crowbar", "drill", "grafter", "hammer", "scoop", "shovel", "wrench"};
    private static final String[] INVALID_TOOL_NAMES = new String[]{"bow", "bucket", "shield", "sword"};
    private static final String[] INVALID_TINKER_NAMES = new String[]{"battleaxe", "bow", "cleaver", "cutlass", "dagger", "rapier", "sabre", "shield", "sign", "sword"};

    SlotTool(IInventory inventory, int slotIndex, int posX, int posY) {
        super(inventory, slotIndex, posX, posY);
    }

    public boolean func_75214_a(ItemStack stack) {
        return SlotTool.isValidTool(stack);
    }

    public static boolean isValidTool(ItemStack stack) {
        if (stack == null || stack.func_77976_d() != 1) {
            return false;
        }
        Item item = stack.func_77973_b();
        String clazzName = item.getClass().getName();
        String objectName = Item.field_150901_e.func_148750_c((Object)item);
        String itemName = item.func_77658_a().toLowerCase();
        if (item instanceof ItemTool || item instanceof ItemHoe || item instanceof ItemShears || item instanceof ItemFishingRod || item instanceof ItemFlintAndSteel) {
            return true;
        }
        if (GregtechUtils.isTool(itemName)) {
            int meta = stack.func_77960_j();
            return meta != 0 && meta != 24 && meta <= 169;
        }
        if (itemName.startsWith("gt.metaitem")) {
            return false;
        }
        if (TinkersUtils.isTool(clazzName)) {
            for (String toolName : INVALID_TINKER_NAMES) {
                if (!itemName.contains(toolName)) continue;
                return false;
            }
            return true;
        }
        if (ThaumcraftUtils.isTool(stack)) {
            return true;
        }
        if (objectName.equals("EnderIO:itemYetaWrench")) {
            return false;
        }
        if (clazzName.equals("com.rwtema.extrautils.item.ItemBuildersWand")) {
            return true;
        }
        if (objectName.startsWith("betterbuilderswands:wand")) {
            return true;
        }
        for (String toolName : INVALID_TOOL_NAMES) {
            if (!itemName.contains(toolName)) continue;
            return false;
        }
        for (String toolName : VALID_TOOL_NAMES) {
            if (!itemName.contains(toolName)) continue;
            return true;
        }
        if (clazzName.startsWith("mekanism.common.item")) {
            return !itemName.contains("disassembler") && !itemName.contains("robit");
        }
        try {
            if (Class.forName("buildcraft.api.tools.IToolWrench").isInstance(item)) {
                return true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            if (Class.forName("ic2.api.item.IElectricItem").isInstance(item)) {
                return true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            if (Class.forName("cofh.core.item.tool").isInstance(item)) {
                return true;
            }
            if (Class.forName("thermalexpansion.item.tool").isInstance(item)) {
                return true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return false;
    }
}

