/*
 * Decompiled with CFR 0.152.
 */
package witchinggadgets.common.recipes.alchemic;

import cpw.mods.fml.common.Loader;
import gregtech.api.enums.TCAspects;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.oredict.OreDictionary;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.common.lib.utils.Utils;
import witchinggadgets.WitchingGadgets;
import witchinggadgets.common.WGConfig;
import witchinggadgets.common.WGContent;
import witchinggadgets.common.WGModCompat;
import witchinggadgets.common.items.ItemClusters;
import witchinggadgets.common.recipes.WG_alchemic_recipes;
import witchinggadgets.common.util.Utilities;
import witchinggadgets.common.util.registry.MetalFluidData;

public class WG_alchemic_clusters {
    public static void registerClusters() {
        if (Loader.isModLoaded((String)"gregtech") && !Loader.isModLoaded((String)"gregapi")) {
            for (int iOre = 0; iOre < WGContent.GT_Cluster.length; ++iOre) {
                boolean bb;
                AspectList alchemyAspects;
                if (WGConfig.allowClusters) {
                    ItemStack ingot = (ItemStack)OreDictionary.getOres((String)("ore" + WGContent.GT_Cluster[iOre])).get(0);
                    if (ingot == null) {
                        WitchingGadgets.logger.error(WGContent.GT_Cluster[iOre] + " == null! This should not happen!");
                        continue;
                    }
                    try {
                        alchemyAspects = ((AspectList)ThaumcraftApi.objectTags.get(Arrays.asList(ingot.func_77973_b(), ingot.func_77960_j()))).add(Aspect.ORDER, 1);
                    }
                    catch (NullPointerException e2) {
                        WitchingGadgets.logger.error("Could not get the objectTags for" + WGContent.GT_Cluster[iOre]);
                        alchemyAspects = new AspectList().add(Aspect.METAL, 2).add(Aspect.ORDER, 1).add((Aspect)TCAspects.NEBRISUM.mAspect, 2);
                    }
                    if (alchemyAspects == null || alchemyAspects.equals(new AspectList()) || alchemyAspects.size() < 3) {
                        alchemyAspects = new AspectList().add(Aspect.METAL, 2).add(Aspect.ORDER, 1).add(Aspect.GREED, 2);
                    } else if (alchemyAspects.size() > 6) {
                        alchemyAspects = new AspectList().add(Aspect.METAL, 2).add(Aspect.ORDER, 1).add(Aspect.GREED, 2);
                    }
                    if (!OreDictionary.getOres((String)("ore" + WGContent.GT_Cluster[iOre])).isEmpty()) {
                        WG_alchemic_recipes.registerAlchemyRecipe("METALLURGICPERFECTION_CLUSTERS", "_" + WGContent.GT_Cluster[iOre], new ItemStack(WGContent.ItemCluster, 2, iOre), "ore" + WGContent.GT_Cluster[iOre], alchemyAspects);
                    }
                    if (!OreDictionary.getOres((String)("oreNetherrack" + WGContent.GT_Cluster[iOre])).isEmpty()) {
                        WG_alchemic_recipes.registerAlchemyRecipe("METALLURGICPERFECTION_CLUSTERS", "_Netherrack_" + WGContent.GT_Cluster[iOre], new ItemStack(WGContent.ItemCluster, 4, iOre), "oreNetherrack" + WGContent.GT_Cluster[iOre], alchemyAspects);
                    }
                    if (!OreDictionary.getOres((String)("oreEndstone" + WGContent.GT_Cluster[iOre])).isEmpty()) {
                        ++WG_alchemic_recipes.registerAlchemyRecipe((String)"METALLURGICPERFECTION_CLUSTERS", (String)new StringBuilder().append((String)"_Endstone_").append((String)WGContent.GT_Cluster[iOre]).toString(), (ItemStack)new ItemStack((Item)WGContent.ItemCluster, (int)4, (int)iOre), (Object)new StringBuilder().append((String)"oreEndstone").append((String)WGContent.GT_Cluster[iOre]).toString(), (AspectList)alchemyAspects).hash;
                    }
                    if (!OreDictionary.getOres((String)("oreBlackgranite" + WGContent.GT_Cluster[iOre])).isEmpty()) {
                        ++WG_alchemic_recipes.registerAlchemyRecipe((String)"METALLURGICPERFECTION_CLUSTERS", (String)new StringBuilder().append((String)"_Blackgranite_").append((String)WGContent.GT_Cluster[iOre]).toString(), (ItemStack)new ItemStack((Item)WGContent.ItemCluster, (int)2, (int)iOre), (Object)new StringBuilder().append((String)"oreBlackgranite").append((String)WGContent.GT_Cluster[iOre]).toString(), (AspectList)alchemyAspects).hash;
                    }
                    if (!OreDictionary.getOres((String)("oreRedgranite" + WGContent.GT_Cluster[iOre])).isEmpty()) {
                        WG_alchemic_recipes.registerAlchemyRecipe((String)"METALLURGICPERFECTION_CLUSTERS", (String)new StringBuilder().append((String)"_Redgranite_").append((String)WGContent.GT_Cluster[iOre]).toString(), (ItemStack)new ItemStack((Item)WGContent.ItemCluster, (int)2, (int)iOre), (Object)new StringBuilder().append((String)"oreRedgranite").append((String)WGContent.GT_Cluster[iOre]).toString(), (AspectList)alchemyAspects).hash += 2;
                    }
                    if (!OreDictionary.getOres((String)("oreMarble" + WGContent.GT_Cluster[iOre])).isEmpty()) {
                        WG_alchemic_recipes.registerAlchemyRecipe((String)"METALLURGICPERFECTION_CLUSTERS", (String)new StringBuilder().append((String)"_Marble_").append((String)WGContent.GT_Cluster[iOre]).toString(), (ItemStack)new ItemStack((Item)WGContent.ItemCluster, (int)2, (int)iOre), (Object)new StringBuilder().append((String)"oreMarble").append((String)WGContent.GT_Cluster[iOre]).toString(), (AspectList)alchemyAspects).hash += 3;
                    }
                    if (!OreDictionary.getOres((String)("oreBasalt" + WGContent.GT_Cluster[iOre])).isEmpty()) {
                        WG_alchemic_recipes.registerAlchemyRecipe((String)"METALLURGICPERFECTION_CLUSTERS", (String)new StringBuilder().append((String)"_Basalt_").append((String)WGContent.GT_Cluster[iOre]).toString(), (ItemStack)new ItemStack((Item)WGContent.ItemCluster, (int)2, (int)iOre), (Object)new StringBuilder().append((String)"oreBasalt").append((String)WGContent.GT_Cluster[iOre]).toString(), (AspectList)alchemyAspects).hash += 4;
                    }
                    if (!OreDictionary.getOres((String)("rawOre" + WGContent.GT_Cluster[iOre])).isEmpty()) {
                        WG_alchemic_recipes.registerAlchemyRecipe((String)"METALLURGICPERFECTION_CLUSTERS", (String)new StringBuilder().append((String)"_Raw_").append((String)WGContent.GT_Cluster[iOre]).toString(), (ItemStack)new ItemStack((Item)WGContent.ItemCluster, (int)2, (int)iOre), (Object)new StringBuilder().append((String)"rawOre").append((String)WGContent.GT_Cluster[iOre]).toString(), (AspectList)alchemyAspects).hash += 5;
                    }
                    if (!(OreDictionary.getOres((String)("ore" + WGContent.GT_Cluster[iOre])).isEmpty() && OreDictionary.getOres((String)("oreNetherrack" + WGContent.GT_Cluster[iOre])).isEmpty() && OreDictionary.getOres((String)("oreEndstone" + WGContent.GT_Cluster[iOre])).isEmpty() && OreDictionary.getOres((String)("oreBlackgranite" + WGContent.GT_Cluster[iOre])).isEmpty() && OreDictionary.getOres((String)("oreRedgranite" + WGContent.GT_Cluster[iOre])).isEmpty() && OreDictionary.getOres((String)("oreMarble" + WGContent.GT_Cluster[iOre])).isEmpty() && OreDictionary.getOres((String)("oreBasalt" + WGContent.GT_Cluster[iOre])).isEmpty() && OreDictionary.getOres((String)("rawOre" + WGContent.GT_Cluster[iOre])).isEmpty())) {
                        WG_alchemic_clusters.setupCluster(WGContent.GT_Cluster[iOre]);
                    }
                }
                if (!WGConfig.allowTransmutations) continue;
                boolean bl = bb = !OreDictionary.getOres((String)("nugget" + WGContent.GT_Cluster[iOre])).isEmpty() && !OreDictionary.getOres((String)("ingot" + WGContent.GT_Cluster[iOre])).isEmpty();
                if (!bb) continue;
                ItemStack ingot = (ItemStack)OreDictionary.getOres((String)("ingot" + WGContent.GT_Cluster[iOre])).get(0);
                if (ingot == null) {
                    WitchingGadgets.logger.error(WGContent.GT_Cluster[iOre] + " == null! This should not happen!");
                    continue;
                }
                try {
                    alchemyAspects = ((AspectList)ThaumcraftApi.objectTags.get(Arrays.asList(ingot.func_77973_b(), ingot.func_77960_j()))).add(Aspect.EXCHANGE, 1);
                }
                catch (NullPointerException e3) {
                    WitchingGadgets.logger.error("Could not get the objectTags for" + WGContent.GT_Cluster[iOre]);
                    alchemyAspects = new AspectList().add(Aspect.METAL, 2).add(Aspect.ORDER, 1).add((Aspect)TCAspects.NEBRISUM.mAspect, 2);
                }
                if (alchemyAspects == null || alchemyAspects.equals(new AspectList()) || alchemyAspects.size() < 3) {
                    alchemyAspects = new AspectList().add(Aspect.METAL, 2).add(Aspect.ORDER, 1).add((Aspect)TCAspects.NEBRISUM.mAspect, 2);
                }
                alchemyAspects.remove(Aspect.METAL);
                alchemyAspects.add(Aspect.METAL, 2);
                alchemyAspects.aspects.entrySet().removeIf(e -> e.getKey() == null || e.getValue() == null || (Integer)e.getValue() <= 0);
                int f = 0;
                ItemStack rawnuggets = ((ItemStack)OreDictionary.getOres((String)("nugget" + WGContent.GT_Cluster[iOre])).get(f)).func_77946_l();
                if (rawnuggets.func_82833_r().contains("Oreberry")) {
                    ++f;
                }
                rawnuggets = ((ItemStack)OreDictionary.getOres((String)("nugget" + WGContent.GT_Cluster[iOre])).get(f)).func_77946_l();
                ItemStack nuggets = Utilities.copyStackWithSize(rawnuggets, 3);
                WG_alchemic_recipes.registerAlchemyRecipe("METALLURGICPERFECTION_TRANSMUTATION", "_" + WGContent.GT_Cluster[iOre], nuggets, "nugget" + WGContent.GT_Cluster[iOre], alchemyAspects);
            }
        } else {
            for (int iOre = 0; iOre < ItemClusters.subNames.length; ++iOre) {
                boolean bb;
                AspectList alchemyAspects;
                if (WGConfig.allowClusters) {
                    alchemyAspects = new AspectList().add(Aspect.METAL, 1).add(Aspect.ORDER, 1);
                    if (!OreDictionary.getOres((String)("ore" + ItemClusters.subNames[iOre])).isEmpty() && !OreDictionary.getOres((String)("ingot" + ItemClusters.subNames[iOre])).isEmpty()) {
                        WG_alchemic_recipes.registerAlchemyRecipe("METALLURGICPERFECTION_CLUSTERS", "_" + ItemClusters.subNames[iOre], new ItemStack(WGContent.ItemCluster, 1, iOre), "ore" + ItemClusters.subNames[iOre], alchemyAspects);
                        WG_alchemic_clusters.setupCluster(ItemClusters.subNames[iOre]);
                    }
                }
                if (!WGConfig.allowTransmutations) continue;
                boolean bl = bb = !OreDictionary.getOres((String)("nugget" + ItemClusters.subNames[iOre])).isEmpty() && !OreDictionary.getOres((String)("ingot" + ItemClusters.subNames[iOre])).isEmpty();
                if (!bb) continue;
                ItemStack ingot = (ItemStack)OreDictionary.getOres((String)("ingot" + ItemClusters.subNames[iOre])).get(0);
                alchemyAspects = (AspectList)ThaumcraftApi.objectTags.get(Arrays.asList(ingot.func_77973_b(), ingot.func_77960_j()));
                if (alchemyAspects == null) {
                    alchemyAspects = new AspectList();
                }
                alchemyAspects.remove(Aspect.METAL);
                alchemyAspects.add(Aspect.METAL, 2);
                Iterator it = alchemyAspects.aspects.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry e4 = it.next();
                    if (e4.getKey() != null && e4.getValue() != null) continue;
                    it.remove();
                }
                ItemStack nuggets = Utilities.copyStackWithSize((ItemStack)OreDictionary.getOres((String)("nugget" + ItemClusters.subNames[iOre])).get(0), 3);
                WG_alchemic_recipes.registerAlchemyRecipe("METALLURGICPERFECTION_TRANSMUTATION", "_" + ItemClusters.subNames[iOre], nuggets, "nugget" + ItemClusters.subNames[iOre], alchemyAspects);
            }
        }
    }

    public static void setupCluster(String name) {
        String fluid = MetalFluidData.getOreFluidName(name);
        int fluidTemp = MetalFluidData.getOreFluidTemp(name);
        fluidTemp = fluidTemp > 0 ? fluidTemp : 550;
        String ore = "ore" + name;
        String cluster = "cluster" + name;
        String ingot = "ingot" + name;
        String nugget = "nugget" + name;
        ItemStack clusterStack = ItemClusters.getCluster(name);
        if (!OreDictionary.getOres((String)nugget).isEmpty()) {
            if (!OreDictionary.getOres((String)ore).isEmpty()) {
                ThaumcraftApi.addSmeltingBonus((String)ore, (ItemStack)((ItemStack)OreDictionary.getOres((String)nugget).get(0)));
            }
            if (!OreDictionary.getOres((String)cluster).isEmpty()) {
                ThaumcraftApi.addSmeltingBonus((String)cluster, (ItemStack)((ItemStack)OreDictionary.getOres((String)nugget).get(0)));
            }
        }
        if (!OreDictionary.getOres((String)cluster).isEmpty()) {
            if (!OreDictionary.getOres((String)ingot).isEmpty()) {
                ItemStack ingots = (ItemStack)OreDictionary.getOres((String)ingot).get(0);
                if (clusterStack != null) {
                    if (!OreDictionary.getOres((String)ore).isEmpty()) {
                        Utils.addSpecialMiningResult((ItemStack)((ItemStack)OreDictionary.getOres((String)ore).get(0)), (ItemStack)clusterStack, (float)1.0f);
                    }
                    if (WGContent.ClusterEBF.get(name) == null || !WGContent.ClusterEBF.get(name).booleanValue()) {
                        FurnaceRecipes.func_77602_a().func_151394_a(clusterStack, Utilities.copyStackWithSize(ingots, 2), 1.0f);
                    }
                }
            }
            if (WGModCompat.loaded_TCon && WGConfig.smelteryResultForClusters > 0 && FluidRegistry.getFluid((String)fluid) != null) {
                WGModCompat.addTConSmelteryRecipe(cluster, "block" + name, fluidTemp, fluid, WGConfig.smelteryResultForClusters);
            }
        }
    }
}

