/*
 * Decompiled with CFR 0.152.
 */
package shukaro.warptheory.handlers;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import java.util.function.Function;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import shukaro.warptheory.handlers.IWarpEvent;
import shukaro.warptheory.util.MiscHelper;

public abstract class IWorldTickWarpEvent
extends IWarpEvent {
    protected final Function<World, Integer> incrementFunction;

    protected IWorldTickWarpEvent(String name, int minWarp, Function<World, Integer> incrementFunction) {
        super(name, minWarp);
        this.incrementFunction = incrementFunction;
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    public abstract int triggerEvent(int var1, World var2, EntityPlayer var3);

    @Override
    public boolean doEvent(World world, EntityPlayer player) {
        this.sendChatMessage(player);
        MiscHelper.modEventInt(player, this.name, this.incrementFunction.apply(world));
        return true;
    }

    @SubscribeEvent
    public void onTick(TickEvent.WorldTickEvent e) {
        if (e.phase != TickEvent.Phase.END || e.side != Side.SERVER) {
            return;
        }
        for (EntityPlayer player : e.world.field_73010_i) {
            if (!MiscHelper.getWarpTag(player).func_74764_b(this.name)) continue;
            int eventAmount = MiscHelper.getWarpTag(player).func_74762_e(this.name);
            int decrement = this.triggerEvent(eventAmount, e.world, player);
            this.decreaseTag(player, this.name, decrement);
        }
    }
}

