/*
 * Decompiled with CFR 0.152.
 */
package twilightforest;

import com.google.common.io.Files;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import twilightforest.integration.TFBaublesIntegration;

public class TFPlayerHandler {
    protected static HashMap<String, InventoryPlayer> playerKeepsMap = new HashMap();

    public static void clearPlayerMaps(EntityPlayer player) {
        playerKeepsMap.remove(player.func_70005_c_());
        TFBaublesIntegration.clearPlayerMap(player);
    }

    public static InventoryPlayer getPlayerKeepInventory(EntityPlayer player) {
        if (!playerKeepsMap.containsKey(player.func_70005_c_())) {
            InventoryPlayer inventory = new InventoryPlayer(player);
            playerKeepsMap.put(player.func_70005_c_(), inventory);
        }
        return playerKeepsMap.get(player.func_70005_c_());
    }

    public static void setPlayerKeepInventory(EntityPlayer player, InventoryPlayer inventory) {
        playerKeepsMap.put(player.func_70005_c_(), inventory);
    }

    public static void loadPlayerKeepInventory(EntityPlayer player, File file1, File file2) {
        if (player != null && !player.field_70170_p.field_72995_K) {
            try {
                FileInputStream fileinputstream;
                NBTTagCompound data = null;
                boolean save = false;
                if (file1 != null && file1.exists()) {
                    try {
                        fileinputstream = new FileInputStream(file1);
                        data = CompressedStreamTools.func_74796_a((InputStream)fileinputstream);
                        fileinputstream.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (file1 == null || !file1.exists() || data == null || data.func_82582_d()) {
                    System.out.println("Data not found for " + player.func_70005_c_() + ". Trying to load backup data.");
                    if (file2 != null && file2.exists()) {
                        try {
                            fileinputstream = new FileInputStream(file2);
                            data = CompressedStreamTools.func_74796_a((InputStream)fileinputstream);
                            fileinputstream.close();
                            save = true;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                if (data != null) {
                    InventoryPlayer keepInventory = new InventoryPlayer(player);
                    keepInventory.func_70443_b(data.func_150295_c("KeepInventory", 10));
                    playerKeepsMap.put(player.func_70005_c_(), keepInventory);
                    TFBaublesIntegration.loadPlayerKeepBaubles(player, data);
                    if (save) {
                        TFPlayerHandler.savePlayerKeepInventory(player, file1, file2);
                    }
                }
            }
            catch (Exception exception1) {
                System.out.println("Error loading keep inventory");
                exception1.printStackTrace();
            }
        }
    }

    public static void savePlayerKeepInventory(EntityPlayer player, File file1, File file2) {
        block11: {
            if (player != null && !player.field_70170_p.field_72995_K) {
                try {
                    if (file1 != null && file1.exists()) {
                        try {
                            Files.copy((File)file1, (File)file2);
                        }
                        catch (Exception e) {
                            System.out.println("Could not backup old keep inventory file for player " + player.func_70005_c_());
                        }
                    }
                    try {
                        if (file1 != null) {
                            InventoryPlayer inventory = TFPlayerHandler.getPlayerKeepInventory(player);
                            NBTTagCompound data = new NBTTagCompound();
                            data.func_74782_a("KeepInventory", (NBTBase)inventory.func_70442_a(new NBTTagList()));
                            TFBaublesIntegration.savePlayerKeepBaubles(player, data);
                            FileOutputStream fileoutputstream = new FileOutputStream(file1);
                            CompressedStreamTools.func_74799_a((NBTTagCompound)data, (OutputStream)fileoutputstream);
                            fileoutputstream.close();
                        }
                    }
                    catch (Exception e) {
                        System.out.println("Could not save keep inventory file for player " + player.func_70005_c_());
                        e.printStackTrace();
                        if (!file1.exists()) break block11;
                        try {
                            file1.delete();
                        }
                        catch (Exception exception) {}
                    }
                }
                catch (Exception exception1) {
                    System.out.println("Error saving keep inventory");
                    exception1.printStackTrace();
                }
            }
        }
    }
}

