/*
 * Decompiled with CFR 0.152.
 */
package thaumic.tinkerer.common.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.research.ResearchPage;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.config.ConfigItems;
import thaumcraft.common.lib.research.PlayerKnowledge;
import thaumcraft.common.lib.research.ResearchManager;
import thaumic.tinkerer.common.ThaumicTinkerer;
import thaumic.tinkerer.common.core.handler.ConfigHandler;
import thaumic.tinkerer.common.core.helper.ItemNBTHelper;
import thaumic.tinkerer.common.registry.ItemBase;
import thaumic.tinkerer.common.registry.ThaumicTinkererCraftingBenchRecipe;
import thaumic.tinkerer.common.registry.ThaumicTinkererRecipe;
import thaumic.tinkerer.common.research.IRegisterableResearch;
import thaumic.tinkerer.common.research.ResearchHelper;
import thaumic.tinkerer.common.research.TTResearchItem;

public class ItemShareBook
extends ItemBase {
    private static final String TAG_PLAYER = "player";
    private static final String TAG_RESEARCH = "research";
    private static final String TAG_ASPECTS = "aspects";
    private static final String NON_ASSIGNED = "[none]";

    public ItemShareBook() {
        this.func_77625_d(1);
    }

    @Override
    public boolean shouldDisplayInTab() {
        return true;
    }

    @Override
    public IRegisterableResearch getResearchItem() {
        TTResearchItem research = (TTResearchItem)new TTResearchItem("SHARE_TOME", new AspectList(), 0, -1, 0, new ItemStack((Item)this)).setStub().setAutoUnlock().setRound();
        if (ConfigHandler.enableSurvivalShareTome) {
            research.setPages(new ResearchPage("0"), ResearchHelper.recipePage("SHARE_TOME"));
        } else {
            research.setPages(new ResearchPage("0"));
        }
        return research;
    }

    @Override
    public ThaumicTinkererRecipe getRecipeItem() {
        if (ConfigHandler.enableSurvivalShareTome) {
            return new ThaumicTinkererCraftingBenchRecipe("SHARE_TOME", new ItemStack((Item)this), " S ", "PTP", " P ", Character.valueOf('S'), new ItemStack(ConfigItems.itemInkwell), Character.valueOf('T'), new ItemStack(ConfigItems.itemThaumonomicon), Character.valueOf('P'), new ItemStack(Items.field_151121_aF));
        }
        return null;
    }

    public ItemStack func_77659_a(ItemStack bookStack, World world, EntityPlayer player) {
        String name = this.getPlayerName(bookStack);
        if (name.endsWith(NON_ASSIGNED)) {
            this.setPlayerName(bookStack, player.func_146103_bH().getName());
            this.savePlayerResearch(ItemNBTHelper.getNBT(bookStack), player.func_146103_bH().getName());
            if (!world.field_72995_K) {
                player.func_145747_a((IChatComponent)new ChatComponentTranslation("ttmisc.shareTome.write", new Object[0]));
            }
        } else {
            NBTTagCompound researchSource;
            if (ResearchManager.getResearchForPlayer((String)name) != null) {
                researchSource = new NBTTagCompound();
                this.savePlayerResearch(researchSource, name);
            } else {
                researchSource = ItemNBTHelper.getNBT(bookStack);
            }
            this.loadPlayerResearch(researchSource, player);
            if (!world.field_72995_K) {
                player.func_145747_a((IChatComponent)new ChatComponentTranslation("ttmisc.shareTome.sync", new Object[0]));
            }
        }
        return bookStack;
    }

    private void loadPlayerResearch(NBTTagCompound cmp, EntityPlayer player) {
        String playerName = player.func_146103_bH().getName();
        ResearchManager.getResearchForPlayer((String)playerName);
        if (cmp.func_74764_b(TAG_RESEARCH)) {
            NBTTagList list = cmp.func_150295_c(TAG_RESEARCH, 8);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                String research = list.func_150307_f(i);
                ThaumicTinkerer.tcProxy.getResearchManager().completeResearch(player, research);
            }
        }
        if (cmp.func_74764_b(TAG_ASPECTS)) {
            PlayerKnowledge pk = ThaumicTinkerer.tcProxy.getPlayerKnowledge();
            NBTTagList list = cmp.func_150295_c(TAG_ASPECTS, 8);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                String aspectTag = list.func_150307_f(i);
                Aspect aspect = Aspect.getAspect((String)aspectTag);
                if (aspect == null) continue;
                pk.addDiscoveredAspect(playerName, aspect);
            }
            ResearchManager.scheduleSave((EntityPlayer)player);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack par1ItemStack) {
        return EnumRarity.epic;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        String name = this.getPlayerName(par1ItemStack);
        par3List.add(name.equals(NON_ASSIGNED) ? StatCollector.func_74838_a((String)"ttmisc.shareTome.noAssign") : String.format(StatCollector.func_74838_a((String)"ttmisc.shareTome.playerName"), name));
    }

    public boolean func_77651_p() {
        return true;
    }

    private String getPlayerName(ItemStack stack) {
        return ItemNBTHelper.getString(stack, TAG_PLAYER, NON_ASSIGNED);
    }

    private void setPlayerName(ItemStack stack, String playerName) {
        ItemNBTHelper.setString(stack, TAG_PLAYER, playerName);
    }

    private void savePlayerResearch(NBTTagCompound target, String playername) {
        ArrayList researchesDone = ResearchManager.getResearchForPlayer((String)playername);
        NBTTagList researchList = new NBTTagList();
        for (String tag : researchesDone) {
            researchList.func_74742_a((NBTBase)new NBTTagString(tag));
        }
        target.func_74782_a(TAG_RESEARCH, (NBTBase)researchList);
        PlayerKnowledge pk = Thaumcraft.proxy.getPlayerKnowledge();
        NBTTagList aspectsToSave = new NBTTagList();
        AspectList aspectsDiscovered = pk.getAspectsDiscovered(playername);
        if (aspectsDiscovered == null) {
            return;
        }
        aspectsDiscovered.aspects.keySet().stream().map(Aspect::getTag).sorted().map(NBTTagString::new).forEach(arg_0 -> ((NBTTagList)aspectsToSave).func_74742_a(arg_0));
        target.func_74782_a(TAG_ASPECTS, (NBTBase)aspectsToSave);
    }

    @Override
    public String getItemName() {
        return "shareBook";
    }
}

