/*
 * Decompiled with CFR 0.152.
 */
package elan.tweaks.thaumcraft.research.frontend.integration.table.gui.component;

import elan.tweaks.common.gui.component.BackgroundUIComponent;
import elan.tweaks.common.gui.component.MouseOverUIComponent;
import elan.tweaks.common.gui.component.UIContext;
import elan.tweaks.common.gui.dto.Rectangle;
import elan.tweaks.common.gui.dto.VectorXY;
import elan.tweaks.thaumcraft.research.frontend.domain.ports.provided.ResearcherKnowledgePort;
import elan.tweaks.thaumcraft.research.frontend.integration.table.gui.layout.UsageHintLayout;
import elan.tweaks.thaumcraft.research.frontend.integration.table.gui.textures.UsageHintResearchExpertiseTexture;
import elan.tweaks.thaumcraft.research.frontend.integration.table.gui.textures.UsageHintTexture;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.util.StatCollector;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000eH\u0016J \u0010\u0012\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lelan/tweaks/thaumcraft/research/frontend/integration/table/gui/component/UsageHintUIComponent;", "Lelan/tweaks/common/gui/component/BackgroundUIComponent;", "Lelan/tweaks/common/gui/component/MouseOverUIComponent;", "uiBounds", "Lelan/tweaks/common/gui/dto/Rectangle;", "onMouseOverBounds", "researcher", "Lelan/tweaks/thaumcraft/research/frontend/domain/ports/provided/ResearcherKnowledgePort;", "(Lelan/tweaks/common/gui/dto/Rectangle;Lelan/tweaks/common/gui/dto/Rectangle;Lelan/tweaks/thaumcraft/research/frontend/domain/ports/provided/ResearcherKnowledgePort;)V", "drawHint", "", "uiMousePosition", "Lelan/tweaks/common/gui/dto/VectorXY;", "context", "Lelan/tweaks/common/gui/component/UIContext;", "onDrawBackground", "partialTicks", "", "onMouseOver", "ThaumcraftResearchTweaks"})
public final class UsageHintUIComponent
implements BackgroundUIComponent,
MouseOverUIComponent {
    @NotNull
    private final Rectangle uiBounds;
    @NotNull
    private final Rectangle onMouseOverBounds;
    @NotNull
    private final ResearcherKnowledgePort researcher;

    public UsageHintUIComponent(@NotNull Rectangle uiBounds, @NotNull Rectangle onMouseOverBounds, @NotNull ResearcherKnowledgePort researcher) {
        Intrinsics.checkNotNullParameter((Object)uiBounds, (String)"uiBounds");
        Intrinsics.checkNotNullParameter((Object)onMouseOverBounds, (String)"onMouseOverBounds");
        Intrinsics.checkNotNullParameter((Object)researcher, (String)"researcher");
        this.uiBounds = uiBounds;
        this.onMouseOverBounds = onMouseOverBounds;
        this.researcher = researcher;
    }

    @Override
    public void onDrawBackground(@NotNull VectorXY uiMousePosition, float partialTicks, @NotNull UIContext context) {
        Intrinsics.checkNotNullParameter((Object)uiMousePosition, (String)"uiMousePosition");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (this.researcher.hasDiscovered(ResearcherKnowledgePort.Knowledge.ResearchExpertise)) {
            UIContext.DefaultImpls.drawBlending$default(context, UsageHintResearchExpertiseTexture.INSTANCE, this.uiBounds.getOrigin(), null, 4, null);
        } else {
            UIContext.DefaultImpls.drawBlending$default(context, UsageHintTexture.INSTANCE, this.uiBounds.getOrigin(), null, 4, null);
        }
    }

    @Override
    public void onMouseOver(@NotNull VectorXY uiMousePosition, float partialTicks, @NotNull UIContext context) {
        Intrinsics.checkNotNullParameter((Object)uiMousePosition, (String)"uiMousePosition");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (this.onMouseOverBounds.contains(uiMousePosition)) {
            this.drawHint(uiMousePosition, context);
        }
    }

    private final void drawHint(VectorXY uiMousePosition, UIContext context) {
        String hintHeaderLine = StatCollector.func_74838_a((String)"researchtable.usagehint.header");
        String hintDescriptionLine = StatCollector.func_74838_a((String)"researchtable.usagehint.description");
        if (this.researcher.hasDiscovered(ResearcherKnowledgePort.Knowledge.ResearchExpertise)) {
            String hintResearchExpertise = StatCollector.func_74838_a((String)"researchtable.usagehint.research_expertise");
            VectorXY vectorXY = uiMousePosition.plus(UsageHintLayout.INSTANCE.getTextBoxOffset());
            String[] stringArray = new String[3];
            Intrinsics.checkNotNullExpressionValue((Object)hintHeaderLine, (String)"hintHeaderLine");
            stringArray[0] = hintHeaderLine;
            Intrinsics.checkNotNullExpressionValue((Object)hintDescriptionLine, (String)"hintDescriptionLine");
            stringArray[1] = hintDescriptionLine;
            Intrinsics.checkNotNullExpressionValue((Object)hintResearchExpertise, (String)"hintResearchExpertise");
            stringArray[2] = hintResearchExpertise;
            context.drawTooltipVerticallyCentered(vectorXY, stringArray);
        } else {
            VectorXY vectorXY = uiMousePosition.plus(UsageHintLayout.INSTANCE.getTextBoxOffset());
            String[] stringArray = new String[2];
            Intrinsics.checkNotNullExpressionValue((Object)hintHeaderLine, (String)"hintHeaderLine");
            stringArray[0] = hintHeaderLine;
            Intrinsics.checkNotNullExpressionValue((Object)hintDescriptionLine, (String)"hintDescriptionLine");
            stringArray[1] = hintDescriptionLine;
            context.drawTooltipVerticallyCentered(vectorXY, stringArray);
        }
    }
}

