/*
 * Decompiled with CFR 0.152.
 */
package elan.tweaks.thaumcraft.research.frontend.integration.table;

import elan.tweaks.common.gui.component.UIContext;
import elan.tweaks.common.gui.dto.Rgba;
import elan.tweaks.common.gui.dto.Vector3D;
import elan.tweaks.common.gui.dto.VectorXY;
import elan.tweaks.common.gui.fx.LineParticle;
import elan.tweaks.common.gui.fx.OrbParticle;
import elan.tweaks.common.gui.rendering.AspectRenderer;
import elan.tweaks.common.gui.rendering.TextureRenderer;
import elan.tweaks.common.gui.rendering.TooltipRenderer;
import elan.tweaks.common.gui.textures.TextureInstance;
import elan.tweaks.thaumcraft.research.frontend.integration.table.TableUIContext;
import java.util.Random;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import thaumcraft.api.aspects.Aspect;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0018\u0010\u001f\u001a\u00020\u00182\u0006\u0010 \u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\u001cH\u0016J\u0010\u0010\"\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0018\u0010\"\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020$H\u0016J \u0010%\u001a\u00020\u00182\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020$2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J8\u0010%\u001a\u00020\u00182\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020$2\u0006\u0010)\u001a\u00020$2\u0006\u0010*\u001a\u00020$2\u0006\u0010+\u001a\u00020,2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J \u0010-\u001a\u00020\u00182\u0006\u0010&\u001a\u00020'2\u0006\u0010+\u001a\u00020,2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J)\u0010.\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001c2\u0012\u0010/\u001a\n\u0012\u0006\b\u0001\u0012\u00020100\"\u000201H\u0016\u00a2\u0006\u0002\u00102J)\u00103\u001a\u00020\u00182\u0006\u00104\u001a\u00020\u001c2\u0012\u0010/\u001a\n\u0012\u0006\b\u0001\u0012\u00020100\"\u000201H\u0016\u00a2\u0006\u0002\u00102J)\u00105\u001a\u00020\u00182\u0006\u00104\u001a\u00020\u001c2\u0012\u0010/\u001a\n\u0012\u0006\b\u0001\u0012\u00020100\"\u000201H\u0016\u00a2\u0006\u0002\u00102J\u0018\u00106\u001a\u00020\u00182\u0006\u0010/\u001a\u0002012\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J(\u00107\u001a\u00020\u00182\u0006\u00108\u001a\u0002012\u0006\u00109\u001a\u00020,2\u0006\u0010:\u001a\u00020,2\u0006\u0010;\u001a\u00020<H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0007\u001a\u00020\b8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u001b\u0010\r\u001a\u00020\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\f\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0012\u001a\u00020\u00138BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\f\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006="}, d2={"Lelan/tweaks/thaumcraft/research/frontend/integration/table/TableUIContext;", "Lelan/tweaks/common/gui/component/UIContext;", "screenOrigin", "Lelan/tweaks/common/gui/dto/Vector3D;", "fontRenderer", "Lnet/minecraft/client/gui/FontRenderer;", "(Lelan/tweaks/common/gui/dto/Vector3D;Lnet/minecraft/client/gui/FontRenderer;)V", "random", "Ljava/util/Random;", "getRandom", "()Ljava/util/Random;", "random$delegate", "Lkotlin/Lazy;", "renderViewEntity", "Lnet/minecraft/entity/EntityLivingBase;", "getRenderViewEntity", "()Lnet/minecraft/entity/EntityLivingBase;", "renderViewEntity$delegate", "world", "Lnet/minecraft/world/World;", "getWorld", "()Lnet/minecraft/world/World;", "world$delegate", "drawBlending", "", "texture", "Lelan/tweaks/common/gui/textures/TextureInstance;", "uiPosition", "Lelan/tweaks/common/gui/dto/VectorXY;", "colorMask", "Lelan/tweaks/common/gui/dto/Rgba;", "drawLine", "from", "to", "drawOrb", "color", "", "drawTag", "aspect", "Lthaumcraft/api/aspects/Aspect;", "amount", "bonus", "blend", "alpha", "", "drawTagMonochrome", "drawTooltip", "text", "", "", "(Lelan/tweaks/common/gui/dto/VectorXY;[Ljava/lang/String;)V", "drawTooltipCentered", "uiCenterPosition", "drawTooltipVerticallyCentered", "drawWithShadow", "playSound", "soundName", "volume", "pitch", "distanceDelay", "", "ThaumcraftResearchTweaks"})
public final class TableUIContext
implements UIContext {
    @NotNull
    private final Vector3D screenOrigin;
    @NotNull
    private final FontRenderer fontRenderer;
    @NotNull
    private final Lazy renderViewEntity$delegate;
    @NotNull
    private final Lazy world$delegate;
    @NotNull
    private final Lazy random$delegate;

    public TableUIContext(@NotNull Vector3D screenOrigin, @NotNull FontRenderer fontRenderer) {
        Intrinsics.checkNotNullParameter((Object)screenOrigin, (String)"screenOrigin");
        Intrinsics.checkNotNullParameter((Object)fontRenderer, (String)"fontRenderer");
        this.screenOrigin = screenOrigin;
        this.fontRenderer = fontRenderer;
        this.renderViewEntity$delegate = LazyKt.lazy((Function0)renderViewEntity.2.INSTANCE);
        this.world$delegate = LazyKt.lazy((Function0)((Function0)new Function0<World>(this){
            final /* synthetic */ TableUIContext this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final World invoke() {
                return TableUIContext.access$getRenderViewEntity((TableUIContext)this.this$0).field_70170_p;
            }
        }));
        this.random$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Random>(this){
            final /* synthetic */ TableUIContext this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final Random invoke() {
                return TableUIContext.access$getWorld((TableUIContext)this.this$0).field_73012_v;
            }
        }));
    }

    private final EntityLivingBase getRenderViewEntity() {
        Lazy lazy = this.renderViewEntity$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-renderViewEntity>(...)");
        return (EntityLivingBase)object;
    }

    private final World getWorld() {
        Lazy lazy = this.world$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-world>(...)");
        return (World)object;
    }

    @Override
    @NotNull
    public Random getRandom() {
        Lazy lazy = this.random$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-random>(...)");
        return (Random)object;
    }

    @Override
    public void drawBlending(@NotNull TextureInstance texture, @NotNull VectorXY uiPosition, @NotNull Rgba colorMask) {
        Intrinsics.checkNotNullParameter((Object)texture, (String)"texture");
        Intrinsics.checkNotNullParameter((Object)uiPosition, (String)"uiPosition");
        Intrinsics.checkNotNullParameter((Object)colorMask, (String)"colorMask");
        TextureRenderer.INSTANCE.drawBlending(texture, this.screenOrigin.plus(uiPosition), colorMask);
    }

    @Override
    public void drawWithShadow(@NotNull String text, @NotNull VectorXY uiPosition) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)uiPosition, (String)"uiPosition");
        this.fontRenderer.func_78261_a(text, this.screenOrigin.getX() + uiPosition.getX(), this.screenOrigin.getY() + uiPosition.getY(), -1);
    }

    @Override
    public void drawTag(@NotNull Aspect aspect, int amount, @NotNull VectorXY uiPosition) {
        Intrinsics.checkNotNullParameter((Object)aspect, (String)"aspect");
        Intrinsics.checkNotNullParameter((Object)uiPosition, (String)"uiPosition");
        AspectRenderer.drawTag$default(AspectRenderer.INSTANCE, this.screenOrigin.plus(uiPosition), aspect, amount, 0, 0, 0.0f, 56, null);
    }

    @Override
    public void drawTag(@NotNull Aspect aspect, int amount, int bonus, int blend, float alpha, @NotNull VectorXY uiPosition) {
        Intrinsics.checkNotNullParameter((Object)aspect, (String)"aspect");
        Intrinsics.checkNotNullParameter((Object)uiPosition, (String)"uiPosition");
        AspectRenderer.INSTANCE.drawTag(this.screenOrigin.plus(uiPosition), aspect, amount, bonus, blend, alpha);
    }

    @Override
    public void drawTagMonochrome(@NotNull Aspect aspect, float alpha, @NotNull VectorXY uiPosition) {
        Intrinsics.checkNotNullParameter((Object)aspect, (String)"aspect");
        Intrinsics.checkNotNullParameter((Object)uiPosition, (String)"uiPosition");
        AspectRenderer.INSTANCE.drawTagMonochrome(this.screenOrigin.plus(uiPosition), aspect, alpha);
    }

    @Override
    public void drawTooltip(@NotNull VectorXY uiPosition, String ... text) {
        Intrinsics.checkNotNullParameter((Object)uiPosition, (String)"uiPosition");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        TooltipRenderer.INSTANCE.draw(text, this.screenOrigin.plus(uiPosition), TooltipRenderer.TextColors.INSTANCE.getLIGHT_BLUE(), this.fontRenderer);
    }

    @Override
    public void drawTooltipCentered(@NotNull VectorXY uiCenterPosition, String ... text) {
        Intrinsics.checkNotNullParameter((Object)uiCenterPosition, (String)"uiCenterPosition");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        TooltipRenderer.INSTANCE.drawCentered(text, this.screenOrigin.plus(uiCenterPosition), TooltipRenderer.TextColors.INSTANCE.getLIGHT_BLUE(), this.fontRenderer);
    }

    @Override
    public void drawTooltipVerticallyCentered(@NotNull VectorXY uiCenterPosition, String ... text) {
        Intrinsics.checkNotNullParameter((Object)uiCenterPosition, (String)"uiCenterPosition");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        TooltipRenderer.INSTANCE.drawVerticallyCentered(text, this.screenOrigin.plus(uiCenterPosition), TooltipRenderer.TextColors.INSTANCE.getLIGHT_BLUE(), this.fontRenderer);
    }

    @Override
    public void drawOrb(@NotNull VectorXY uiPosition, int color) {
        Intrinsics.checkNotNullParameter((Object)uiPosition, (String)"uiPosition");
        OrbParticle.INSTANCE.draw(this.screenOrigin.plus(uiPosition), color);
    }

    @Override
    public void drawOrb(@NotNull VectorXY uiPosition) {
        Intrinsics.checkNotNullParameter((Object)uiPosition, (String)"uiPosition");
        OrbParticle.INSTANCE.draw(this.screenOrigin.plus(uiPosition));
    }

    @Override
    public void drawLine(@NotNull VectorXY from, @NotNull VectorXY to) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        LineParticle.INSTANCE.draw(this.screenOrigin.plus(from), this.screenOrigin.plus(to));
    }

    @Override
    public void playSound(@NotNull String soundName, float volume, float pitch, boolean distanceDelay) {
        Intrinsics.checkNotNullParameter((Object)soundName, (String)"soundName");
        EntityLivingBase entity = this.getRenderViewEntity();
        this.getWorld().func_72980_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, soundName, volume, pitch, distanceDelay);
    }

    public static final /* synthetic */ EntityLivingBase access$getRenderViewEntity(TableUIContext $this) {
        return $this.getRenderViewEntity();
    }

    public static final /* synthetic */ World access$getWorld(TableUIContext $this) {
        return $this.getWorld();
    }
}

