/*
 * Decompiled with CFR 0.152.
 */
package net.glease.tc4tweak.asm;

import net.glease.tc4tweak.asm.TC4Transformer;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

class MappingThreadVisitor
extends ClassVisitor {
    private String className;

    public MappingThreadVisitor(int api, ClassVisitor cv) {
        super(api, cv);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.className = name;
        super.visit(version, access, this.className, signature, superName, interfaces);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if (name.equals("run") && desc.equals("()V")) {
            TC4Transformer.log.debug("Visiting method run()V");
            return new RunVisitor(this.api, mv);
        }
        return mv;
    }

    private class RunVisitor
    extends MethodVisitor {
        public RunVisitor(int api, MethodVisitor mv) {
            super(api, mv);
        }

        public void visitCode() {
            super.visitCode();
            TC4Transformer.log.trace("Injecting callhook at HEAD");
            this.mv.visitVarInsn(25, 0);
            this.mv.visitFieldInsn(180, MappingThreadVisitor.this.className, "idMappings", "Ljava/util/Map;");
            this.mv.visitMethodInsn(184, "net/glease/tc4tweak/asm/ASMCallhook", "onMappingStart", "(Ljava/util/Map;)V", false);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            super.visitMethodInsn(opcode, owner, name, desc, itf);
            if (opcode == 185 && "java/util/Iterator".equals(owner) && "next".equals(name)) {
                TC4Transformer.log.trace("Injecting callhook before Iterator#next()");
                this.mv.visitMethodInsn(184, "net/glease/tc4tweak/asm/ASMCallhook", "onMappingDidWork", "()V", false);
            }
        }

        public void visitInsn(int opcode) {
            if (opcode == 177) {
                TC4Transformer.log.trace("Injecting callhook before {}", new Object[]{opcode});
                this.mv.visitMethodInsn(184, "net/glease/tc4tweak/asm/ASMCallhook", "onMappingFinished", "()V", false);
            }
            super.visitInsn(opcode);
        }
    }
}

