/*
 * Decompiled with CFR 0.152.
 */
package net.glease.tc4tweak.asm;

import net.glease.tc4tweak.asm.ASMUtils;
import net.glease.tc4tweak.asm.LoadingPlugin;
import net.glease.tc4tweak.asm.ReadMarkerNoCastVisitor;
import net.glease.tc4tweak.asm.TC4Transformer;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

class EntityGolemBaseVisitor
extends ClassVisitor {
    public EntityGolemBaseVisitor(int api, ClassVisitor cv) {
        super(api, EntityGolemBaseVisitor.maybePatchMarker(api, cv));
    }

    private static ClassVisitor maybePatchMarker(int api, ClassVisitor cv) {
        if (ASMUtils.isHodgepodgeFixActive("fixes", "fixThaumcraftGolemMarkerLoading", true)) {
            TC4Transformer.log.warn("Disabling TC4Tweaks's golem marker patch to prevent conflict with hodgepodge.");
            return cv;
        }
        return new ReadMarkerNoCastVisitor(api, cv, LoadingPlugin.dev ? "readEntityFromNBT" : "func_70037_a", "(Lnet/minecraft/nbt/NBTTagCompound;)V");
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if (name.equals("updateCarried")) {
            TC4Transformer.log.debug("Visiting {}#{}", new Object[]{name, desc});
            return new UpdateCarriedVisitor(this.api, mv);
        }
        return mv;
    }

    private static class UpdateCarriedVisitor
    extends MethodVisitor {
        public UpdateCarriedVisitor(int api, MethodVisitor mv) {
            super(api, mv);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            if (name.equals("addObjectByDataType") || name.equals("func_82709_a")) {
                String newName = LoadingPlugin.dev ? "updateObject" : "func_75692_b";
                Label l = new Label();
                this.mv.visitLabel(l);
                this.mv.visitLineNumber(114514, l);
                TC4Transformer.log.trace("Replacing {}#{}(?1, ?2) with {}#{}(?1, null)", new Object[]{owner, name, owner, newName});
                this.mv.visitInsn(87);
                this.mv.visitInsn(1);
                this.mv.visitMethodInsn(opcode, owner, newName, "(ILjava/lang/Object;)V", false);
            } else if (name.equals("setObjectWatched") || name.equals("func_82708_h")) {
                TC4Transformer.log.trace("Dropping unnecessary {}#{}{}", new Object[]{owner, name, owner});
                this.mv.visitInsn(88);
            } else {
                super.visitMethodInsn(opcode, owner, name, desc, itf);
            }
        }
    }
}

