/*
 * Decompiled with CFR 0.152.
 */
package taintedmagic.common.network;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.MutablePair;
import taintedmagic.common.TaintedMagic;
import taintedmagic.common.items.tools.ItemKatana;
import taintedmagic.common.network.PacketHandler;

public class PacketKatanaAttack
implements IMessage,
IMessageHandler<PacketKatanaAttack, IMessage> {
    private int entityID;
    private int playerID;
    private int dimensionID;
    private float dmg;
    private boolean leech;
    private boolean sus;

    public PacketKatanaAttack() {
    }

    public PacketKatanaAttack(Entity entity) {
        this.entityID = entity.func_145782_y();
    }

    private static void log(EntityPlayerMP origin) {
        TaintedMagic.log.warn(PacketHandler.SECURITY_MARKER, "Player {} tried to kill stuff around it", new Object[]{origin.func_146103_bH()});
    }

    public IMessage onMessage(PacketKatanaAttack message, MessageContext ctx) {
        boolean leech;
        EntityPlayerMP realPlayer = ctx.getServerHandler().field_147369_b;
        ItemStack item = realPlayer.func_71045_bC();
        if (item == null || !(item.func_77973_b() instanceof ItemKatana)) {
            PacketKatanaAttack.log(realPlayer);
            return null;
        }
        MutablePair<Integer, Integer> ticksInUseHolder = ItemKatana.EventHandler.ticksInUse.remove(realPlayer);
        if (ticksInUseHolder == null) {
            PacketKatanaAttack.log(realPlayer);
            return null;
        }
        int ticksInUse = (Integer)ticksInUseHolder.right;
        boolean fullyCharged = ticksInUse >= 30;
        float damage = ItemKatana.getAttackDamage(item) * (1.0f + Math.min((float)ticksInUse / 40.0f, 1.0f));
        boolean bl = leech = ItemKatana.getInscription(item) == 2 && fullyCharged;
        if (this.sus && (realPlayer.func_145782_y() != this.playerID || realPlayer.field_71093_bK != this.dimensionID || (double)Math.abs(damage - message.dmg) > 1.0E-4 || leech != message.leech)) {
            PacketKatanaAttack.log(realPlayer);
            return null;
        }
        World world = realPlayer.func_130014_f_();
        Entity entity = world.func_73045_a(message.entityID);
        if (entity instanceof EntityLivingBase) {
            double reach = realPlayer.field_71134_c.getBlockReachDistance();
            if (!(realPlayer.func_70068_e(entity) < reach * reach)) {
                PacketKatanaAttack.log(realPlayer);
                return null;
            }
            entity.func_70097_a(DamageSource.func_76354_b((Entity)realPlayer, (Entity)entity), damage);
            if (leech) {
                realPlayer.func_70691_i(damage * 0.25f);
                world.func_72956_a((Entity)realPlayer, "thaumcraft:wand", 0.5f, 0.5f + (float)Math.random() * 0.5f);
            }
        }
        return null;
    }

    public void fromBytes(ByteBuf buf) {
        this.entityID = buf.readInt();
        if (buf.readableBytes() == 0) {
            return;
        }
        this.sus = true;
        this.playerID = buf.readInt();
        this.dimensionID = buf.readInt();
        this.dmg = buf.readFloat();
        this.leech = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.entityID);
    }
}

