/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.library.util;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraftforge.common.config.Configuration;

public class AoEExclusionList {
    private static final Map<String, Set<String>> toolExclusionLists = new HashMap<String, Set<String>>();
    private static Configuration config;

    public static void init(File configFile) {
        config = new Configuration(configFile);
        AoEExclusionList.loadConfig();
    }

    private static void loadConfig() {
        String[] tools;
        config.load();
        for (String tool : tools = new String[]{"tool.hammer", "tool.excavator", "tool.lumberaxe"}) {
            String[] exclusionArray = config.getStringList(tool + "Exclusions", "AOE_Exclusions", new String[]{"examplemod:exampleblock", "examplemod:exampleblock:1"}, "Block IDs (with optional metadata) that should not be broken by " + tool + "'s AOE effect");
            HashSet<String> exclusionSet = new HashSet<String>(Arrays.asList(exclusionArray));
            toolExclusionLists.put(tool, exclusionSet);
        }
        if (config.hasChanged()) {
            config.save();
        }
    }

    public static boolean isBlockExcluded(String tool, Block block, int metadata) {
        Set<String> exclusions = toolExclusionLists.get(tool);
        if (exclusions == null) {
            exclusions = toolExclusionLists.get("tool." + tool);
        }
        if (exclusions == null || exclusions.isEmpty()) {
            return false;
        }
        String blockId = Block.field_149771_c.func_148750_c((Object)block);
        return exclusions.contains(blockId) || exclusions.contains(blockId + ":" + metadata);
    }
}

