/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.packs.misc.core;

import com.jaquadro.minecraft.storagedrawers.api.pack.BlockConfiguration;
import com.jaquadro.minecraft.storagedrawers.api.pack.BlockType;
import com.jaquadro.minecraft.storagedrawers.api.pack.ExtendedDataResolver;
import com.jaquadro.minecraft.storagedrawers.packs.misc.core.ModBlocks;
import com.jaquadro.minecraft.storagedrawers.packs.misc.core.ModCreativeTabs;
import com.jaquadro.minecraft.storagedrawers.packs.misc.core.RefinedRelocation;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;

public class DataResolver
extends ExtendedDataResolver {
    public static String[][] textureBank = new String[][]{{"ebxl_redwood", "ebxl_fir", "ebxl_acacia", "ebxl_cypress", "ebxl_japanesemaple", "ebxl_rainboweucalyptus", "ebxl_autumn", "ebxl_baldcypress", "ebxl_sakura"}, {"hl_yellow", "hl_white", "hl_red", "hl_grey", "tc_greatwood", "tc_silverwood", "witchery_rowan", "witchery_alder", "witchery_hawthorn", "immeng_treated", "botania_livingwood", "botania_dreamwood"}};
    private int bank;

    public DataResolver(String modID, int bankNumber) {
        super(modID, textureBank[bankNumber]);
        this.bank = bankNumber;
    }

    @Override
    public CreativeTabs getCreativeTabs(BlockType type) {
        return ModCreativeTabs.getTabStorageDrawers();
    }

    @Override
    public Block getBlock(BlockConfiguration blockConfig) {
        switch (blockConfig.getBlockType()) {
            case Drawers: {
                if (blockConfig.getDrawerCount() == 1 && ModBlocks.fullDrawers1 != null) {
                    return ModBlocks.fullDrawers1[this.bank];
                }
                if (blockConfig.getDrawerCount() == 2 && !blockConfig.isHalfDepth() && ModBlocks.fullDrawers2 != null) {
                    return ModBlocks.fullDrawers2[this.bank];
                }
                if (blockConfig.getDrawerCount() == 4 && !blockConfig.isHalfDepth() && ModBlocks.fullDrawers4 != null) {
                    return ModBlocks.fullDrawers4[this.bank];
                }
                if (blockConfig.getDrawerCount() == 2 && blockConfig.isHalfDepth() && ModBlocks.halfDrawers2 != null) {
                    return ModBlocks.halfDrawers2[this.bank];
                }
                if (blockConfig.getDrawerCount() != 4 || !blockConfig.isHalfDepth() || ModBlocks.halfDrawers4 == null) break;
                return ModBlocks.halfDrawers4[this.bank];
            }
            case DrawersSorting: {
                if (blockConfig.getDrawerCount() == 1 && RefinedRelocation.fullDrawers1 != null) {
                    return RefinedRelocation.fullDrawers1[this.bank];
                }
                if (blockConfig.getDrawerCount() == 2 && !blockConfig.isHalfDepth() && RefinedRelocation.fullDrawers2 != null) {
                    return RefinedRelocation.fullDrawers2[this.bank];
                }
                if (blockConfig.getDrawerCount() == 4 && !blockConfig.isHalfDepth() && RefinedRelocation.fullDrawers4 != null) {
                    return RefinedRelocation.fullDrawers4[this.bank];
                }
                if (blockConfig.getDrawerCount() == 2 && blockConfig.isHalfDepth() && RefinedRelocation.halfDrawers2 != null) {
                    return RefinedRelocation.halfDrawers2[this.bank];
                }
                if (blockConfig.getDrawerCount() != 4 || !blockConfig.isHalfDepth() || RefinedRelocation.halfDrawers4 == null) break;
                return RefinedRelocation.halfDrawers4[this.bank];
            }
            case Trim: {
                if (ModBlocks.trim == null) break;
                return ModBlocks.trim[this.bank];
            }
            case TrimSorting: {
                if (RefinedRelocation.trim == null) break;
                return RefinedRelocation.trim[this.bank];
            }
        }
        return null;
    }

    @Override
    public void init() {
        switch (this.bank) {
            case 0: {
                int i = 0;
                int p = 0;
                int m = 0;
                while (i < 8) {
                    this.setPlankSlab(i, GameRegistry.findBlock((String)"ExtrabiomesXL", (String)"planks"), p, GameRegistry.findBlock((String)"ExtrabiomesXL", (String)"woodslab"), m);
                    ++i;
                    ++p;
                    ++m;
                }
                i = 8;
                p = 8;
                m = 0;
                while (i < 9) {
                    this.setPlankSlab(i, GameRegistry.findBlock((String)"ExtrabiomesXL", (String)"planks"), p, GameRegistry.findBlock((String)"ExtrabiomesXL", (String)"woodslab2"), m);
                    ++i;
                    ++p;
                    ++m;
                }
                break;
            }
            case 1: {
                int i = 0;
                int p = 0;
                int m = 0;
                while (i < 4) {
                    this.setPlankSlab(i, GameRegistry.findBlock((String)"Highlands", (String)"hl_woodPlanks"), p, GameRegistry.findBlock((String)"Highlands", (String)"hl_woodSlab"), m);
                    ++i;
                    ++p;
                    ++m;
                }
                i = 4;
                p = 6;
                m = 0;
                while (i < 6) {
                    this.setPlankSlab(i, GameRegistry.findBlock((String)"Thaumcraft", (String)"blockWoodenDevice"), p, GameRegistry.findBlock((String)"Thaumcraft", (String)"blockCosmeticSlabWood"), m);
                    ++i;
                    ++p;
                    ++m;
                }
                i = 6;
                p = 0;
                m = 0;
                while (i < 9) {
                    this.setPlankSlab(i, GameRegistry.findBlock((String)"witchery", (String)"witchwood"), p, GameRegistry.findBlock((String)"witchery", (String)"witchwoodslab"), m);
                    ++i;
                    ++p;
                    ++m;
                }
                i = 9;
                p = 0;
                m = 2;
                while (i < 10) {
                    this.setPlankSlab(i, GameRegistry.findBlock((String)"ImmersiveEngineering", (String)"treatedWood"), p, GameRegistry.findBlock((String)"ImmersiveEngineering", (String)"woodenDecoration"), m);
                    ++i;
                    ++p;
                    ++m;
                }
                i = 10;
                p = 1;
                m = 0;
                while (i < 11) {
                    this.setPlankSlab(i, GameRegistry.findBlock((String)"Botania", (String)"livingwood"), p, GameRegistry.findBlock((String)"Botania", (String)"livingwood1Slab"), m);
                    ++i;
                    ++p;
                    ++m;
                }
                i = 11;
                p = 1;
                m = 0;
                while (i < 12) {
                    this.setPlankSlab(i, GameRegistry.findBlock((String)"Botania", (String)"dreamwood"), p, GameRegistry.findBlock((String)"Botania", (String)"dreamwood1Slab"), m);
                    ++i;
                    ++p;
                    ++m;
                }
                break;
            }
        }
    }
}

