/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.components;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import vswe.stevesfactory.Localization;
import vswe.stevesfactory.components.ComponentMenu;
import vswe.stevesfactory.components.ComponentMenuTarget;
import vswe.stevesfactory.components.FlowComponent;
import vswe.stevesfactory.components.TextBoxNumber;
import vswe.stevesfactory.components.TextBoxNumberList;
import vswe.stevesfactory.interfaces.ContainerManager;
import vswe.stevesfactory.interfaces.GuiManager;
import vswe.stevesfactory.network.DataBitHelper;
import vswe.stevesfactory.network.DataReader;
import vswe.stevesfactory.network.DataWriter;

public class ComponentMenuTargetInventory
extends ComponentMenuTarget {
    private TextBoxNumberList textBoxes;
    private TextBoxNumber startTextBox;
    private TextBoxNumber endTextBox;
    private int[] startRange = new int[directions.length];
    private int[] endRange = new int[directions.length];
    private static final String NBT_START = "StartRange";
    private static final String NBT_END = "EndRange";

    public ComponentMenuTargetInventory(FlowComponent parent) {
        super(parent);
        this.textBoxes = new TextBoxNumberList();
        this.startTextBox = new TextBoxNumber(39, 49, 2, false){

            @Override
            public void onNumberChanged() {
                if (ComponentMenuTargetInventory.this.selectedDirectionId != -1 && ComponentMenuTargetInventory.this.getParent().getManager().func_145831_w().field_72995_K) {
                    ComponentMenuTargetInventory.this.writeData(ComponentMenuTarget.DataTypeHeader.START_OR_TANK_DATA, this.getNumber());
                }
            }
        };
        this.textBoxes.addTextBox(this.startTextBox);
        this.endTextBox = new TextBoxNumber(60, 49, 2, false){

            @Override
            public void onNumberChanged() {
                if (ComponentMenuTargetInventory.this.selectedDirectionId != -1 && ComponentMenuTargetInventory.this.getParent().getManager().func_145831_w().field_72995_K) {
                    ComponentMenuTargetInventory.this.writeData(ComponentMenuTarget.DataTypeHeader.END, this.getNumber());
                }
            }
        };
        this.textBoxes.addTextBox(this.endTextBox);
    }

    @Override
    protected ComponentMenuTarget.Button getSecondButton() {
        return new ComponentMenuTarget.Button(27){

            @Override
            protected String getLabel() {
                return ComponentMenuTargetInventory.this.useAdvancedSetting(ComponentMenuTargetInventory.this.selectedDirectionId) ? Localization.ALL_SLOTS.toString() : Localization.ID_RANGE.toString();
            }

            @Override
            protected String getMouseOverText() {
                return ComponentMenuTargetInventory.this.useAdvancedSetting(ComponentMenuTargetInventory.this.selectedDirectionId) ? Localization.ALL_SLOTS_LONG.toString() : Localization.ID_RANGE_LONG.toString();
            }

            @Override
            protected void onClicked() {
                ComponentMenuTargetInventory.this.writeData(ComponentMenuTarget.DataTypeHeader.USE_ADVANCED_SETTING, ComponentMenuTargetInventory.this.useAdvancedSetting(ComponentMenuTargetInventory.this.selectedDirectionId) ? 0 : 1);
            }
        };
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void drawAdvancedComponent(GuiManager gui, int mX, int mY) {
        this.textBoxes.draw(gui, mX, mY);
    }

    @Override
    protected void refreshAdvancedComponent() {
        if (this.selectedDirectionId != -1) {
            this.startTextBox.setNumber(this.startRange[this.selectedDirectionId]);
            this.endTextBox.setNumber(this.endRange[this.selectedDirectionId]);
        }
    }

    @Override
    protected void writeAdvancedSetting(DataWriter dw, int i) {
        dw.writeData(this.startRange[i], DataBitHelper.MENU_TARGET_RANGE);
        dw.writeData(this.endRange[i], DataBitHelper.MENU_TARGET_RANGE);
    }

    @Override
    protected void readAdvancedSetting(DataReader dr, int i) {
        this.startRange[i] = dr.readData(DataBitHelper.MENU_TARGET_RANGE);
        this.endRange[i] = dr.readData(DataBitHelper.MENU_TARGET_RANGE);
    }

    @Override
    protected void copyAdvancedSetting(ComponentMenu menu, int i) {
        ComponentMenuTargetInventory menuTarget = (ComponentMenuTargetInventory)menu;
        this.startRange[i] = menuTarget.startRange[i];
        this.endRange[i] = menuTarget.endRange[i];
    }

    @Override
    protected void onAdvancedClick(int mX, int mY, int button) {
        this.textBoxes.onClick(mX, mY, button);
    }

    @Override
    protected void loadAdvancedComponent(NBTTagCompound directionTag, int i) {
        this.startRange[i] = directionTag.func_74771_c(NBT_START);
        this.endRange[i] = directionTag.func_74771_c(NBT_END);
    }

    @Override
    protected void saveAdvancedComponent(NBTTagCompound directionTag, int i) {
        directionTag.func_74774_a(NBT_START, (byte)this.getStart(i));
        directionTag.func_74774_a(NBT_END, (byte)this.getEnd(i));
    }

    @Override
    protected void resetAdvancedSetting(int i) {
        this.endRange[i] = 0;
        this.startRange[i] = 0;
    }

    @Override
    protected void refreshAdvancedComponentData(ContainerManager container, ComponentMenu newData, int i) {
        ComponentMenuTargetInventory newDataTarget = (ComponentMenuTargetInventory)newData;
        if (this.startRange[i] != newDataTarget.startRange[i]) {
            this.startRange[i] = newDataTarget.startRange[i];
            this.writeUpdatedData(container, i, ComponentMenuTarget.DataTypeHeader.START_OR_TANK_DATA, this.startRange[i]);
        }
        if (this.endRange[i] != newDataTarget.endRange[i]) {
            this.endRange[i] = newDataTarget.endRange[i];
            this.writeUpdatedData(container, i, ComponentMenuTarget.DataTypeHeader.END, this.endRange[i]);
        }
    }

    @Override
    protected void readAdvancedNetworkComponent(DataReader dr, ComponentMenuTarget.DataTypeHeader header, int i) {
        int data = dr.readData(header.getBits());
        switch (header) {
            case START_OR_TANK_DATA: {
                this.startRange[i] = data;
                this.refreshAdvancedComponent();
                break;
            }
            case END: {
                this.endRange[i] = data;
                this.refreshAdvancedComponent();
            }
        }
    }

    public int getStart(int i) {
        return this.startRange[i];
    }

    public int getEnd(int i) {
        return this.endRange[i];
    }

    @Override
    public void addErrors(List<String> errors) {
        for (int i = 0; i < directions.length; ++i) {
            if (!this.isActive(i) || this.getStart(i) <= this.getEnd(i)) continue;
            errors.add(Localization.getForgeDirectionLocalization(i).toString() + " " + Localization.INVALID_RANGE.toString());
        }
        super.addErrors(errors);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean onKeyStroke(GuiManager gui, char c, int k) {
        if (this.selectedDirectionId != -1 && this.useAdvancedSetting(this.selectedDirectionId)) {
            return this.textBoxes.onKeyStroke(gui, c, k);
        }
        return false;
    }
}

