/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.Modules.Workers.Tools;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Vec3;
import vswe.stevescarts.Carts.MinecartModular;
import vswe.stevescarts.Helpers.BlockCoord;
import vswe.stevescarts.Helpers.Localization;
import vswe.stevescarts.Interfaces.GuiMinecart;
import vswe.stevescarts.Modules.Addons.Plants.ModulePlantSize;
import vswe.stevescarts.Modules.ISuppliesModule;
import vswe.stevescarts.Modules.ITreeModule;
import vswe.stevescarts.Modules.ModuleBase;
import vswe.stevescarts.Modules.Workers.Tools.ModuleTool;
import vswe.stevescarts.Slots.SlotBase;
import vswe.stevescarts.Slots.SlotFuel;
import vswe.stevescarts.Slots.SlotSapling;

public abstract class ModuleWoodcutter
extends ModuleTool
implements ISuppliesModule,
ITreeModule {
    private ArrayList<ITreeModule> treeModules;
    private ModulePlantSize plantSize;
    private boolean isPlanting;
    private float cutterAngle = 0.7853982f;

    public ModuleWoodcutter(MinecartModular cart) {
        super(cart);
    }

    @Override
    public byte getWorkPriority() {
        return 80;
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public void drawForeground(GuiMinecart gui) {
        this.drawString(gui, Localization.MODULES.TOOLS.CUTTER.translate(new String[0]), 8, 6, 0x404040);
    }

    @Override
    protected int getInventoryWidth() {
        return super.getInventoryWidth() + 3;
    }

    @Override
    protected SlotBase getSlot(int slotId, int x, int y) {
        if (x == 0) {
            return super.getSlot(slotId, x, y);
        }
        return new SlotSapling(this.getCart(), this, slotId, 8 + --x * 18, 28 + y * 18);
    }

    @Override
    public boolean useDurability() {
        return true;
    }

    @Override
    public void init() {
        super.init();
        this.treeModules = new ArrayList();
        for (ModuleBase module : this.getCart().getModules()) {
            if (module instanceof ITreeModule) {
                this.treeModules.add((ITreeModule)((Object)module));
                continue;
            }
            if (!(module instanceof ModulePlantSize)) continue;
            this.plantSize = (ModulePlantSize)module;
        }
    }

    public abstract int getPercentageDropChance();

    public ArrayList<ItemStack> getTierDrop(ArrayList<ItemStack> baseItems) {
        ArrayList<ItemStack> nerfedItems = new ArrayList<ItemStack>();
        for (ItemStack item : baseItems) {
            if (item == null) continue;
            this.dropItemByMultiplierChance(nerfedItems, item, this.getPercentageDropChance());
        }
        return nerfedItems;
    }

    private void dropItemByMultiplierChance(ArrayList<ItemStack> items, ItemStack item, int percentage) {
        int drop = 0;
        while (percentage > 0) {
            if (this.getCart().field_70146_Z.nextInt(100) < percentage) {
                items.add(item.func_77946_l());
                ++drop;
            }
            percentage -= 100;
        }
    }

    @Override
    public boolean work() {
        int i;
        Vec3 next = this.getNextblock();
        int x = (int)next.field_72450_a;
        int y = (int)next.field_72448_b;
        int z = (int)next.field_72449_c;
        int size = this.getPlantSize();
        this.destroyLeaveBlockOnTrack(x, y, z);
        this.destroyLeaveBlockOnTrack(x, y + 1, z);
        for (i = -size; i <= size; ++i) {
            int plantZ;
            int plantY;
            int plantX;
            if (i == 0) continue;
            int i2 = i;
            if (i2 < 0) {
                i2 = -size - i2 - 1;
            }
            if (!this.plant(size, plantX = x + (this.getCart().z() != z ? i2 : 0), plantY = y - 1, plantZ = z + (this.getCart().x() != x ? i2 : 0), x, z)) continue;
            this.setCutting(false);
            return true;
        }
        if (!this.isPlanting) {
            for (i = -1; i <= 1; ++i) {
                for (int j = -1; j <= 1; ++j) {
                    int farmX = x + i;
                    int farmY = y - 1;
                    int farmZ = z + j;
                    if (!this.farm(farmX, farmY, farmZ)) continue;
                    this.setCutting(true);
                    return true;
                }
            }
        }
        this.isPlanting = false;
        this.setCutting(false);
        return false;
    }

    private boolean plant(int size, int x, int y, int z, int cx, int cz) {
        if (size == 1 ? (x + z) % 2 == 0 : x == cx && x / size % 2 == 0 || z == cz && z / size % 2 == 0) {
            return false;
        }
        int saplingSlotId = -1;
        ItemStack sapling = null;
        for (int i = 0; i < this.getInventorySize(); ++i) {
            SlotBase slot = this.getSlots().get(i);
            if (!slot.containsValidItem()) continue;
            saplingSlotId = i;
            sapling = this.getStack(i);
            break;
        }
        if (sapling != null) {
            if (this.doPreWork()) {
                if (sapling.func_77973_b().func_77648_a(sapling, (EntityPlayer)this.getFakePlayer(), this.getCart().field_70170_p, x, y, z, 1, 0.0f, 0.0f, 0.0f)) {
                    if (sapling.field_77994_a == 0) {
                        this.setStack(saplingSlotId, null);
                    }
                    this.startWorking(25);
                    this.isPlanting = true;
                    return true;
                }
            } else {
                this.stopWorking();
                this.isPlanting = false;
            }
        }
        return false;
    }

    private boolean farm(int x, int y, int z) {
        if (!this.isBroken()) {
            Block b = this.getCart().field_70170_p.func_147439_a(x, y + 1, z);
            int m = this.getCart().field_70170_p.func_72805_g(x, y + 1, z);
            if (b != null && this.isWoodHandler(b, x, y + 1, z)) {
                ArrayList<BlockCoord> checked = new ArrayList<BlockCoord>();
                if (this.removeAt(x, y + 1, z, checked)) {
                    return true;
                }
                this.stopWorking();
            }
        }
        return false;
    }

    private boolean removeAt(int i, int j, int k, ArrayList<BlockCoord> checked) {
        int basetime;
        ArrayList stuff;
        BlockCoord here = new BlockCoord(i, j, k);
        checked.add(here);
        Block b = this.getCart().field_70170_p.func_147439_a(i, j, k);
        int m = this.getCart().field_70170_p.func_72805_g(i, j, k);
        if (b == null) {
            return false;
        }
        if (checked.size() < 125 && here.getHorizontalDistToCartSquared(this.getCart()) < 175.0) {
            for (int type = 0; type < 2; ++type) {
                boolean hitWood = false;
                if (this.isLeavesHandler(b, i, j, k)) {
                    type = 1;
                } else if (type == 1) {
                    hitWood = true;
                }
                for (int x = -1; x <= 1; ++x) {
                    for (int y = 1; y >= 0; --y) {
                        for (int z = -1; z <= 1; ++z) {
                            Block currentBlock = this.getCart().field_70170_p.func_147439_a(i + x, j + y, k + z);
                            if (currentBlock == null || !(hitWood ? this.isWoodHandler(currentBlock, i + x, j + y, k + z) : this.isLeavesHandler(currentBlock, i + x, j + y, k + z)) || checked.contains(new BlockCoord(i + x, j + y, k + z))) continue;
                            return this.removeAt(i + x, j + y, k + z, checked);
                        }
                    }
                }
            }
        }
        if (this.shouldSilkTouch(b, i, j, k, m)) {
            stuff = new ArrayList();
            ItemStack stack = this.getSilkTouchedItem(b, m);
            if (stack != null) {
                stuff.add(stack);
            }
        } else {
            int fortune = this.enchanter != null ? this.enchanter.getFortuneLevel() : 0;
            stuff = b.getDrops(this.getCart().field_70170_p, i, j, k, m, fortune);
            int applerand = 200;
            if (fortune > 0 && (applerand -= 10 << fortune) < 40) {
                applerand = 40;
            }
            if ((m & 3) == 0 && b == Blocks.field_150362_t && this.getCart().field_70146_Z.nextInt(applerand) == 0) {
                stuff.add(new ItemStack(Items.field_151034_e, 1, 0));
            }
        }
        ArrayList<ItemStack> nerfedstuff = this.getTierDrop(stuff);
        boolean first = true;
        for (ItemStack iStack : nerfedstuff) {
            this.getCart().addItemToChest(iStack, Slot.class, SlotFuel.class);
            if (iStack.field_77994_a != 0) {
                if (first) {
                    return false;
                }
                EntityItem entityitem = new EntityItem(this.getCart().field_70170_p, this.getCart().field_70165_t, this.getCart().field_70163_u, this.getCart().field_70161_v, iStack);
                entityitem.field_70159_w = (float)(i - this.getCart().x()) / 10.0f;
                entityitem.field_70181_x = 0.15f;
                entityitem.field_70179_y = (float)(k - this.getCart().z()) / 10.0f;
                this.getCart().field_70170_p.func_72838_d((Entity)entityitem);
            }
            first = false;
        }
        this.getCart().field_70170_p.func_147468_f(i, j, k);
        if (this.isLeavesHandler(b, i, j, k)) {
            basetime = 2;
            this.damageTool(1);
        } else {
            basetime = 25;
            this.damageTool(5);
        }
        int efficiency = this.enchanter != null ? this.enchanter.getEfficiencyLevel() : 0;
        this.startWorking((int)((double)basetime / Math.pow(1.3f, efficiency)));
        return true;
    }

    @Override
    public void initDw() {
        this.addDw(0, 0);
    }

    @Override
    public int numberOfDataWatchers() {
        return 1;
    }

    private void setCutting(boolean val) {
        this.updateDw(0, (byte)(val ? 1 : 0));
    }

    protected boolean isCutting() {
        if (this.isPlaceholder()) {
            return this.getSimInfo().getIsCutting();
        }
        return this.getDw(0) != 0;
    }

    public float getCutterAngle() {
        return this.cutterAngle;
    }

    @Override
    public void update() {
        super.update();
        boolean cuttingflag = this.isCutting();
        if (cuttingflag || this.cutterAngle != 0.7853982f) {
            boolean flag = false;
            if (!cuttingflag && this.cutterAngle < 0.7853982f) {
                flag = true;
            }
            this.cutterAngle = (float)((double)(this.cutterAngle + 0.9f) % (Math.PI * 2));
            if (!cuttingflag && this.cutterAngle > 0.7853982f && flag) {
                this.cutterAngle = 0.7853982f;
            }
        }
    }

    @Override
    public boolean haveSupplies() {
        for (int i = 0; i < this.getInventorySize(); ++i) {
            if (!this.getSlots().get(i).containsValidItem()) continue;
            return true;
        }
        return false;
    }

    public boolean isLeavesHandler(Block b, int x, int y, int z) {
        for (ITreeModule module : this.treeModules) {
            if (!module.isLeaves(b, x, y, z)) continue;
            return true;
        }
        return false;
    }

    public boolean isWoodHandler(Block b, int x, int y, int z) {
        for (ITreeModule module : this.treeModules) {
            if (!module.isWood(b, x, y, z)) continue;
            return true;
        }
        return false;
    }

    public boolean isSaplingHandler(ItemStack sapling) {
        for (ITreeModule module : this.treeModules) {
            if (!module.isSapling(sapling)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isLeaves(Block b, int x, int y, int z) {
        return b == Blocks.field_150362_t;
    }

    @Override
    public boolean isWood(Block b, int x, int y, int z) {
        return b == Blocks.field_150364_r || b == Blocks.field_150363_s;
    }

    @Override
    public boolean isSapling(ItemStack sapling) {
        return sapling != null && Block.func_149634_a((Item)sapling.func_77973_b()) == Blocks.field_150345_g;
    }

    private int getPlantSize() {
        if (this.plantSize != null) {
            return this.plantSize.getSize();
        }
        return 1;
    }

    private void destroyLeaveBlockOnTrack(int x, int y, int z) {
        Block b = this.getCart().field_70170_p.func_147439_a(x, y, z);
        if (b != null && this.isLeavesHandler(b, x, y, z)) {
            this.getCart().field_70170_p.func_147468_f(x, y, z);
        }
    }
}

