/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.Modules.Workers;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import vswe.stevescarts.Carts.MinecartModular;
import vswe.stevescarts.Helpers.BlockCoord;
import vswe.stevescarts.Modules.Workers.ModuleWorker;
import vswe.stevescarts.Modules.Workers.Tools.ModuleDrill;

public class ModuleLiquidDrainer
extends ModuleWorker {
    public ModuleLiquidDrainer(MinecartModular cart) {
        super(cart);
    }

    @Override
    public byte getWorkPriority() {
        return 0;
    }

    @Override
    public boolean work() {
        return false;
    }

    public void handleLiquid(ModuleDrill drill, int x, int y, int z) {
        ArrayList<BlockCoord> checked = new ArrayList<BlockCoord>();
        BlockCoord here = new BlockCoord(x, y, z);
        int result = this.drainAt(drill, checked, here, 0);
        if (result > 0 && this.doPreWork()) {
            drill.kill();
            this.startWorking((int)(2.5f * (float)result));
        } else {
            this.stopWorking();
        }
    }

    @Override
    public boolean preventAutoShutdown() {
        return true;
    }

    private int drainAt(ModuleDrill drill, ArrayList<BlockCoord> checked, BlockCoord here, int buckets) {
        int drained = 0;
        Block b = this.getCart().field_70170_p.func_147439_a(here.getX(), here.getY(), here.getZ());
        if (!this.isLiquid(b)) {
            return 0;
        }
        int meta = this.getCart().field_70170_p.func_72805_g(here.getX(), here.getY(), here.getZ());
        FluidStack liquid = this.getFluidStack(b, here.getX(), here.getY(), here.getZ(), !this.doPreWork());
        if (liquid != null) {
            int amount;
            if (this.doPreWork()) {
                liquid.amount += buckets * 1000;
            }
            if ((amount = this.getCart().fill(liquid, false)) == liquid.amount) {
                boolean isDrainable;
                boolean bl = isDrainable = meta == 0;
                if (!this.doPreWork()) {
                    if (isDrainable) {
                        this.getCart().fill(liquid, true);
                    }
                    this.getCart().field_70170_p.func_147468_f(here.getX(), here.getY(), here.getZ());
                }
                drained += isDrainable ? 40 : 3;
                buckets += isDrainable ? 1 : 0;
            }
        }
        checked.add(here);
        if (checked.size() < 100 && here.getHorizontalDistToCartSquared(this.getCart()) < 200.0) {
            for (int y = 1; y >= 0; --y) {
                for (int x = -1; x <= 1; ++x) {
                    for (int z = -1; z <= 1; ++z) {
                        BlockCoord next;
                        if (Math.abs(x) + Math.abs(y) + Math.abs(z) != 1 || checked.contains(next = new BlockCoord(here.getX() + x, here.getY() + y, here.getZ() + z))) continue;
                        drained += this.drainAt(drill, checked, next, buckets);
                    }
                }
            }
        }
        return drained;
    }

    private boolean isLiquid(Block b) {
        boolean isWater = b == Blocks.field_150355_j || b == Blocks.field_150358_i || b == Blocks.field_150432_aD;
        boolean isLava = b == Blocks.field_150353_l || b == Blocks.field_150356_k;
        boolean isOther = b != null && b instanceof IFluidBlock;
        return isWater || isLava || isOther;
    }

    private FluidStack getFluidStack(Block b, int x, int y, int z, boolean doDrain) {
        if (b == Blocks.field_150355_j || b == Blocks.field_150358_i) {
            return new FluidStack(FluidRegistry.WATER, 1000);
        }
        if (b == Blocks.field_150353_l || b == Blocks.field_150356_k) {
            return new FluidStack(FluidRegistry.LAVA, 1000);
        }
        if (b instanceof IFluidBlock) {
            IFluidBlock liquid = (IFluidBlock)b;
            return liquid.drain(this.getCart().field_70170_p, x, y, z, doDrain);
        }
        return null;
    }
}

