/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.Modules.Addons;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import vswe.stevescarts.Carts.MinecartModular;
import vswe.stevescarts.Helpers.ResourceHelper;
import vswe.stevescarts.Interfaces.GuiMinecart;
import vswe.stevescarts.Modules.Addons.ModuleAddon;
import vswe.stevescarts.Modules.IActivatorModule;

public class ModuleChunkLoader
extends ModuleAddon
implements IActivatorModule {
    private boolean rdyToInit;
    private int[] buttonRect = new int[]{20, 20, 24, 12};

    public ModuleChunkLoader(MinecartModular cart) {
        super(cart);
    }

    @Override
    public boolean hasSlots() {
        return false;
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public int guiWidth() {
        return 80;
    }

    @Override
    public int guiHeight() {
        return 35;
    }

    @Override
    public void drawForeground(GuiMinecart gui) {
        this.drawString(gui, "Chunk Loader", 8, 6, 0x404040);
    }

    @Override
    public void update() {
        super.update();
        if (!this.rdyToInit) {
            this.rdyToInit = true;
        }
        if (this.isLoadingChunk() && !this.getCart().hasFuelForModule() && !this.getCart().field_70170_p.field_72995_K) {
            this.setChunkLoading(false);
        }
    }

    public void setChunkLoading(boolean val) {
        if (!this.isPlaceholder()) {
            this.updateDw(0, (byte)(val ? 1 : 0));
            if (!this.getCart().field_70170_p.field_72995_K && this.rdyToInit) {
                if (val) {
                    this.getCart().initChunkLoading();
                } else {
                    this.getCart().dropChunkLoading();
                }
            }
        }
    }

    private boolean isLoadingChunk() {
        if (this.isPlaceholder()) {
            return false;
        }
        return this.getDw(0) != 0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawBackground(GuiMinecart gui, int x, int y) {
        ResourceHelper.bindResource("/gui/chunk.png");
        int imageID = this.isLoadingChunk() ? 1 : 0;
        int borderID = 0;
        if (this.inRect(x, y, this.buttonRect)) {
            borderID = 1;
        }
        this.drawImage(gui, this.buttonRect, 0, this.buttonRect[3] * borderID);
        int srcY = this.buttonRect[3] * 2 + imageID * (this.buttonRect[3] - 2);
        this.drawImage(gui, this.buttonRect[0] + 1, this.buttonRect[1] + 1, 0, srcY, this.buttonRect[2] - 2, this.buttonRect[3] - 2);
    }

    @Override
    public void drawMouseOver(GuiMinecart gui, int x, int y) {
        this.drawStringOnMouseOver(gui, this.getStateName(), x, y, this.buttonRect);
    }

    private String getStateName() {
        if (!this.isLoadingChunk()) {
            return "Activate chunk loading";
        }
        return "Deactivate chunk loading";
    }

    @Override
    public void mouseClicked(GuiMinecart gui, int x, int y, int button) {
        if (button == 0 && this.inRect(x, y, this.buttonRect)) {
            this.sendPacket(0);
        }
    }

    @Override
    protected void receivePacket(int id, byte[] data, EntityPlayer player) {
        if (id == 0) {
            this.setChunkLoading(!this.isLoadingChunk());
        }
    }

    @Override
    public int numberOfPackets() {
        return 1;
    }

    @Override
    public int numberOfDataWatchers() {
        return 1;
    }

    @Override
    public void initDw() {
        this.addDw(0, 0);
    }

    @Override
    public int getConsumption(boolean isMoving) {
        return this.isLoadingChunk() ? 5 : super.getConsumption(isMoving);
    }

    @Override
    protected void Save(NBTTagCompound tagCompound, int id) {
        tagCompound.func_74757_a(this.generateNBTName("ChunkLoading", id), this.isLoadingChunk());
    }

    @Override
    protected void Load(NBTTagCompound tagCompound, int id) {
        this.setChunkLoading(tagCompound.func_74767_n(this.generateNBTName("ChunkLoading", id)));
    }

    @Override
    public void doActivate(int id) {
        this.setChunkLoading(true);
    }

    @Override
    public void doDeActivate(int id) {
        this.setChunkLoading(false);
    }

    @Override
    public boolean isActive(int id) {
        return this.isLoadingChunk();
    }
}

