/*
 * Decompiled with CFR 0.152.
 */
package toast.specialMobs.entity.witch;

import com.kuba6000.mobsinfo.api.IMobInfoProvider;
import com.kuba6000.mobsinfo.api.MobDrop;
import cpw.mods.fml.common.Optional;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIArrowAttack;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import toast.specialMobs.EffectHelper;
import toast.specialMobs.MobHelper;
import toast.specialMobs._SpecialMobs;
import toast.specialMobs.entity.ISpecialMob;
import toast.specialMobs.entity.SpecialMobData;

@Optional.Interface(iface="com.kuba6000.mobsinfo.api.IMobInfoProvider", modid="mobsinfo")
public class Entity_SpecialWitch
extends EntityWitch
implements ISpecialMob,
IMobInfoProvider {
    private static final UUID drinkingSpeedPenaltyUUID = UUID.fromString("5CD17E52-A79A-43D3-A529-90FDE04B181E");
    private static final AttributeModifier drinkingSpeedPenaltyModifier = new AttributeModifier(drinkingSpeedPenaltyUUID, "Drinking speed penalty", -0.25, 0).func_111168_a(false);
    public static final ResourceLocation[] TEXTURES = new ResourceLocation[]{new ResourceLocation("textures/entity/witch.png")};
    public boolean fakeNoItem;
    public boolean drinkingPotion;
    public int potionDrinkDelay;
    public int potionThrowDelay;
    private boolean hasMeleeAI;
    public ItemStack sheathedItem;
    private SpecialMobData specialData;

    public Entity_SpecialWitch(World world) {
        super(world);
        this.getSpecialData().immuneToPotions.add(Potion.field_76436_u.field_76415_H);
        this.getSpecialData().immuneToPotions.add(Potion.field_76437_t.field_76415_H);
        MobHelper.clearRangedAttackAI((EntityLiving)this);
        this.initTypeAI();
    }

    protected void func_70088_a() {
        this.specialData = new SpecialMobData((EntityLiving)this, TEXTURES);
        super.func_70088_a();
    }

    protected void initTypeAI() {
        this.setRangedAI(60, 60, 10.0f);
    }

    protected void loadRangedAI() {
        if (!this.hasMeleeAI) {
            MobHelper.clearRangedAttackAI((EntityLiving)this);
            SpecialMobData data = this.getSpecialData();
            this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIArrowAttack((IRangedAttackMob)this, (double)data.arrowMoveSpeed, (int)data.arrowRefireMin, (int)data.arrowRefireMax, data.arrowRange));
        }
    }

    protected void setRangedAI(int minDelay, int maxDelay, float range) {
        this.hasMeleeAI = false;
        SpecialMobData data = this.getSpecialData();
        data.arrowMoveSpeed = 1.0f;
        data.arrowRefireMin = (short)minDelay;
        data.arrowRefireMax = (short)maxDelay;
        data.arrowRange = range;
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIArrowAttack((IRangedAttackMob)this, (double)data.arrowMoveSpeed, (int)data.arrowRefireMin, (int)data.arrowRefireMax, data.arrowRange));
    }

    protected void setMeleeAI() {
        this.hasMeleeAI = true;
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityPlayer.class, 1.0, false));
    }

    @Override
    public SpecialMobData getSpecialData() {
        return this.specialData;
    }

    @Override
    public void adjustEntityAttributes() {
        float prevMax = this.func_110138_aP();
        this.adjustTypeAttributes();
        this.func_70606_j(this.func_110138_aP() + this.func_110143_aJ() - prevMax);
    }

    protected void adjustTypeAttributes() {
    }

    public void tryDrinkPotion() {
        if (this.potionThrowDelay <= 0) {
            if (this.func_70027_ad() && !this.func_70644_a(Potion.field_76426_n)) {
                this.drinkPotion(8195);
            } else if (this.field_70146_Z.nextFloat() < 0.15f && this.func_70055_a(Material.field_151586_h) && !this.func_70644_a(Potion.field_76427_o)) {
                this.drinkPotion(8205);
            } else if (this.field_70146_Z.nextFloat() < 0.05f && this.func_110143_aJ() < this.func_110138_aP()) {
                this.drinkPotion(8197);
            } else if (this.field_70146_Z.nextFloat() < 0.2f && this.func_70638_az() != null && !this.func_70644_a(Potion.field_76424_c) && this.func_70638_az().func_70068_e((Entity)this) > 121.0) {
                this.drinkPotion(16386);
            } else {
                this.tryDrinkPotionByType();
            }
        }
    }

    protected void tryDrinkPotionByType() {
    }

    public void drinkPotion(int damage) {
        this.drinkPotion(new ItemStack((Item)Items.field_151068_bn, 1, damage));
    }

    public void drinkPotion(int damage, Potion potionType, int duration, int amplifier) {
        ItemStack potion = new ItemStack((Item)Items.field_151068_bn, 1, damage);
        EffectHelper.addPotionEffect(potion, potionType, duration, amplifier);
        this.drinkPotion(potion);
    }

    public void drinkPotion(ItemStack potion) {
        if (potion == null) {
            this.potionDrinkDelay = 0;
            if (this.drinkingPotion) {
                this.drinkingPotion = false;
                this.func_70062_b(0, this.sheathedItem);
                this.sheathedItem = null;
                this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111124_b(drinkingSpeedPenaltyModifier);
            }
        } else if (ItemPotion.func_77831_g((int)potion.func_77960_j())) {
            this.potionThrowDelay = 32;
            EntityPotion thrownPotion = new EntityPotion(this.field_70170_p, (EntityLivingBase)this, potion);
            thrownPotion.field_70125_A += 20.0f;
            thrownPotion.field_70179_y = 0.0;
            thrownPotion.field_70159_w = 0.0;
            thrownPotion.field_70181_x = -0.2;
            this.field_70170_p.func_72838_d((Entity)thrownPotion);
        } else {
            this.drinkingPotion = true;
            this.potionDrinkDelay = potion.func_77988_m();
            this.sheathedItem = this.func_70694_bm();
            this.func_70062_b(0, potion);
            IAttributeInstance attribute = this.func_110148_a(SharedMonsterAttributes.field_111263_d);
            attribute.func_111124_b(drinkingSpeedPenaltyModifier);
            attribute.func_111121_a(drinkingSpeedPenaltyModifier);
        }
    }

    public void func_70636_d() {
        this.fakeNoItem = true;
        super.func_70636_d();
        this.getSpecialData().onUpdate();
        if (!this.field_70170_p.field_72995_K && this.func_70089_S()) {
            --this.potionThrowDelay;
            if (this.drinkingPotion) {
                if (this.potionDrinkDelay < 25 && this.potionDrinkDelay % 4 == 0) {
                    this.func_85030_a("random.drink", 0.2f, this.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f);
                }
                if (this.potionDrinkDelay-- <= 0) {
                    List list;
                    ItemStack potion = this.func_70694_bm();
                    this.drinkPotion(null);
                    if (potion != null && potion.func_77973_b() instanceof ItemPotion && (list = ((ItemPotion)potion.func_77973_b()).func_77832_l(potion)) != null) {
                        for (PotionEffect effect : list) {
                            this.func_70690_d(new PotionEffect(effect));
                        }
                    }
                }
            } else {
                this.tryDrinkPotion();
            }
        }
    }

    public void func_82197_f(boolean value) {
    }

    public boolean func_82198_m() {
        return true;
    }

    public ItemStack func_70694_bm() {
        if (!this.field_70170_p.field_72995_K && this.fakeNoItem) {
            return null;
        }
        return super.func_70694_bm();
    }

    public void func_70062_b(int slot, ItemStack equipment) {
        if (!this.field_70170_p.field_72995_K && this.fakeNoItem) {
            this.fakeNoItem = false;
        } else {
            super.func_70062_b(slot, equipment);
        }
    }

    public IEntityLivingData func_110161_a(IEntityLivingData data) {
        return this.getSpecialData().onSpawnWithEgg(data, (EntityLiving)new EntityWitch(this.field_70170_p));
    }

    public boolean func_70652_k(Entity target) {
        this.func_71038_i();
        if (super.func_70652_k(target)) {
            this.onTypeAttack(target);
            return true;
        }
        return false;
    }

    protected void onTypeAttack(Entity target) {
    }

    public void func_82196_d(EntityLivingBase target, float range) {
        if (!this.drinkingPotion) {
            EntityPotion thrownPotion = new EntityPotion(this.field_70170_p, (EntityLivingBase)this, 0);
            double dX = target.field_70165_t + target.field_70159_w - this.field_70165_t;
            double dY = target.field_70163_u + (double)target.func_70047_e() - 1.1 - this.field_70163_u;
            double dZ = target.field_70161_v + target.field_70179_y - this.field_70161_v;
            float distance = MathHelper.func_76133_a((double)(dX * dX + dZ * dZ));
            thrownPotion = this.adjustSplashPotion(thrownPotion, target, range, distance);
            thrownPotion.field_70125_A += 20.0f;
            thrownPotion.func_70186_c(dX, dY + (double)(distance * 0.2f), dZ, 0.75f, 8.0f);
            this.field_70170_p.func_72838_d((Entity)thrownPotion);
        }
    }

    protected EntityPotion adjustSplashPotion(EntityPotion thrownPotion, EntityLivingBase target, float range, float distance) {
        if (this.adjustSplashPotionByType(thrownPotion, target, range, distance)) {
            return thrownPotion;
        }
        if (distance >= 8.0f && !target.func_70644_a(Potion.field_76421_d)) {
            thrownPotion.func_82340_a(16394);
            return thrownPotion;
        }
        if (target.func_110143_aJ() >= 8.0f && !target.func_70644_a(Potion.field_76436_u)) {
            thrownPotion.func_82340_a(16388);
            return thrownPotion;
        }
        if (distance <= 3.0f && !target.func_70644_a(Potion.field_76437_t) && this.field_70146_Z.nextFloat() < 0.25f) {
            thrownPotion.func_82340_a(16392);
            return thrownPotion;
        }
        return thrownPotion;
    }

    protected boolean adjustSplashPotionByType(EntityPotion thrownPotion, EntityLivingBase target, float range, float distance) {
        if (target.func_70668_bt() == EnumCreatureAttribute.UNDEAD) {
            thrownPotion.func_82340_a(16389);
        } else {
            thrownPotion.func_82340_a(16396);
        }
        return false;
    }

    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        NBTTagCompound saveTag = SpecialMobData.getSaveLocation(tag);
        this.getSpecialData().isImmuneToFire = this.field_70178_ae;
        this.getSpecialData().writeToNBT(saveTag);
        tag.func_74757_a("DrinkingPotion", this.drinkingPotion);
        NBTTagCompound sheathedTag = new NBTTagCompound();
        if (this.sheathedItem != null) {
            this.sheathedItem.func_77955_b(sheathedTag);
        }
        tag.func_74782_a("SheathedItem", (NBTBase)sheathedTag);
    }

    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        NBTTagCompound saveTag = SpecialMobData.getSaveLocation(tag);
        this.getSpecialData().readFromNBT(tag);
        this.getSpecialData().readFromNBT(saveTag);
        this.field_70178_ae = this.getSpecialData().isImmuneToFire;
        this.loadRangedAI();
        this.drinkingPotion = tag.func_74767_n("DrinkingPotion");
        this.sheathedItem = ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("SheathedItem"));
    }

    protected void func_70628_a(boolean hit, int looting) {
        if (this.drinkingPotion) {
            ItemStack potion = this.func_70694_bm();
            this.drinkPotion(null);
            if (potion != null && this.field_70146_Z.nextFloat() < 0.15f) {
                this.func_70099_a(potion, 0.0f);
            }
        }
        super.func_70628_a(hit, looting);
    }

    @Optional.Method(modid="mobsinfo")
    public void provideDropsInformation(@Nonnull ArrayList<MobDrop> drops) {
        IMobInfoProvider.provideSuperVanillaDrops(drops, EntityWitch.class);
    }

    protected String func_70639_aQ() {
        return _SpecialMobs.NAMESPACE + super.func_70639_aQ();
    }

    protected String func_70621_aR() {
        return _SpecialMobs.NAMESPACE + super.func_70621_aR();
    }

    protected String func_70673_aS() {
        return _SpecialMobs.NAMESPACE + super.func_70673_aS();
    }

    public int func_70658_aO() {
        return Math.min(20, super.func_70658_aO() + this.getSpecialData().armor);
    }

    public void func_70015_d(int time) {
        if (!this.getSpecialData().isImmuneToBurning) {
            super.func_70015_d(time);
        }
    }

    public boolean func_110164_bC() {
        return !this.func_110167_bD() && this.getSpecialData().allowLeashing;
    }

    public void func_70110_aj() {
        if (!this.getSpecialData().isImmuneToWebs) {
            super.func_70110_aj();
        }
    }

    protected void func_70069_a(float distance) {
        if (!this.getSpecialData().isImmuneToFalling) {
            super.func_70069_a(distance);
        }
    }

    public boolean func_145773_az() {
        return this.getSpecialData().ignorePressurePlates;
    }

    public boolean func_70648_aU() {
        return this.getSpecialData().canBreatheInWater;
    }

    public boolean func_96092_aw() {
        return !this.getSpecialData().ignoreWaterPush;
    }

    public boolean func_70687_e(PotionEffect effect) {
        return this.getSpecialData().isPotionApplicable(effect);
    }
}

