/*
 * Decompiled with CFR 0.152.
 */
package lain.mods.skinport.init.forge;

import com.mojang.authlib.GameProfile;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import lain.mods.skinport.impl.forge.SkinCustomization;
import lain.mods.skinport.impl.forge.SkinPortGuiCustomizeSkin;
import lain.mods.skinport.impl.forge.SkinPortModelHumanoidHead;
import lain.mods.skinport.impl.forge.SkinPortRenderPlayer;
import lain.mods.skinport.impl.forge.SpecialModel;
import lain.mods.skinport.impl.forge.SpecialRenderer;
import lain.mods.skinport.impl.forge.compat.SkinPortRenderPlayer_MPM;
import lain.mods.skinport.impl.forge.compat.SkinPortRenderPlayer_RPA;
import lain.mods.skinport.init.forge.CommonProxy;
import lain.mods.skins.api.SkinProviderAPI;
import lain.mods.skins.api.interfaces.ISkin;
import lain.mods.skins.impl.PlayerProfile;
import lain.mods.skins.impl.forge.CustomSkinTexture;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiOptions;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelSkeletonHead;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.tileentity.TileEntitySkullRenderer;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntitySkull;
import net.minecraft.util.ResourceLocation;

@SideOnly(value=Side.CLIENT)
public class ClientProxy
extends CommonProxy {
    private static final Map<String, Render> renderers = new HashMap<String, Render>();
    private static final Map<ByteBuffer, CustomSkinTexture> textures = new WeakHashMap<ByteBuffer, CustomSkinTexture>();
    private static final SkinPortModelHumanoidHead modelHumanoidHead = new SkinPortModelHumanoidHead();

    public static ResourceLocation bindTexture(GameProfile profile, ResourceLocation result) {
        ISkin skin;
        if (profile != null && (skin = SkinProviderAPI.SKIN.getSkin(PlayerProfile.wrapGameProfile(profile))) != null && skin.isDataReady()) {
            return ClientProxy.getOrCreateTexture(skin.getData(), skin).getLocation();
        }
        return null;
    }

    public static ResourceLocation generateRandomLocation() {
        return new ResourceLocation("skinport", String.format("textures/generated/%s", UUID.randomUUID().toString()));
    }

    public static ModelSkeletonHead getHumanoidHead(ResourceLocation location, ModelSkeletonHead result) {
        ITextureObject texture = FMLClientHandler.instance().getClient().func_110434_K().func_110581_b(location);
        if (texture instanceof CustomSkinTexture) {
            return modelHumanoidHead;
        }
        return null;
    }

    public static ResourceLocation getLocationCape(AbstractClientPlayer player, ResourceLocation result) {
        ISkin skin = SkinProviderAPI.CAPE.getSkin(PlayerProfile.wrapGameProfile(player.func_146103_bH()));
        if (skin != null && skin.isDataReady()) {
            return ClientProxy.getOrCreateTexture(skin.getData(), skin).getLocation();
        }
        return null;
    }

    public static ResourceLocation getLocationSkin(AbstractClientPlayer player, ResourceLocation result) {
        ISkin skin = SkinProviderAPI.SKIN.getSkin(PlayerProfile.wrapGameProfile(player.func_146103_bH()));
        if (skin != null && skin.isDataReady()) {
            return ClientProxy.getOrCreateTexture(skin.getData(), skin).getLocation();
        }
        return null;
    }

    public static CustomSkinTexture getOrCreateTexture(ByteBuffer data, ISkin skin) {
        if (!textures.containsKey(data)) {
            CustomSkinTexture texture = new CustomSkinTexture(ClientProxy.generateRandomLocation(), data);
            FMLClientHandler.instance().getClient().func_110434_K().func_110579_a(texture.getLocation(), (ITextureObject)texture);
            textures.put(data, texture);
            if (skin != null) {
                skin.setRemovalListener(s -> {
                    if (data == s.getData()) {
                        FMLClientHandler.instance().getClient().func_152344_a(() -> {
                            FMLClientHandler.instance().getClient().func_110434_K().func_147645_c(texture.getLocation());
                            textures.remove(data);
                        });
                    }
                });
            }
        }
        return textures.get(data);
    }

    public static Render getPlayerRenderer(RenderManager manager, AbstractClientPlayer player, Render result) {
        if (renderers.isEmpty()) {
            ClientProxy.setupRenderers(manager);
        }
        if ((result = renderers.getOrDefault(ClientProxy.getSkinType(player), result)) instanceof SpecialRenderer) {
            ((SpecialRenderer)result).onGetRenderer(manager, player);
        }
        return result;
    }

    public static String getSkinType(AbstractClientPlayer player) {
        ISkin skin;
        ResourceLocation location = ClientProxy.getLocationSkin(player, null);
        if (location != null && (skin = SkinProviderAPI.SKIN.getSkin(PlayerProfile.wrapGameProfile(player.func_146103_bH()))) != null && skin.isDataReady()) {
            return skin.getSkinType();
        }
        return "default";
    }

    public static boolean hasCape(AbstractClientPlayer player, boolean result) {
        return player.func_110303_q() != null;
    }

    public static boolean hasSkin(AbstractClientPlayer player, boolean result) {
        return player.func_110306_p() != null;
    }

    public static int initHeight(ModelBiped model, int textureHeight) {
        if (model instanceof SpecialModel) {
            return ((SpecialModel)model).initHeight();
        }
        return textureHeight;
    }

    public static int initWidth(ModelBiped model, int textureWidth) {
        if (model instanceof SpecialModel) {
            return ((SpecialModel)model).initWidth();
        }
        return textureWidth;
    }

    @SideOnly(value=Side.CLIENT)
    public static void onButtonAction(GuiOptions gui, GuiButton button) {
        if (!button.field_146124_l || button.field_146127_k != 110) {
            return;
        }
        gui.field_146297_k.field_71474_y.func_74303_b();
        gui.field_146297_k.func_147108_a((GuiScreen)new SkinPortGuiCustomizeSkin((GuiScreen)gui));
    }

    public static void setupButton(GuiOptions gui, List<GuiButton> buttonList) {
        buttonList.add(new GuiButton(110, gui.field_146294_l / 2 - 155, gui.field_146295_m / 6 + 48 - 6, 150, 20, I18n.func_135052_a((String)"options.skinCustomisation", (Object[])new Object[0])));
    }

    public static void setupRenderers(RenderManager manager) {
        if (Loader.isModLoaded((String)"moreplayermodels")) {
            renderers.put("default", (Render)new SkinPortRenderPlayer_MPM(manager, false));
            renderers.put("slim", (Render)new SkinPortRenderPlayer_MPM(manager, true));
        } else if (Loader.isModLoaded((String)"RenderPlayerAPI")) {
            renderers.put("default", (Render)new SkinPortRenderPlayer_RPA(manager, false));
            renderers.put("slim", (Render)new SkinPortRenderPlayer_RPA(manager, true));
        } else {
            renderers.put("default", (Render)new SkinPortRenderPlayer(manager, false));
            renderers.put("slim", (Render)new SkinPortRenderPlayer(manager, true));
        }
    }

    @SubscribeEvent
    public void handleClientTicks(TickEvent.ClientTickEvent event) {
        WorldClient world;
        if (event.phase == TickEvent.Phase.START && (world = Minecraft.func_71410_x().field_71441_e) != null) {
            for (Object obj : world.field_73010_i) {
                EntityPlayer player = (EntityPlayer)obj;
                SkinProviderAPI.SKIN.getSkin(PlayerProfile.wrapGameProfile(player.func_146103_bH()));
                SkinProviderAPI.CAPE.getSkin(PlayerProfile.wrapGameProfile(player.func_146103_bH()));
            }
            if (TileEntityRendererDispatcher.field_147556_a.func_147546_a(TileEntitySkull.class).getClass() != TileEntitySkullRenderer.class) {
                ClientRegistry.bindTileEntitySpecialRenderer(TileEntitySkull.class, (TileEntitySpecialRenderer)new TileEntitySkullRenderer());
            }
        }
    }

    @SubscribeEvent
    public void handleEvent(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        SkinCustomization.Flags.clear(Side.CLIENT);
    }
}

