/*
 * Decompiled with CFR 0.152.
 */
package serverutils.net;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import serverutils.client.gui.GuiViewCrashList;
import serverutils.lib.io.DataIn;
import serverutils.lib.io.DataOut;
import serverutils.lib.net.MessageToClient;
import serverutils.lib.net.NetworkWrapper;
import serverutils.net.ServerUtilitiesNetHandler;

public class MessageViewCrashList
extends MessageToClient {
    private Collection<String> list;

    public MessageViewCrashList() {
    }

    public MessageViewCrashList(File folder) {
        this.list = new ArrayList<String>();
        File[] files = folder.listFiles();
        if (files != null) {
            for (File f : files) {
                if (!f.isFile() || !f.getName().endsWith(".txt") || !f.getName().startsWith("crash-")) continue;
                this.list.add(f.getName().replace("crash-", "").replace(".txt", ""));
            }
        }
    }

    @Override
    public NetworkWrapper getWrapper() {
        return ServerUtilitiesNetHandler.FILES;
    }

    @Override
    public void writeData(DataOut data) {
        data.writeCollection(this.list, DataOut.STRING);
    }

    @Override
    public void readData(DataIn data) {
        this.list = data.readCollection(DataIn.STRING);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onMessage() {
        new GuiViewCrashList(this.list).openGui();
    }
}

