/*
 * Decompiled with CFR 0.152.
 */
package serverutils.lib.gui;

import java.util.ArrayList;
import java.util.List;
import serverutils.lib.gui.Button;
import serverutils.lib.gui.Panel;
import serverutils.lib.gui.SimpleTextButton;
import serverutils.lib.gui.Theme;
import serverutils.lib.icon.Icon;
import serverutils.lib.util.misc.MouseButton;

public class ButtonContainer
extends SimpleTextButton {
    private final List<Button> subButtons = new ArrayList<Button>();
    private int offsetX;

    public ButtonContainer(Panel panel, String txt, Icon icon) {
        super(panel, txt, icon);
    }

    public void addSubButton(Button button) {
        this.subButtons.add(button);
    }

    public void setXOffset(int v) {
        this.offsetX = v;
    }

    @Override
    public void setX(int v) {
        super.setX(v);
        this.adjustSubButtons();
    }

    @Override
    public void setY(int v) {
        super.setY(v);
        for (Button button : this.subButtons) {
            button.setY(v);
        }
    }

    @Override
    public void setWidth(int v) {
        super.setWidth(v);
        if (this.subButtons == null) {
            return;
        }
        this.adjustSubButtons();
    }

    private void adjustSubButtons() {
        int startX = this.width + this.offsetX;
        for (Button btn : this.subButtons) {
            btn.setX(startX - btn.width - 1);
            startX -= btn.width - 1;
        }
    }

    @Override
    public void setHeight(int v) {
        super.setHeight(v);
        if (this.subButtons == null) {
            return;
        }
        for (Button button : this.subButtons) {
            button.setHeight(v);
        }
    }

    @Override
    public void draw(Theme theme, int x, int y, int w, int h) {
        super.draw(theme, x, y, w, h);
        for (Button button : this.subButtons) {
            button.draw(theme, button.posX, y, button.width, button.height);
        }
    }

    @Override
    public void drawBackground(Theme theme, int x, int y, int w, int h) {
        super.drawBackground(theme, x, y, w, h);
        for (Button button : this.subButtons) {
            button.drawBackground(theme, button.posX, y, button.width, button.height);
        }
    }

    @Override
    public void drawIcon(Theme theme, int x, int y, int w, int h) {
        for (Button button : this.subButtons) {
            button.drawIcon(theme, button.posX, y, button.width, button.height);
        }
    }

    @Override
    public void updateMouseOver(int mouseX, int mouseY) {
        for (Button subButton : this.subButtons) {
            subButton.updateMouseOver(mouseX, mouseY);
        }
    }

    @Override
    public boolean mousePressed(MouseButton button) {
        for (Button subButton : this.subButtons) {
            if (!subButton.mousePressed(button)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void onClicked(MouseButton button) {
    }
}

