/*
 * Decompiled with CFR 0.152.
 */
package serverutils;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.File;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.function.IntFunction;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatList;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;
import serverutils.ServerUtilities;
import serverutils.ServerUtilitiesPermissions;
import serverutils.ServerUtilitiesStats;
import serverutils.data.Leaderboard;
import serverutils.events.LeaderboardRegistryEvent;
import serverutils.lib.data.ForgePlayer;
import serverutils.lib.io.DataReader;
import serverutils.lib.math.Ticks;
import serverutils.lib.util.JsonUtils;
import serverutils.lib.util.permission.DefaultPermissionLevel;
import serverutils.lib.util.permission.PermissionAPI;

public final class ServerUtilitiesLeaderboards {
    public static final Map<ResourceLocation, Leaderboard> LEADERBOARDS = new HashMap<ResourceLocation, Leaderboard>();
    private static final File STAT_LEADERBOARD_FILE = new File("serverutilities/server/stat_leaderboards.json");
    private static final String[] DEFAULT_STAT_LEADERBOARDS = new String[]{StatList.field_75960_y.field_75975_e, StatList.field_75959_z.field_75975_e, StatList.field_75948_k.field_75975_e, ServerUtilitiesStats.AFK_TIME.field_75975_e, StatList.field_75953_u.field_75975_e};

    static void loadLeaderboards() {
        LEADERBOARDS.clear();
        ServerUtilitiesLeaderboards.registerLeaderboard(new Leaderboard(new ResourceLocation("serverutilities", "deaths_per_hour"), (IChatComponent)new ChatComponentTranslation("serverutilities.stat.dph", new Object[0]), player -> {
            double d = ServerUtilitiesLeaderboards.getDPH(player);
            return new ChatComponentText(d < 0.0 ? "-" : String.format("%.2f", d));
        }, Comparator.comparingDouble(ServerUtilitiesLeaderboards::getDPH).reversed(), player -> ServerUtilitiesLeaderboards.getDPH(player) >= 0.0));
        ServerUtilitiesLeaderboards.registerLeaderboard(new Leaderboard(new ResourceLocation("serverutilities", "time_active"), (IChatComponent)new ChatComponentTranslation("serverutilities.stat.time_active", new Object[0]), player -> Leaderboard.FromStat.TIME.apply(ServerUtilitiesLeaderboards.getActivePlayTime(player)), Comparator.comparingLong(ServerUtilitiesLeaderboards::getActivePlayTime).reversed(), player -> ServerUtilitiesLeaderboards.getActivePlayTime(player) != 0));
        ServerUtilitiesLeaderboards.registerLeaderboard(new Leaderboard(new ResourceLocation("serverutilities", "time_afk_percent"), (IChatComponent)new ChatComponentTranslation("serverutilities.stat.time_afk_percent", new Object[0]), player -> Leaderboard.FromStat.PERCENTAGE.apply(ServerUtilitiesLeaderboards.getAfkTimeFraction(player)), Comparator.comparingDouble(ServerUtilitiesLeaderboards::getAfkTimeFraction).reversed(), player -> ServerUtilitiesLeaderboards.getAfkTimeFraction(player) != 0.0f));
        ServerUtilitiesLeaderboards.registerLeaderboard(new Leaderboard(new ResourceLocation("serverutilities", "last_seen"), (IChatComponent)new ChatComponentTranslation("serverutilities.stat.last_seen", new Object[0]), player -> {
            if (player.isOnline()) {
                ChatComponentTranslation component = new ChatComponentTranslation("gui.online", new Object[0]);
                component.func_150256_b().func_150238_a(EnumChatFormatting.GREEN);
                return component;
            }
            long worldTime = player.team.universe.world.func_82737_E();
            long time = worldTime - player.getLastTimeSeen();
            return Leaderboard.FromStat.LONG_TIME.apply(time);
        }, Comparator.comparingLong(ServerUtilitiesLeaderboards::getRelativeLastSeen), player -> player.getLastTimeSeen() != 0L));
        ServerUtilitiesLeaderboards.loadFromFile();
        new LeaderboardRegistryEvent(ServerUtilitiesLeaderboards::registerLeaderboard).post();
    }

    private static int getActivePlayTime(ForgePlayer player) {
        int playTime = player.stats().func_77444_a(StatList.field_75948_k);
        int afkTime = player.stats().func_77444_a(ServerUtilitiesStats.AFK_TIME);
        return playTime - afkTime;
    }

    private static float getAfkTimeFraction(ForgePlayer player) {
        float playTime = player.stats().func_77444_a(StatList.field_75948_k);
        float afkTime = player.stats().func_77444_a(ServerUtilitiesStats.AFK_TIME);
        return afkTime / Math.max(playTime, 1.0f);
    }

    private static long getRelativeLastSeen(ForgePlayer player) {
        if (player.isOnline()) {
            return 0L;
        }
        return player.team.universe.ticks.ticks() - player.getLastTimeSeen();
    }

    private static double getDPH(ForgePlayer player) {
        double hours;
        int playTime = player.stats().func_77444_a(StatList.field_75948_k);
        if (playTime > 0 && (hours = Ticks.get(playTime).hoursd()) >= 1.0) {
            return (double)player.stats().func_77444_a(StatList.field_75960_y) / hours;
        }
        return -1.0;
    }

    private static JsonElement getAndSaveDefaults() {
        JsonObject obj = new JsonObject();
        for (String id : DEFAULT_STAT_LEADERBOARDS) {
            JsonObject obj1 = new JsonObject();
            obj1.addProperty("name", "");
            obj1.addProperty("reverse", Boolean.valueOf(false));
            obj.add(id, (JsonElement)obj1);
        }
        JsonObject example = new JsonObject();
        example.addProperty("name", "The name that appears in the gui, leave empty/remove for default");
        example.addProperty("reverse", "(true || false) whether lower numbers should appear highest in the leaderboard");
        obj.add("example.Stat || Full list of usable stats can be dumped with /dump_stats", (JsonElement)example);
        JsonUtils.toJsonSafe(STAT_LEADERBOARD_FILE, (JsonElement)obj);
        return obj;
    }

    private static void loadFromFile() {
        JsonElement element = !STAT_LEADERBOARD_FILE.exists() ? ServerUtilitiesLeaderboards.getAndSaveDefaults() : DataReader.get(STAT_LEADERBOARD_FILE).safeJson();
        if (JsonUtils.isNull(element)) {
            return;
        }
        if (element.isJsonObject()) {
            for (Map.Entry entry : element.getAsJsonObject().entrySet()) {
                String key = (String)entry.getKey();
                if (key.startsWith("example")) continue;
                StatBase stat = StatList.func_151177_a((String)key);
                if (stat == null) {
                    ServerUtilities.LOGGER.warn("Couldn't find stat with id {}, skipping", new Object[]{key});
                    continue;
                }
                JsonElement value = (JsonElement)entry.getValue();
                if (!value.isJsonObject()) continue;
                JsonObject obj = value.getAsJsonObject();
                JsonPrimitive nameElem = obj.getAsJsonPrimitive("name");
                Object name = nameElem != null && !nameElem.getAsString().isEmpty() ? new ChatComponentText(nameElem.getAsString()) : ServerUtilitiesLeaderboards.getSafeName(stat);
                boolean reverse = false;
                JsonPrimitive reverseElem = obj.getAsJsonPrimitive("reverse");
                if (reverseElem != null && reverseElem.getAsBoolean()) {
                    reverse = true;
                }
                ServerUtilitiesLeaderboards.registerLeaderboard(new Leaderboard.FromStat(new ResourceLocation("serverutilities", key), (IChatComponent)name, stat, reverse, ServerUtilitiesLeaderboards.getStatIntFunction(stat)));
            }
        }
    }

    private static IntFunction<IChatComponent> getStatIntFunction(StatBase stat) {
        if (stat.field_75976_b.equals(StatBase.field_75981_i)) {
            return Leaderboard.FromStat.TIME;
        }
        return Leaderboard.FromStat.DEFAULT;
    }

    private static IChatComponent getSafeName(StatBase stat) {
        Object object;
        ChatComponentTranslation translation;
        IChatComponent component = stat.field_75978_a;
        String id = stat.field_75975_e;
        if (component instanceof ChatComponentTranslation && (translation = (ChatComponentTranslation)component).func_150271_j().length > 0 && (object = translation.func_150271_j()[0]) instanceof ChatComponentTranslation) {
            ChatComponentTranslation arg = (ChatComponentTranslation)object;
            if (id.startsWith("stat.entityKilledBy")) {
                return new ChatComponentTranslation("serverutilities.stat.killed_by", new Object[]{arg.func_150260_c()});
            }
            if (id.startsWith("stat.killEntity")) {
                return new ChatComponentTranslation("serverutilities.stat.entities_killed", new Object[]{arg.func_150260_c()});
            }
        }
        return component;
    }

    public static void registerLeaderboard(Leaderboard leaderboard) {
        LEADERBOARDS.put(leaderboard.id, leaderboard);
        PermissionAPI.registerNode(ServerUtilitiesPermissions.getLeaderboardNode(leaderboard), DefaultPermissionLevel.ALL, "");
    }
}

