/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg.entities;

import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import gcewing.sg.SGCraft;
import gcewing.sg.entities.BaseEntity;
import gcewing.sg.tileentities.SGBaseTE;
import gcewing.sg.utils.BaseBlockUtils;
import gcewing.sg.utils.BaseUtils;
import gcewing.sg.utils.Trans3;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.joml.Vector3i;

public class IrisEntity
extends BaseEntity
implements IEntityAdditionalSpawnData {
    public static boolean debugIrisEntity = false;
    Vector3i blockPos;

    public IrisEntity(World world) {
        super(world);
    }

    public IrisEntity(SGBaseTE te) {
        this(BaseBlockUtils.getTileEntityWorld(te));
        double radius = 2.0;
        double thickness = 0.2;
        double cx = 0.0;
        double cy = 2.0;
        double cz = 0.1;
        double hx = radius;
        double hy = radius;
        double hz = thickness;
        AxisAlignedBB localBox = BaseUtils.newAxisAlignedBB(cx - hx, cy - hy, cz - hz, cx + hx, cy + hy, cz + hz);
        Trans3 t = te.localToGlobalTransformation();
        AxisAlignedBB globalBox = t.t(localBox);
        this.init(te.getPos(), globalBox);
    }

    void init(Vector3i pos, AxisAlignedBB box) {
        if (debugIrisEntity) {
            SGCraft.log.debug(String.format("IrisEntity.init: %s at %s box %s", new Object[]{this, pos, box}));
        }
        this.blockPos = pos;
        this.func_70107_b(box.field_72340_a, box.field_72338_b, box.field_72339_c);
        this.setBoundingBox(box);
    }

    protected void func_70088_a() {
    }

    SGBaseTE getBaseTE() {
        TileEntity te = BaseBlockUtils.getWorldTileEntity((IBlockAccess)this.field_70170_p, this.blockPos);
        if (te instanceof SGBaseTE) {
            return (SGBaseTE)te;
        }
        return null;
    }

    public boolean func_70067_L() {
        SGBaseTE te = this.getBaseTE();
        boolean result = te != null ? te.irisIsClosed() : false;
        return result;
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBox() {
        if (this.func_70067_L()) {
            return super.getEntityBoundingBox();
        }
        return null;
    }

    public boolean func_70104_M() {
        return false;
    }

    public void func_70037_a(NBTTagCompound nbt) {
        if (debugIrisEntity) {
            SGCraft.log.debug(String.format("IrisEntity.readEntityFromNBT: %s", nbt));
        }
        int blockX = nbt.func_74762_e("blockX");
        int blockY = nbt.func_74762_e("blockY");
        int blockZ = nbt.func_74762_e("blockZ");
        Vector3i pos = new Vector3i(blockX, blockY, blockZ);
        double minX = nbt.func_74769_h("minX");
        double minY = nbt.func_74769_h("minY");
        double minZ = nbt.func_74769_h("minZ");
        double maxX = nbt.func_74769_h("maxX");
        double maxY = nbt.func_74769_h("maxY");
        double maxZ = nbt.func_74769_h("maxZ");
        AxisAlignedBB box = BaseUtils.newAxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
        this.init(pos, box);
    }

    public void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74768_a("blockX", this.blockPos.x);
        nbt.func_74768_a("blockY", this.blockPos.y);
        nbt.func_74768_a("blockZ", this.blockPos.z);
        AxisAlignedBB box = this.getEntityBoundingBox();
        nbt.func_74780_a("minX", box.field_72340_a);
        nbt.func_74780_a("minY", box.field_72338_b);
        nbt.func_74780_a("minZ", box.field_72339_c);
        nbt.func_74780_a("maxX", box.field_72336_d);
        nbt.func_74780_a("maxY", box.field_72337_e);
        nbt.func_74780_a("maxZ", box.field_72334_f);
        if (debugIrisEntity) {
            SGCraft.log.debug(String.format("IrisEntity.writeEntityToNBT: %s", nbt));
        }
    }

    protected boolean func_142008_O() {
        return false;
    }

    public void writeSpawnData(ByteBuf buffer) {
        try {
            ByteBufOutputStream data = new ByteBufOutputStream(buffer);
            BaseUtils.writeBlockPos((DataOutput)data, this.blockPos);
            AxisAlignedBB box = this.getEntityBoundingBox();
            data.writeDouble(box.field_72340_a);
            data.writeDouble(box.field_72338_b);
            data.writeDouble(box.field_72339_c);
            data.writeDouble(box.field_72336_d);
            data.writeDouble(box.field_72337_e);
            data.writeDouble(box.field_72334_f);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void readSpawnData(ByteBuf buffer) {
        try {
            ByteBufInputStream data = new ByteBufInputStream(buffer);
            Vector3i pos = BaseUtils.readBlockPos((DataInput)data);
            double minX = data.readDouble();
            double minY = data.readDouble();
            double minZ = data.readDouble();
            double maxX = data.readDouble();
            double maxY = data.readDouble();
            double maxZ = data.readDouble();
            AxisAlignedBB box = BaseUtils.newAxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
            this.init(pos, box);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

