/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg.blocks;

import gcewing.sg.SGCraft;
import gcewing.sg.blocks.SGBaseBlock;
import gcewing.sg.blocks.base.BaseBlock;
import gcewing.sg.blocks.orientation.Orient4WaysByState;
import gcewing.sg.guis.DHDTE;
import gcewing.sg.guis.SGGui;
import gcewing.sg.interfaces.IBlockState;
import gcewing.sg.interfaces.IOrientationHandler;
import gcewing.sg.tileentities.SGBaseTE;
import gcewing.sg.utils.ModelSpec;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.joml.Vector3d;
import org.joml.Vector3i;

public class DHDBlock
extends BaseBlock<DHDTE> {
    protected static IOrientationHandler orient4WaysByState = new Orient4WaysByState();
    protected static String[] textures = new String[]{"dhd_top", "dhd_side", "stargateBlock", "dhd_button_dim"};
    protected static ModelSpec model = new ModelSpec("dhd.smeg", new Vector3d(0.0, -0.5, 0.0), textures);

    public DHDBlock() {
        super(Material.field_151576_e, DHDTE.class);
        this.func_149711_c(1.5f);
        this.func_149647_a(CreativeTabs.field_78026_f);
    }

    @Override
    public String[] getTextureNames() {
        return textures;
    }

    @Override
    public ModelSpec getModelSpec(IBlockState state) {
        return model;
    }

    @Override
    public IOrientationHandler getOrientationHandler() {
        return orient4WaysByState;
    }

    @Override
    public int func_149645_b() {
        return -1;
    }

    @Override
    public boolean func_149662_c() {
        return false;
    }

    @Override
    public void onBlockAdded(World world, Vector3i pos, IBlockState state) {
        if (SGBaseBlock.debugMerge) {
            SGCraft.log.debug(String.format("DHDBlock.onBlockAdded: at %s", pos));
        }
        this.checkForLink(world, pos);
    }

    @Override
    public void onBlockPlacedBy(World world, Vector3i pos, IBlockState state, EntityLivingBase player, ItemStack stack) {
        super.onBlockPlacedBy(world, pos, state, player, stack);
        this.checkForLink(world, pos);
    }

    @Override
    public boolean canHarvestBlock(IBlockState state, EntityPlayer player) {
        return true;
    }

    @Override
    public void breakBlock(World world, Vector3i pos, IBlockState state) {
        SGBaseTE gte;
        TileEntity cte = this.getTileEntity((IBlockAccess)world, pos);
        super.breakBlock(world, pos, state);
        if (cte == null) {
            SGCraft.log.debug(String.format("DHDBlock.breakBlock: No tile entity at %s", pos));
        } else if (cte instanceof DHDTE && ((DHDTE)cte).isLinkedToStargate && (gte = ((DHDTE)cte).getLinkedStargateTE()) != null) {
            gte.clearLinkToController();
        }
    }

    @Override
    public boolean onBlockActivated(World world, Vector3i pos, IBlockState state, EntityPlayer player, EnumFacing side, float cx, float cy, float cz) {
        SGGui id = (double)cy > 0.5 ? SGGui.SGController : SGGui.DHDFuel;
        SGCraft.mod.openGui(player, (Enum)id, world, pos);
        return true;
    }

    public void checkForLink(World world, Vector3i pos) {
        TileEntity te = this.getTileEntity((IBlockAccess)world, pos);
        if (te instanceof DHDTE) {
            ((DHDTE)te).checkForLink();
        } else {
            SGCraft.log.debug(String.format("DHDBlock.breakBlock: No tile entity at %s", pos));
        }
    }
}

