/*
 * Decompiled with CFR 0.152.
 */
package remoteio.common.core.compat;

import appeng.api.AEApi;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridBlock;
import appeng.api.networking.IGridConnection;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridVisitor;
import appeng.api.util.IReadOnlyCollection;
import appeng.util.ReadOnlyCollection;
import com.google.common.collect.Lists;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import remoteio.common.tile.TileRemoteInterface;

public class LinkedGridNode
implements IGridNode {
    private final WeakReference<IGridNode> parentNode;
    private final WeakReference<IGridNode> ourNode;
    private final TileRemoteInterface parentInterface;

    public LinkedGridNode(IGridNode parentNode, TileRemoteInterface parentInterface) {
        this.parentNode = new WeakReference<IGridNode>(parentNode);
        this.ourNode = new WeakReference<IGridNode>(AEApi.instance().createGridNode((IGridBlock)parentInterface));
        this.parentInterface = parentInterface;
    }

    private IGridNode getParentNode() {
        return this.parentNode != null ? (IGridNode)this.parentNode.get() : null;
    }

    private IGridNode getOurNode() {
        return this.ourNode != null ? (IGridNode)this.ourNode.get() : null;
    }

    public void beginVisit(IGridVisitor g) {
        IGridNode gridNode = this.getParentNode();
        IGridNode ourNode = this.getOurNode();
        if (gridNode != null) {
            gridNode.beginVisit(g);
        } else if (ourNode != null) {
            ourNode.beginVisit(g);
        }
    }

    public void updateState() {
        IGridNode gridNode = this.getParentNode();
        IGridNode ourNode = this.getOurNode();
        if (gridNode != null) {
            gridNode.updateState();
        }
        if (ourNode != null) {
            ourNode.updateState();
        }
    }

    public IGridHost getMachine() {
        return this.parentInterface;
    }

    public IGrid getGrid() {
        IGridNode gridNode = this.getParentNode();
        return gridNode != null ? gridNode.getGrid() : null;
    }

    public void destroy() {
        IGridNode gridNode = this.getParentNode();
        IGridNode ourNode = this.getOurNode();
        if (gridNode != null) {
            gridNode.destroy();
        }
        if (ourNode != null) {
            ourNode.destroy();
        }
    }

    public World getWorld() {
        return this.parentInterface.func_145831_w();
    }

    public EnumSet<ForgeDirection> getConnectedSides() {
        IGridNode gridNode = this.getParentNode();
        IGridNode ourNode = this.getOurNode();
        EnumSet<ForgeDirection> enumSet = EnumSet.noneOf(ForgeDirection.class);
        if (gridNode != null) {
            enumSet.addAll(gridNode.getConnectedSides());
        }
        if (ourNode != null) {
            enumSet.addAll(ourNode.getConnectedSides());
        }
        return enumSet;
    }

    public IReadOnlyCollection<IGridConnection> getConnections() {
        IGridNode gridNode = this.getParentNode();
        IGridNode ourNode = this.getOurNode();
        ArrayList list = Lists.newArrayList();
        if (gridNode != null) {
            for (IGridConnection gridConneciton : gridNode.getConnections()) {
                list.add(gridConneciton);
            }
        }
        if (ourNode != null) {
            for (IGridConnection gridConneciton : ourNode.getConnections()) {
                list.add(gridConneciton);
            }
        }
        return new ReadOnlyCollection((Collection)list);
    }

    public IGridBlock getGridBlock() {
        return this.parentInterface;
    }

    public boolean isActive() {
        return this.parentInterface.hasTransferChip(20);
    }

    public void loadFromNBT(String name, NBTTagCompound nodeData) {
        IGridNode gridNode = this.getParentNode();
        IGridNode ourNode = this.getOurNode();
        if (gridNode != null) {
            gridNode.loadFromNBT(name, nodeData);
        }
        if (ourNode != null) {
            ourNode.loadFromNBT(name, nodeData);
        }
    }

    public void saveToNBT(String name, NBTTagCompound nodeData) {
        IGridNode gridNode = this.getParentNode();
        IGridNode ourNode = this.getOurNode();
        if (gridNode != null) {
            gridNode.saveToNBT(name, nodeData);
        }
        if (ourNode != null) {
            ourNode.saveToNBT(name, nodeData);
        }
    }

    public boolean meetsChannelRequirements() {
        IGridNode gridNode = this.getParentNode();
        IGridNode ourNode = this.getOurNode();
        return gridNode != null && gridNode.meetsChannelRequirements() || ourNode != null && ourNode.meetsChannelRequirements();
    }

    public boolean hasFlag(GridFlags flag) {
        IGridNode gridNode = this.getParentNode();
        IGridNode ourNode = this.getOurNode();
        return gridNode != null && gridNode.hasFlag(flag) || ourNode != null && ourNode.hasFlag(flag);
    }

    public void setPlayerID(int playerID) {
        IGridNode gridNode = this.getParentNode();
        if (gridNode != null) {
            gridNode.setPlayerID(playerID);
        }
    }

    public int getPlayerID() {
        IGridNode gridNode = this.getParentNode();
        return gridNode != null ? gridNode.getPlayerID() : 0;
    }
}

