/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.util.inventory;

import java.util.Collection;
import java.util.Collections;
import mods.railcraft.api.core.items.IStackFilter;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.inventory.filters.ArrayStackFilter;
import mods.railcraft.common.util.inventory.filters.InvertedStackFilter;
import mods.railcraft.common.util.inventory.filters.StackFilter;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class InvFilteredHelper {
    private static final InvFilteredHelper ACCEPTS_ALL = new InvFilteredHelper(StackFilter.ALL);
    private final IStackFilter filter;

    private InvFilteredHelper(IStackFilter filter) {
        this.filter = filter;
    }

    public int countItems(IInventory inventory) {
        return this.countItems(Collections.singletonList(inventory));
    }

    public int countItems(Collection<IInventory> inventories) {
        return InvTools.countItems(inventories, this.filter);
    }

    public ItemStack moveOneItem(Collection<IInventory> sources, IInventory destination) {
        return this.moveOneItem(sources, Collections.singletonList(destination));
    }

    public ItemStack moveOneItem(IInventory source, Collection<IInventory> destinations) {
        return this.moveOneItem(Collections.singletonList(source), destinations);
    }

    public ItemStack moveOneItem(Collection<IInventory> sources, Collection<IInventory> destinations) {
        for (IInventory source : sources) {
            for (IInventory dest : destinations) {
                ItemStack moved = InvTools.moveOneItem(source, dest, this.filter);
                if (moved == null) continue;
                return moved;
            }
        }
        return null;
    }

    public InvFilteredHelper invert() {
        return new InvFilteredHelper(new InvertedStackFilter(this.filter));
    }

    public static InvFilteredHelper acceptAll() {
        return ACCEPTS_ALL;
    }

    public static InvFilteredHelper filteredByStacks(ItemStack ... filters) {
        return InvFilteredHelper.filteredByStacks(false, false, filters);
    }

    public static InvFilteredHelper filteredByStacks(boolean matchNBT, boolean matchMetadata, ItemStack ... filters) {
        return new InvFilteredHelper(new ArrayStackFilter(matchNBT, matchMetadata, filters));
    }
}

