/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.plugins.ic2;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.eventhandler.Event;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.item.ElectricItem;
import ic2.api.item.IC2Items;
import ic2.api.item.IElectricItem;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.RecipeInputItemStack;
import ic2.api.recipe.RecipeOutput;
import ic2.api.recipe.Recipes;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.init.Items;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;

public class IC2Plugin {
    public static final int[] POWER_TIERS = new int[]{1, 6, 32, 512, 2048, 8192};
    private static final Map<String, ItemStack> itemCache = new HashMap<String, ItemStack>();
    private static final Map<String, Boolean> itemCacheFlag = new HashMap<String, Boolean>();
    private static Boolean IC2modLoaded = null;
    private static Boolean dreamcraftLoaded = null;
    private static Boolean classic = null;

    public static ItemStack getItem(String tag) {
        if (!IC2Plugin.isModInstalled()) {
            return null;
        }
        ItemStack stack = itemCache.get(tag);
        if (stack != null) {
            return stack;
        }
        Boolean wasCached = itemCacheFlag.get(tag);
        if (wasCached == Boolean.TRUE) {
            return null;
        }
        try {
            itemCacheFlag.put(tag, Boolean.TRUE);
            stack = IC2Items.getItem((String)tag);
            if (stack != null) {
                itemCache.put(tag, stack.func_77946_l());
            }
            return stack;
        }
        catch (Throwable error) {
            Game.logErrorAPI("IC2", error, Items.class);
            return null;
        }
    }

    @Optional.Method(modid="IC2")
    public static void addTileToNet(TileEntity tile) {
        try {
            if (tile instanceof IEnergyTile) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)tile));
            }
        }
        catch (Throwable error) {
            Game.logErrorAPI("IC2", error, EnergyTileLoadEvent.class);
        }
    }

    @Optional.Method(modid="IC2")
    public static void removeTileFromNet(TileEntity tile) {
        try {
            if (tile instanceof IEnergyTile) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)tile));
            }
        }
        catch (Throwable error) {
            Game.logErrorAPI("IC2", error, EnergyTileUnloadEvent.class);
        }
    }

    @Optional.Method(modid="IC2")
    public static boolean isEnergyItem(ItemStack stack) {
        try {
            return stack != null && stack.func_77973_b() instanceof IElectricItem;
        }
        catch (Throwable error) {
            Game.logErrorAPI("IC2", error, IElectricItem.class);
            return false;
        }
    }

    @Optional.Method(modid="IC2")
    public static double chargeItem(ItemStack stack, double energy, int tier) {
        try {
            if (stack != null && stack.func_77973_b() instanceof IElectricItem && energy > 0.0) {
                return ElectricItem.manager.charge(stack, energy, tier, false, false);
            }
        }
        catch (Throwable error) {
            Game.logErrorAPI("IC2", error, ElectricItem.class);
        }
        return 0.0;
    }

    @Optional.Method(modid="IC2")
    public static double dischargeItem(ItemStack stack, double energyNeeded, int tier) {
        try {
            if (stack != null && stack.func_77973_b() instanceof IElectricItem && ((IElectricItem)stack.func_77973_b()).canProvideEnergy(stack)) {
                return ElectricItem.manager.discharge(stack, energyNeeded, tier, false, true, false);
            }
        }
        catch (Throwable error) {
            Game.logErrorAPI("IC2", error, ElectricItem.class);
        }
        return 0.0;
    }

    @Optional.Method(modid="IC2")
    public static boolean canCharge(ItemStack stack, int tier) {
        try {
            if (stack != null && stack.func_77973_b() instanceof IElectricItem) {
                IElectricItem battery = (IElectricItem)stack.func_77973_b();
                return tier >= battery.getTier(stack);
            }
        }
        catch (Throwable error) {
            Game.logErrorAPI("IC2", error, IElectricItem.class);
        }
        return false;
    }

    @Optional.Method(modid="IC2")
    public static boolean canDischarge(ItemStack stack, int tier) {
        try {
            if (stack != null && stack.func_77973_b() instanceof IElectricItem) {
                IElectricItem battery = (IElectricItem)stack.func_77973_b();
                return battery.canProvideEnergy(stack) && tier >= battery.getTier(stack);
            }
        }
        catch (Throwable error) {
            Game.logErrorAPI("IC2", error, IElectricItem.class);
        }
        return false;
    }

    @Optional.Method(modid="IC2")
    public static void addMaceratorRecipe(ItemStack input, ItemStack output) {
        if (IC2Plugin.isDreamCraftInstalled()) {
            return;
        }
        try {
            Recipes.macerator.addRecipe((IRecipeInput)new RecipeInputItemStack(input), null, new ItemStack[]{output});
        }
        catch (Throwable error) {
            Game.logErrorAPI("IC2", error, Recipes.class);
        }
    }

    @Optional.Method(modid="IC2")
    public static void removeMaceratorRecipes(ItemStack ... items) {
        if (IC2Plugin.isDreamCraftInstalled()) {
            return;
        }
        try {
            Map recipes = Recipes.macerator.getRecipes();
            Iterator it = recipes.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                if (!IC2Plugin.doesRecipeRequire((IRecipeInput)entry.getKey(), items) && !IC2Plugin.doesRecipeProduce((RecipeOutput)entry.getValue(), items)) continue;
                it.remove();
            }
        }
        catch (Throwable error) {
            Game.logErrorAPI("IC2", error, Recipes.class);
        }
    }

    @Optional.Method(modid="IC2")
    private static boolean doesRecipeRequire(IRecipeInput input, ItemStack ... items) {
        for (ItemStack stack : input.getInputs()) {
            if (!InvTools.isItemEqual(stack, items)) continue;
            return true;
        }
        return false;
    }

    @Optional.Method(modid="IC2")
    private static boolean doesRecipeProduce(RecipeOutput recipe, ItemStack ... items) {
        for (ItemStack output : recipe.items) {
            if (!InvTools.isItemEqual(output, items)) continue;
            return true;
        }
        return false;
    }

    @Optional.Method(modid="IC2")
    public static void removeMaceratorDustRecipes(ItemStack ... items) {
        if (IC2Plugin.isDreamCraftInstalled()) {
            return;
        }
        try {
            Map recipes = Recipes.macerator.getRecipes();
            Iterator it = recipes.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                if (!IC2Plugin.isInputBlock((IRecipeInput)entry.getKey(), items) || !IC2Plugin.doesRecipeProduce((RecipeOutput)entry.getValue(), items)) continue;
                it.remove();
            }
        }
        catch (Throwable error) {
            Game.logErrorAPI("IC2", error, Recipes.class);
        }
    }

    private static boolean isInputBlock(IRecipeInput input, ItemStack ... items) {
        for (ItemStack stack : input.getInputs()) {
            if (stack == null || !(stack.func_77973_b() instanceof ItemBlock)) continue;
            return true;
        }
        return false;
    }

    public static void nerfSyntheticCoal() {
        for (IRecipe recipe : CraftingManager.func_77594_a().func_77592_b()) {
            try {
                ItemStack output = recipe.func_77571_b();
                if (output == null || output.func_77973_b() != Items.field_151044_h || output.field_77994_a != 20) continue;
                output.field_77994_a = 5;
            }
            catch (Throwable throwable) {}
        }
    }

    public static boolean isModInstalled() {
        if (IC2modLoaded == null) {
            IC2modLoaded = Loader.isModLoaded((String)"IC2") || Loader.isModLoaded((String)"IC2-Classic-Spmod");
        }
        return IC2modLoaded;
    }

    public static boolean isDreamCraftInstalled() {
        if (dreamcraftLoaded == null) {
            dreamcraftLoaded = Loader.isModLoaded((String)"dreamcraft");
        }
        return dreamcraftLoaded;
    }

    public static boolean isClassic() {
        if (classic == null) {
            classic = Loader.isModLoaded((String)"IC2-Classic-Spmod");
        }
        return classic;
    }
}

