/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.modules;

import cpw.mods.fml.common.registry.VillagerRegistry;
import mods.railcraft.common.blocks.aesthetics.cube.BlockCube;
import mods.railcraft.common.blocks.aesthetics.cube.EnumCube;
import mods.railcraft.common.blocks.ore.BlockOre;
import mods.railcraft.common.blocks.ore.BlockWorldLogic;
import mods.railcraft.common.blocks.ore.EnumOre;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.modules.ModuleManager;
import mods.railcraft.common.modules.RailcraftModule;
import mods.railcraft.common.plugins.forestry.ForestryPlugin;
import mods.railcraft.common.plugins.forge.CraftingPlugin;
import mods.railcraft.common.worldgen.ComponentWorkshop;
import mods.railcraft.common.worldgen.FirestoneGenerator;
import mods.railcraft.common.worldgen.GeodePopulator;
import mods.railcraft.common.worldgen.PoorCopperGenerator;
import mods.railcraft.common.worldgen.PoorGoldGenerator;
import mods.railcraft.common.worldgen.PoorIronGenerator;
import mods.railcraft.common.worldgen.PoorLeadGenerator;
import mods.railcraft.common.worldgen.PoorTinGenerator;
import mods.railcraft.common.worldgen.QuarryPopulator;
import mods.railcraft.common.worldgen.SaltpeterGenerator;
import mods.railcraft.common.worldgen.SulfurGenerator;
import mods.railcraft.common.worldgen.VillagerTradeHandler;
import mods.railcraft.common.worldgen.WorkshopCreationHandeler;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class ModuleWorld
extends RailcraftModule {
    public static final ResourceLocation VILLAGER_TEXTURE = new ResourceLocation("railcraft:textures/entities/villager/trackman.png");

    @Override
    public void preInit() {
        if (RailcraftConfig.isWorldGenEnabled("workshop")) {
            int id = RailcraftConfig.villagerID();
            VillagerRegistry.instance().registerVillagerId(id);
            VillagerRegistry.instance().registerVillageTradeHandler(id, (VillagerRegistry.IVillageTradeHandler)new VillagerTradeHandler());
            VillagerRegistry.instance().registerVillageCreationHandler((VillagerRegistry.IVillageCreationHandler)new WorkshopCreationHandeler());
            try {
                MapGenStructureIO.func_143031_a(ComponentWorkshop.class, (String)"railcraft:workshop");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public void initFirst() {
        ItemStack fert;
        BlockOre.registerBlock();
        BlockWorldLogic.registerBlock();
        EnumCube cubeType = EnumCube.ABYSSAL_STONE;
        if (RailcraftConfig.isSubBlockEnabled(cubeType.getTag())) {
            BlockCube.registerBlock();
        }
        if (RailcraftConfig.isSubBlockEnabled((cubeType = EnumCube.QUARRIED_STONE).getTag())) {
            BlockCube.registerBlock();
        }
        if (RailcraftConfig.isWorldGenEnabled("saltpeter") && EnumOre.SALTPETER.isEnabled()) {
            MinecraftForge.ORE_GEN_BUS.register((Object)new SaltpeterGenerator());
        }
        if (RailcraftConfig.isWorldGenEnabled("sulfur") && EnumOre.SULFUR.isEnabled()) {
            MinecraftForge.ORE_GEN_BUS.register((Object)new SulfurGenerator());
        }
        if (RailcraftConfig.isWorldGenEnabled("firestone") && EnumOre.FIRESTONE.isEnabled() && ModuleManager.isModuleLoaded(ModuleManager.Module.MAGIC)) {
            MinecraftForge.EVENT_BUS.register((Object)new FirestoneGenerator());
        }
        if (RailcraftConfig.isWorldGenEnabled("abyssal") && EnumCube.ABYSSAL_STONE.isEnabled()) {
            MinecraftForge.EVENT_BUS.register((Object)GeodePopulator.instance());
        }
        if (RailcraftConfig.isWorldGenEnabled("quarried") && EnumCube.QUARRIED_STONE.isEnabled()) {
            MinecraftForge.EVENT_BUS.register((Object)QuarryPopulator.instance());
        }
        if (RailcraftConfig.isWorldGenEnabled("iron") && EnumOre.POOR_IRON.isEnabled()) {
            MinecraftForge.ORE_GEN_BUS.register((Object)new PoorIronGenerator());
        }
        if (RailcraftConfig.isWorldGenEnabled("gold") && EnumOre.POOR_GOLD.isEnabled()) {
            MinecraftForge.ORE_GEN_BUS.register((Object)new PoorGoldGenerator());
        }
        if (RailcraftConfig.isWorldGenEnabled("copper") && EnumOre.POOR_COPPER.isEnabled()) {
            MinecraftForge.ORE_GEN_BUS.register((Object)new PoorCopperGenerator());
        }
        if (RailcraftConfig.isWorldGenEnabled("tin") && EnumOre.POOR_TIN.isEnabled()) {
            MinecraftForge.ORE_GEN_BUS.register((Object)new PoorTinGenerator());
        }
        if (RailcraftConfig.isWorldGenEnabled("lead") && EnumOre.POOR_LEAD.isEnabled()) {
            MinecraftForge.ORE_GEN_BUS.register((Object)new PoorLeadGenerator());
        }
        if (RailcraftConfig.getRecipeConfig("railcraft.misc.gunpowder")) {
            ShapelessOreRecipe recipe = new ShapelessOreRecipe(new ItemStack(Items.field_151016_H, 2), new Object[]{"dustSaltpeter", "dustSaltpeter", "dustSulfur", "dustCharcoal"});
            CraftingManager.func_77594_a().func_77592_b().add(recipe);
        }
        if (RailcraftConfig.getRecipeConfig("forestry.misc.fertilizer") && (fert = ForestryPlugin.getItem("fertilizerCompound")) != null) {
            fert = fert.func_77946_l();
            fert.field_77994_a = 2;
            CraftingPlugin.addShapelessRecipe(fert, "dustSaltpeter", "sand", "sand", new ItemStack(Blocks.field_150346_d), new ItemStack(Blocks.field_150346_d));
        }
    }
}

