/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.gui.widgets;

import mods.railcraft.common.gui.widgets.IndicatorController;

public class ChargeIndicator
extends IndicatorController {
    private double charge;
    private final double maxCharge;

    public ChargeIndicator(double maxEnergy) {
        this.maxCharge = maxEnergy;
    }

    @Override
    protected void refreshToolTip() {
        this.tip.text = String.format("%.0f%%", this.charge / this.maxCharge * 100.0);
    }

    @Override
    public int getScaledLevel(int size) {
        double e = Math.min(this.charge, this.maxCharge);
        return (int)(e * (double)size / this.maxCharge);
    }

    public void setCharge(double energy) {
        this.charge = energy;
    }

    public void updateCharge(double energy) {
        this.charge = (this.charge * 9.0 + energy) / 10.0;
    }
}

