/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.fluids.tanks;

import java.util.Locale;
import mods.railcraft.common.gui.tooltips.ToolTip;
import mods.railcraft.common.gui.tooltips.ToolTipLine;
import net.minecraft.item.EnumRarity;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public class StandardTank
extends FluidTank {
    public static final int DEFAULT_COLOR = 0xFFFFFF;
    public final TankRenderData renderData = new TankRenderData();
    protected final ToolTip toolTip = new ToolTip(){

        @Override
        public void refresh() {
            StandardTank.this.refreshTooltip();
        }
    };
    private int tankIndex;
    private boolean hidden;

    public StandardTank(int capacity) {
        super(capacity);
    }

    public StandardTank(int capacity, TileEntity tile) {
        this(capacity);
        this.tile = tile;
    }

    public int getTankIndex() {
        return this.tankIndex;
    }

    public void setTankIndex(int index) {
        this.tankIndex = index;
    }

    public int getColor() {
        Fluid f = this.getFluidType();
        if (f == null) {
            return 0xFFFFFF;
        }
        return f.getColor(this.getFluid());
    }

    public boolean isEmpty() {
        return this.getFluid() == null || this.getFluid().amount <= 0;
    }

    public boolean isFull() {
        return this.getFluid() != null && this.getFluid().amount == this.getCapacity();
    }

    public int getRemainingSpace() {
        return this.capacity - this.getFluidAmount();
    }

    public Fluid getFluidType() {
        return this.getFluid() != null ? this.getFluid().getFluid() : null;
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource == null) {
            return 0;
        }
        if (resource.amount <= 0) {
            return 0;
        }
        return super.fill(resource, doFill);
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (maxDrain <= 0) {
            return null;
        }
        return super.drain(maxDrain, doDrain);
    }

    public ToolTip getToolTip() {
        return this.toolTip;
    }

    protected void refreshTooltip() {
        this.toolTip.clear();
        int amount = 0;
        if (this.renderData.fluid != null && this.renderData.amount > 0) {
            EnumRarity rarity = this.renderData.fluid.getRarity();
            if (rarity == null) {
                rarity = EnumRarity.common;
            }
            ToolTipLine fluidName = new ToolTipLine(this.renderData.fluid.getLocalizedName(new FluidStack(this.renderData.fluid, this.renderData.amount)), rarity.field_77937_e);
            fluidName.setSpacing(2);
            this.toolTip.add(fluidName);
            amount = this.renderData.amount;
        }
        this.toolTip.add(new ToolTipLine(String.format(Locale.ENGLISH, "%,d / %,d", amount, this.getCapacity())));
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public static class TankRenderData {
        public Fluid fluid = null;
        public int amount = 0;
        public int color = 0xFFFFFF;

        public void reset() {
            this.fluid = null;
            this.amount = 0;
            this.color = 0xFFFFFF;
        }
    }
}

