/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.carts;

import java.util.ArrayList;
import java.util.List;
import mods.railcraft.api.carts.IItemCart;
import mods.railcraft.common.carts.EntityCartFiltered;
import mods.railcraft.common.carts.EnumCart;
import mods.railcraft.common.carts.ICartType;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.fluids.FluidItemHelper;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class EntityCartCargo
extends EntityCartFiltered
implements IItemCart {
    private static final byte SLOTS_FILLED_DATA_ID = 25;

    public EntityCartCargo(World world) {
        super(world);
    }

    public EntityCartCargo(World world, double d, double d1, double d2) {
        this(world);
        this.func_70107_b(d, d1 + (double)this.field_70129_M, d2);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.field_70169_q = d;
        this.field_70167_r = d1;
        this.field_70166_s = d2;
    }

    @Override
    public ICartType getCartType() {
        return EnumCart.CARGO;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(25, (Object)new Integer(-1));
    }

    public int getSlotsFilled() {
        return this.field_70180_af.func_75679_c(25);
    }

    private void setSlotsFilled(int slotsFilled) {
        this.field_70180_af.func_75692_b(25, (Object)slotsFilled);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (Game.isHost(this.field_70170_p)) {
            this.setSlotsFilled(InvTools.countStacks((IInventory)this));
        }
    }

    @Override
    public List<ItemStack> getItemsDropped() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        if (RailcraftConfig.doCartsBreakOnDrop()) {
            items.add(new ItemStack(Items.field_151143_au));
            items.add(new ItemStack(Blocks.field_150447_bR));
        } else {
            items.add(this.getCartItem());
        }
        return items;
    }

    @Override
    public boolean doInteract(EntityPlayer player) {
        if (Game.isHost(this.field_70170_p)) {
            GuiHandler.openGui(EnumGui.CART_CARGO, player, this.field_70170_p, (Entity)this);
        }
        return true;
    }

    public Block func_145820_n() {
        return null;
    }

    public int func_94085_r() {
        return 8;
    }

    public int func_70302_i_() {
        return 18;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        ItemStack filter = this.getFilterItem();
        if (!InvTools.isItemEqual(stack, filter)) {
            return false;
        }
        if (!RailcraftConfig.chestAllowLiquids()) {
            return this.func_70301_a(slot) == null || !FluidItemHelper.isContainer(stack);
        }
        return true;
    }

    @Override
    public boolean canPassItemRequests() {
        return true;
    }

    @Override
    public boolean canAcceptPushedItem(EntityMinecart requester, ItemStack stack) {
        return true;
    }

    @Override
    public boolean canProvidePulledItem(EntityMinecart requester, ItemStack stack) {
        return true;
    }
}

