/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.tracks.locking;

import mods.railcraft.api.carts.CartTools;
import mods.railcraft.common.blocks.tracks.TrackNextGenLocking;
import mods.railcraft.common.blocks.tracks.locking.LockingProfile;
import net.minecraft.entity.item.EntityMinecart;

public class BoardingLockingProfile
extends LockingProfile {
    public BoardingLockingProfile(TrackNextGenLocking track) {
        super(track);
    }

    @Override
    public void onRelease(EntityMinecart cart) {
        super.onRelease(cart);
        int meta = this.track.tileEntity.func_145832_p();
        double speed = CartTools.getCartSpeedUncapped(cart);
        double boostX = TrackNextGenLocking.START_BOOST;
        double boostZ = TrackNextGenLocking.START_BOOST;
        if (speed > 0.005) {
            boostX = Math.abs(cart.field_70159_w) / speed * TrackNextGenLocking.BOOST_FACTOR;
            boostZ = Math.abs(cart.field_70179_y) / speed * TrackNextGenLocking.BOOST_FACTOR;
        }
        if (meta == 0 || meta == 4 || meta == 5) {
            cart.field_70179_y = this.isReversed() ? (cart.field_70179_y += boostZ) : (cart.field_70179_y -= boostZ);
        } else if (meta == 1 || meta == 2 || meta == 3) {
            cart.field_70159_w = this.isReversed() ? (cart.field_70159_w -= boostX) : (cart.field_70159_w += boostX);
        }
    }

    private boolean isReversed() {
        return this.track.getProfileType() == TrackNextGenLocking.LockingProfileType.BOARDING_B || this.track.getProfileType() == TrackNextGenLocking.LockingProfileType.BOARDING_B_TRAIN;
    }
}

