/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.epsilon;

import mods.railcraft.api.electricity.IElectricGrid;
import mods.railcraft.common.blocks.machine.IEnumMachine;
import mods.railcraft.common.blocks.machine.TileMachineBase;
import mods.railcraft.common.blocks.machine.epsilon.EnumMachineEpsilon;
import mods.railcraft.common.plugins.ic2.IC2Plugin;
import mods.railcraft.common.plugins.ic2.ISinkDelegate;
import mods.railcraft.common.plugins.ic2.TileIC2MultiEmitterDelegate;
import mods.railcraft.common.plugins.ic2.TileIC2SinkDelegate;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

public class TileElectricFeeder
extends TileMachineBase
implements IElectricGrid,
ISinkDelegate {
    private final IElectricGrid.ChargeHandler chargeHandler = new IElectricGrid.ChargeHandler(this, IElectricGrid.ChargeHandler.ConnectType.BLOCK, 1.0);
    private TileEntity sinkDelegate;
    private boolean addedToIC2EnergyNet;

    @Override
    public IEnumMachine getMachineType() {
        return EnumMachineEpsilon.ELECTRIC_FEEDER;
    }

    @Override
    public IIcon getIcon(int side) {
        return this.getMachineType().getTexture(0);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (Game.isNotHost(this.getWorld())) {
            return;
        }
        if (!this.addedToIC2EnergyNet) {
            IC2Plugin.addTileToNet(this.getIC2Delegate());
            this.addedToIC2EnergyNet = true;
        }
        this.chargeHandler.tick();
    }

    private void dropFromNet() {
        if (this.addedToIC2EnergyNet) {
            IC2Plugin.removeTileFromNet(this.getIC2Delegate());
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        this.dropFromNet();
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.dropFromNet();
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.chargeHandler.readFromNBT(data);
    }

    @Override
    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        this.chargeHandler.writeToNBT(data);
    }

    @Override
    public IElectricGrid.ChargeHandler getChargeHandler() {
        return this.chargeHandler;
    }

    @Override
    public TileEntity getTile() {
        return this;
    }

    @Override
    public double getDemandedEnergy() {
        double chargeDifference = this.chargeHandler.getCapacity() - this.chargeHandler.getCharge();
        return chargeDifference > 0.0 ? chargeDifference : 0.0;
    }

    @Override
    public int getSinkTier() {
        return 3;
    }

    @Override
    public double injectEnergy(ForgeDirection directionFrom, double amount) {
        this.getChargeHandler().addCharge(amount);
        return 0.0;
    }

    @Override
    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        return !(emitter instanceof TileIC2MultiEmitterDelegate);
    }

    public TileEntity getIC2Delegate() {
        if (this.sinkDelegate == null) {
            try {
                this.sinkDelegate = new TileIC2SinkDelegate(this);
            }
            catch (Throwable error) {
                Game.logErrorAPI("IndustrialCraft", error, new Class[0]);
            }
        }
        return this.sinkDelegate;
    }
}

