/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.api.signals;

import com.google.common.collect.MapMaker;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import mods.railcraft.api.core.WorldCoordinate;
import mods.railcraft.api.signals.SignalTools;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public abstract class AbstractPair {
    protected static final Random rand;
    private static final boolean IS_BUKKIT;
    private static final int SAFE_TIME = 32;
    private static final int PAIR_CHECK_INTERVAL = 16;
    public final TileEntity tile;
    public final String locTag;
    public final int maxPairings;
    protected final Deque<WorldCoordinate> pairings = new LinkedList<WorldCoordinate>();
    protected final Set<WorldCoordinate> invalidPairings = new HashSet<WorldCoordinate>();
    private final Collection<WorldCoordinate> safePairings = Collections.unmodifiableCollection(this.pairings);
    private final Set<WorldCoordinate> pairingsToTest = new HashSet<WorldCoordinate>();
    private final Set<WorldCoordinate> pairingsToTestNext = new HashSet<WorldCoordinate>();
    private final Map<WorldCoordinate, TileEntity> tileCache = new MapMaker().weakValues().makeMap();
    private WorldCoordinate coords;
    private boolean isBeingPaired;
    private int update = rand.nextInt();
    private int ticksExisted;
    private boolean needsInit = true;
    private String name;

    public AbstractPair(String locTag, TileEntity tile, int maxPairings) {
        this.tile = tile;
        this.maxPairings = maxPairings;
        this.locTag = locTag;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name == null || this.name == null || !this.name.equals(name)) {
            this.name = name;
            this.informPairsOfNameChange();
        }
    }

    public void informPairsOfNameChange() {
    }

    public void onPairNameChange(WorldCoordinate coords, String name) {
    }

    protected boolean isLoaded() {
        return this.ticksExisted >= 32;
    }

    protected void addPairing(WorldCoordinate other) {
        this.pairings.remove(other);
        this.pairings.add(other);
        while (this.pairings.size() > this.getMaxPairings()) {
            this.pairings.remove();
        }
        SignalTools.packetBuilder.sendPairPacketUpdate(this);
    }

    public void clearPairing(WorldCoordinate other) {
        this.invalidPairings.add(other);
    }

    public void endPairing() {
        this.isBeingPaired = false;
    }

    public void tickClient() {
        if (this.needsInit) {
            this.needsInit = false;
            SignalTools.packetBuilder.sendPairPacketRequest(this);
        }
    }

    public void tickServer() {
        ++this.update;
        if (!this.isLoaded()) {
            ++this.ticksExisted;
        } else if (this.update % 16 == 0) {
            this.validatePairings();
        }
    }

    protected void validatePairings() {
        if (!this.pairingsToTestNext.isEmpty()) {
            this.pairingsToTestNext.retainAll(this.pairings);
            for (WorldCoordinate coord : this.pairingsToTestNext) {
                int meta;
                int x = coord.x;
                int y = coord.y;
                int z = coord.z;
                World world = this.tile.func_145831_w();
                if (!world.func_72899_e(x, y, z)) continue;
                Block block = world.func_147439_a(x, y, z);
                if (!block.hasTileEntity(meta = world.func_72805_g(x, y, z))) {
                    this.clearPairing(coord);
                    continue;
                }
                TileEntity target = world.func_147438_o(x, y, z);
                if (target == null || this.isValidPair(coord, target)) continue;
                this.clearPairing(coord);
            }
            this.pairingsToTestNext.clear();
        }
        this.cleanPairings();
        for (WorldCoordinate coord : this.pairings) {
            this.getPairAt(coord);
        }
        this.pairingsToTestNext.addAll(this.pairingsToTest);
        this.pairingsToTest.clear();
    }

    public void cleanPairings() {
        if (this.invalidPairings.isEmpty()) {
            return;
        }
        boolean changed = this.pairings.removeAll(this.invalidPairings);
        this.invalidPairings.clear();
        if (changed) {
            SignalTools.packetBuilder.sendPairPacketUpdate(this);
        }
    }

    protected TileEntity getPairAt(WorldCoordinate coord) {
        int meta;
        TileEntity cacheTarget;
        boolean useCache;
        if (!this.pairings.contains(coord)) {
            return null;
        }
        int x = coord.x;
        int y = coord.y;
        int z = coord.z;
        try {
            useCache = !IS_BUKKIT && this.getCoords().isInSameChunk(coord);
        }
        catch (Throwable er) {
            useCache = false;
        }
        if (useCache && (cacheTarget = this.tileCache.get(coord)) != null) {
            if (cacheTarget.func_145837_r() || cacheTarget.field_145851_c != x || cacheTarget.field_145848_d != y || cacheTarget.field_145849_e != z) {
                this.tileCache.remove(coord);
            } else if (this.isValidPair(coord, cacheTarget)) {
                return cacheTarget;
            }
        }
        if (y < 0) {
            this.clearPairing(coord);
            return null;
        }
        World world = this.tile.func_145831_w();
        if (!world.func_72899_e(x, y, z)) {
            return null;
        }
        Block block = world.func_147439_a(x, y, z);
        if (!block.hasTileEntity(meta = world.func_72805_g(x, y, z))) {
            this.pairingsToTest.add(coord);
            return null;
        }
        TileEntity target = world.func_147438_o(x, y, z);
        if (target != null && !this.isValidPair(coord, target)) {
            this.pairingsToTest.add(coord);
            return null;
        }
        if (useCache && target != null) {
            this.tileCache.put(coord, target);
        }
        return target;
    }

    public boolean isValidPair(WorldCoordinate otherCoord, TileEntity otherTile) {
        return false;
    }

    public WorldCoordinate getCoords() {
        if (this.coords == null) {
            this.coords = new WorldCoordinate(this.tile.func_145831_w().field_73011_w.field_76574_g, this.tile.field_145851_c, this.tile.field_145848_d, this.tile.field_145849_e);
        }
        return this.coords;
    }

    public String getLocalizationTag() {
        return this.locTag;
    }

    public int getMaxPairings() {
        return this.maxPairings;
    }

    public int getNumPairs() {
        return this.pairings.size();
    }

    public boolean isPaired() {
        return !this.pairings.isEmpty();
    }

    public Collection<WorldCoordinate> getPairs() {
        return this.safePairings;
    }

    public TileEntity getTile() {
        return this.tile;
    }

    public void startPairing() {
        this.isBeingPaired = true;
    }

    public boolean isBeingPaired() {
        return this.isBeingPaired;
    }

    public boolean isPairedWith(WorldCoordinate other) {
        return this.pairings.contains(other);
    }

    protected abstract String getTagName();

    public final void writeToNBT(NBTTagCompound data) {
        NBTTagCompound tag = new NBTTagCompound();
        this.saveNBT(tag);
        data.func_74782_a(this.getTagName(), (NBTBase)tag);
    }

    protected void saveNBT(NBTTagCompound data) {
        NBTTagList list = new NBTTagList();
        for (WorldCoordinate c : this.pairings) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74783_a("coords", new int[]{c.dimension, c.x, c.y, c.z});
            list.func_74742_a((NBTBase)tag);
        }
        data.func_74782_a("pairings", (NBTBase)list);
        if (this.name != null) {
            data.func_74778_a("name", this.name);
        }
    }

    public final void readFromNBT(NBTTagCompound data) {
        NBTTagCompound tag = data.func_74775_l(this.getTagName());
        this.loadNBT(tag);
    }

    protected void loadNBT(NBTTagCompound data) {
        NBTTagList list = data.func_150295_c("pairings", 10);
        for (int entry = 0; entry < list.func_74745_c(); entry = (int)((byte)(entry + 1))) {
            NBTTagCompound tag = list.func_150305_b(entry);
            int[] c = tag.func_74759_k("coords");
            this.pairings.add(new WorldCoordinate(c[0], c[1], c[2], c[3]));
        }
        this.name = data.func_74779_i("name");
        if (this.name.isEmpty()) {
            this.name = null;
        }
    }

    public void writePacketData(DataOutputStream data) throws IOException {
        data.writeUTF(this.name != null ? this.name : "");
    }

    public void readPacketData(DataInputStream data) throws IOException {
        this.name = data.readUTF();
        if (this.name.isEmpty()) {
            this.name = null;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void addPair(int x, int y, int z) {
        this.pairings.add(new WorldCoordinate(this.tile.func_145831_w().field_73011_w.field_76574_g, x, y, z));
    }

    @SideOnly(value=Side.CLIENT)
    public void removePair(int x, int y, int z) {
        this.pairings.remove(new WorldCoordinate(this.tile.func_145831_w().field_73011_w.field_76574_g, x, y, z));
    }

    public void clearPairings() {
        this.pairings.clear();
        if (!this.tile.func_145831_w().field_72995_K) {
            SignalTools.packetBuilder.sendPairPacketUpdate(this);
        }
    }

    static {
        boolean foundBukkit;
        rand = new Random();
        try {
            foundBukkit = Class.forName("org.spigotmc.SpigotConfig") != null;
        }
        catch (ClassNotFoundException er) {
            foundBukkit = false;
        }
        IS_BUKKIT = foundBukkit;
    }
}

